/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.alex4386.plugin.typhon.TyphonBlueMapUtils;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.VolcanoDataLoader;
import me.alex4386.plugin.typhon.volcano.VolcanoGeoThermal;
import me.alex4386.plugin.typhon.volcano.VolcanoManager;
import me.alex4386.plugin.typhon.volcano.intrusions.VolcanoMetamorphism;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogger;
import me.alex4386.plugin.typhon.volcano.succession.VolcanoSuccession;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoAutoStart;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentGenesis;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.codehaus.plexus.util.FileUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class Volcano
implements Listener {
    public Path basePath;
    public String name;
    long lastSave = System.currentTimeMillis();
    public Location location;
    public boolean isDebug = false;
    public VolcanoDataLoader dataLoader = new VolcanoDataLoader(this);
    public VolcanoLogger logger = new VolcanoLogger(this);
    public VolcanoManager manager = new VolcanoManager(this);
    public VolcanoAutoStart autoStart = new VolcanoAutoStart(this);
    public VolcanoMetamorphism metamorphism = new VolcanoMetamorphism(this);
    public VolcanoGeoThermal geoThermal = new VolcanoGeoThermal(this);
    public VolcanoSuccession succession = new VolcanoSuccession(this);
    public VolcanoVent mainVent = new VolcanoVent(this);
    public Map<String, VolcanoVent> subVents = new HashMap<String, VolcanoVent>();
    public double silicateLevel = 0.63;
    public long updateRate = 20L;
    public int maxEruptions = 3;
    public int fieldRange = 600;

    public Volcano(Path basePath) throws IOException, ParseException {
        this.name = basePath.getFileName().toString();
        this.basePath = basePath;
        if (basePath.toFile().exists()) {
            try {
                this.load();
                this.startup();
            }
            catch (ParseException parseException) {
                this.logger.error(VolcanoLogClass.CORE, "Unable to parse Volcano Config Dir " + basePath.toString() + " for Volcano " + this.name + ". To inspect, please enable debug mode of plugin.");
                throw parseException;
            }
        } else {
            this.logger.error(VolcanoLogClass.CORE, "Unable to find Volcano Config Dir " + basePath.toString() + " for Volcano " + this.name + ".");
            throw new FileNotFoundException("Unable to find Volcano " + this.name + " on path: " + basePath.toString());
        }
    }

    public Volcano(Path basePath, Location loc) throws IOException, ParseException {
        this.name = basePath.getFileName().toString();
        this.basePath = basePath;
        if (basePath.toFile().exists()) {
            try {
                this.load();
                this.startup();
            }
            catch (ParseException parseException) {
                this.logger.error(VolcanoLogClass.CORE, "Unable to parse Volcano Config Dir " + basePath.toString() + " for Volcano " + this.name + ". To inspect, please enable debug mode of plugin.");
                throw parseException;
            }
        } else if (loc != null) {
            this.location = loc;
            this.mainVent.location = loc;
            this.logger.log(VolcanoLogClass.CORE, "Typhon is creating new Volcano " + this.name + ".");
            basePath.toFile().mkdirs();
            this.dataLoader.setupDirectory();
            this.save(true);
            this.logger.log(VolcanoLogClass.CORE, "Typhon created new Volcano " + this.name + "!");
        } else {
            this.logger.error(VolcanoLogClass.CORE, "Unable to find Volcano Config Dir " + basePath.toString() + " for Volcano " + this.name + ".");
            throw new FileNotFoundException("Unable to find Volcano " + this.name + " on path: " + basePath.toString());
        }
    }

    public double getTickFactor() {
        double tickFactor = 20 / (int)this.updateRate;
        return tickFactor;
    }

    public void initialize() {
        this.autoStart.initialize();
        this.geoThermal.initialize();
        this.succession.initialize();
    }

    public void initializeVents() {
        this.mainVent.initialize();
        for (Map.Entry<String, VolcanoVent> entry : this.subVents.entrySet()) {
            String name = entry.getKey();
            VolcanoVent vent = entry.getValue();
            vent.name = name;
            if (!vent.enabled) continue;
            vent.initialize();
        }
    }

    public void startup() {
        this.logger.log(VolcanoLogClass.CORE, "Starting up Volcano sub vents...");
        this.initializeVents();
        this.logger.log(VolcanoLogClass.CORE, "Starting up Volcano...");
        this.initialize();
        this.logger.log(VolcanoLogClass.CORE, "Started up!");
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean runQuickCool) {
        this.logger.log(VolcanoLogClass.CORE, "Shutting down Volcano...");
        List<VolcanoVent> vents = this.manager.getVents();
        for (VolcanoVent vent : vents) {
            vent.shutdown();
            if (!vent.erupt.isErupting() || vent.genesis.canEruptAgain()) continue;
            vent.stop();
        }
        if (runQuickCool) {
            this.logger.log(VolcanoLogClass.CORE, "Running Quickcool due to shutdown... This might take a while...");
            this.quickCool();
        }
        this.autoStart.shutdown();
        this.geoThermal.shutdown();
        this.succession.shutdown();
        this.logger.log(VolcanoLogClass.CORE, "Shutdown Complete!");
    }

    public void quickCool() {
        List<VolcanoVent> vents = this.manager.getVents();
        for (VolcanoVent vent : vents) {
            vent.quickCool();
        }
    }

    public void load() throws IOException, ParseException {
        this.name = this.basePath.getFileName().toString();
        JSONObject autoStartConfig = this.dataLoader.getAutostartConfig();
        this.autoStart.importConfig(autoStartConfig);
        JSONObject coreConfig = this.dataLoader.getCoreConfig();
        this.importConfig(coreConfig);
        JSONObject mainVentConfig = this.dataLoader.getMainVentConfig();
        this.mainVent.importConfig(mainVentConfig);
        Map<String, JSONObject> subVentConfigs = this.dataLoader.getSubVentConfigs();
        for (Map.Entry<String, JSONObject> subVentConfigEntry : subVentConfigs.entrySet()) {
            String ventName = subVentConfigEntry.getKey();
            JSONObject ventConfig = subVentConfigEntry.getValue();
            this.subVents.put(ventName, new VolcanoVent(this, ventConfig));
            this.subVents.get((Object)ventName).name = ventName;
        }
    }

    public void addVolcanoVent(VolcanoVent vent) {
        this.subVents.put(vent.name, vent);
        this.trySave(true);
        TyphonBlueMapUtils.addVolcanoVentOnMap(vent);
    }

    public boolean trySave() {
        return this.trySave(false);
    }

    public boolean trySave(boolean force) {
        try {
            this.save(force);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void save() throws IOException {
        this.save(false);
    }

    public void save(boolean force) throws IOException {
        if (!force) {
            int timeframe = 10;
            if (System.currentTimeMillis() - this.lastSave < (long)(timeframe * 1000)) {
                return;
            }
        }
        this.logger.log(VolcanoLogClass.CORE, "Saving...");
        this.dataLoader.setCoreConfig(this.exportConfig());
        this.dataLoader.setAutostartConfig(this.autoStart.exportConfig());
        this.dataLoader.setMainVentConfig(this.mainVent.exportConfig());
        for (Map.Entry<String, VolcanoVent> subVentEntry : this.subVents.entrySet()) {
            String name = subVentEntry.getKey();
            VolcanoVent vent = subVentEntry.getValue();
            this.dataLoader.setSubVentConfig(name, vent.exportConfig());
        }
        this.logger.log(VolcanoLogClass.CORE, "Save Complete.");
        this.lastSave = System.currentTimeMillis();
    }

    public void delete() throws IOException {
        this.logger.log(VolcanoLogClass.CORE, "Deleting...");
        this.shutdown();
        this.deleteFileSystem();
        TyphonPlugin.listVolcanoes.remove(this.name);
        TyphonBlueMapUtils.removeVolcanoFromMap(this);
        this.logger.log(VolcanoLogClass.CORE, "Delete Complete!");
    }

    private void deleteFileSystem() throws IOException {
        Volcano.deleteFileSystem(this.basePath);
    }

    private static void deleteFileSystem(Path basePath) throws IOException {
        try {
            Class<?> klass = Class.forName("org.apache.commons.io.FileUtils");
            klass.getMethod("deleteDirectory", File.class).invoke(null, basePath.toFile());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            FileUtils.deleteDirectory((File)basePath.toFile());
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException e) {
            FileUtils.deleteDirectory((File)basePath.toFile());
        }
    }

    public void rename(String newName) throws IOException {
        this.logger.log(VolcanoLogClass.CORE, "Renaming...");
        Path basePath = this.basePath;
        TyphonPlugin.listVolcanoes.remove(this.name);
        File volcanoPath = TyphonPlugin.volcanoDir;
        this.name = newName;
        File dir = new File(volcanoPath.getPath(), this.name);
        dir.mkdir();
        this.basePath = dir.toPath();
        TyphonPlugin.listVolcanoes.put(newName, this);
        this.trySave();
        Volcano.deleteFileSystem(basePath);
        this.logger.log(VolcanoLogClass.CORE, "Rename Complete!");
    }

    public void importConfig(JSONObject configData) {
        this.location = TyphonUtils.deserializeLocationForJSON((JSONObject)configData.get("location"));
        this.isDebug = (Boolean)configData.get("isDebug");
        this.updateRate = (Long)configData.get("updateRate");
        this.succession.importConfig((JSONObject)configData.get("succession"));
        this.maxEruptions = (int)((Long)configData.get("maxEruptions")).longValue();
        this.fieldRange = (int)((Long)configData.get("fieldRange")).longValue();
        this.geoThermal.importConfig(configData.getOrDefault("geoThermal", new JSONObject()));
    }

    public JSONObject exportConfig() {
        JSONObject configData = new JSONObject();
        configData.put("location", TyphonUtils.serializeLocationForJSON(this.location));
        configData.put("isDebug", this.isDebug);
        configData.put("updateRate", this.updateRate);
        configData.put("succession", this.succession.exportConfig());
        configData.put("maxEruptions", this.maxEruptions);
        configData.put("fieldRange", this.fieldRange);
        configData.put("geoThermal", this.geoThermal.exportConfig());
        return configData;
    }

    @Deprecated
    public void start() {
        this.initialize();
        this.mainVent.start();
    }

    @Deprecated
    public void stop() {
        List<VolcanoVent> startedVents = this.manager.currentlyStartedVents();
        for (VolcanoVent vent : startedVents) {
            vent.stop();
        }
    }

    public List<VolcanoVent> getEruptingVents() {
        List<VolcanoVent> vents = this.manager.getVents();
        ArrayList<VolcanoVent> eruptingVents = new ArrayList<VolcanoVent>();
        for (VolcanoVent vent : vents) {
            if (!vent.erupt.isErupting()) continue;
            eruptingVents.add(vent);
        }
        return eruptingVents;
    }

    public boolean isVolcanicField() {
        return this.mainVent.genesis == VolcanoVentGenesis.MONOGENETIC;
    }
}

