/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.ash;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.alex4386.plugin.typhon.TyphonQueuedHashMap;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.ash.VolcanoAsh;
import me.alex4386.plugin.typhon.volcano.erupt.VolcanoEruptStyle;
import me.alex4386.plugin.typhon.volcano.intrusions.VolcanoMetamorphism;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoMath;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;

public class VolcanoPyroclasticFlow {
    Location initLocation;
    Location location;
    Vector direction;
    VolcanoAsh ash;
    int minY = Integer.MAX_VALUE;
    int radius;
    int initRadius;
    static int maxRadius = 10;
    int life = 5;
    int maxDistance = -1;
    boolean isStarting = true;
    boolean isFinished = false;
    int scheduleID = -1;
    boolean underTheWater = false;
    double maxPileup = 5.0;
    double awayCount = 0.0;
    Map<Block, Integer> initialY = new HashMap<Block, Integer>();
    HashMap<Block, Boolean> hasAshFell = new HashMap();
    List<BlockDisplay> pyroclasticClouds = new ArrayList<BlockDisplay>();
    TyphonQueuedHashMap<Block, Block> initialBase = new TyphonQueuedHashMap(Integer.MAX_VALUE, TyphonQueuedHashMap::getTwoDimensionalBlock, null, false);

    public void setFull(boolean isFull) {
        this.maxDistance = isFull ? -1 : VolcanoPyroclasticFlow.getMaxDistance(this.ash.vent);
    }

    private Block getBase(Block block) {
        Block currentBase = this.initialBase.get(block);
        if (currentBase != null) {
            return currentBase;
        }
        Block lowestBlock = TyphonUtils.getHighestRocklikes(block);
        this.initialBase.put(block, lowestBlock);
        return lowestBlock;
    }

    private static double getFlowLength(VolcanoVent vent) {
        return vent.getVolcanicRadius();
    }

    public static int getMaxDistance(VolcanoVent vent) {
        if (vent.erupt.getStyle() == VolcanoEruptStyle.PLINIAN) {
            return -1;
        }
        if (Math.random() < vent.fullPyroclasticFlowProbability) {
            return -1;
        }
        double basinCalc = VolcanoPyroclasticFlow.getFlowLength(vent) * 0.5;
        double base = Math.min((double)vent.bombs.getBaseY() * Math.sqrt(3.0), basinCalc);
        base = Math.max(200.0, base);
        double range = base * 0.2 * (Math.pow(Math.random(), 4.0) * 6.0 + 1.0);
        double fullRange = base * 0.2 + range;
        return (int)(base * 0.8 + fullRange * Math.random());
    }

    public static int getMaxLife(VolcanoVent vent, int radius) {
        return (int)(VolcanoPyroclasticFlow.getFlowLength(vent) / (double)radius);
    }

    public VolcanoPyroclasticFlow(Location location, VolcanoAsh ash) {
        this(location, ash, VolcanoPyroclasticFlow.calculateInitialDirection(ash.vent, location));
    }

    public VolcanoPyroclasticFlow(Location location, VolcanoAsh ash, Vector direction) {
        this(location, ash, direction, 5);
    }

    public VolcanoPyroclasticFlow(Location location, VolcanoAsh ash, Vector direction, int radius) {
        this(location, ash, direction, radius, VolcanoPyroclasticFlow.getMaxLife(ash.vent, radius));
    }

    public VolcanoPyroclasticFlow(Location location, VolcanoAsh ash, Vector direction, int radius, int life) {
        this(location, ash, direction, radius, life, VolcanoPyroclasticFlow.getMaxDistance(ash.vent));
    }

    public VolcanoPyroclasticFlow(Location location, VolcanoAsh ash, Vector direction, int radius, int life, int maxDistance) {
        this.minY = location.getBlockY();
        this.initLocation = location;
        this.location = location;
        this.direction = direction;
        this.ash = ash;
        this.radius = radius;
        this.initRadius = radius;
        this.life = life;
        this.maxDistance = maxDistance;
    }

    public void setDirection(Vector direction) {
        this.direction = direction;
    }

    public void registerTask() {
        if (this.scheduleID < 0) {
            this.scheduleID = TyphonScheduler.registerGlobalTask(() -> {
                this.runTick();
                this.processAllPyroclasticClouds();
            }, 2L);
        }
    }

    public void unregisterTask() {
        if (this.scheduleID >= 0) {
            TyphonScheduler.unregisterTask(this.scheduleID);
            this.scheduleID = -1;
        }
    }

    public void initialize() {
        this.ash.vent.getVolcano().logger.debug(VolcanoLogClass.ASH, "Initializing pyroclastic flow @ " + TyphonUtils.blockLocationTostring(this.location.getBlock()));
        this.registerTask();
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean removeMe) {
        this.ash.vent.getVolcano().logger.debug(VolcanoLogClass.ASH, "Shutting down pyroclastic flow @ " + TyphonUtils.blockLocationTostring(this.location.getBlock()));
        this.unregisterTask();
        this.removeAllPyroclasticClouds();
        this.ash.pyroclasticFlows.remove(this);
    }

    public void updateMinY() {
        this.minY = Math.min(this.minY, this.location.getBlockY());
    }

    public static Vector calculateInitialDirection(VolcanoVent vent, Location location) {
        Block coreBlock = vent.getNearestCoreBlock(location);
        Location tmpCoreLoc = coreBlock.getRelative(0, -coreBlock.getY(), 0).getLocation();
        Block srcBlock = location.getBlock();
        Block srcZeroBlock = srcBlock.getRelative(0, -srcBlock.getY(), 0);
        Vector direction = srcZeroBlock.getLocation().toVector().subtract(tmpCoreLoc.toVector());
        Vector baseDirection = direction.normalize();
        double randomizer = Math.random() * 2.0 - 1.0;
        Vector rightAngleDirection = new Vector(baseDirection.getZ(), 0.0, -baseDirection.getX()).normalize().multiply(randomizer * 0.1);
        Vector targetDirection = baseDirection.add(rightAngleDirection).normalize();
        return targetDirection.multiply(1.5 + Math.random());
    }

    public void processAllPyroclasticClouds() {
        for (BlockDisplay bd : this.pyroclasticClouds) {
            this.ash.processAshCloudHeat(bd);
        }
    }

    public void removeAllPyroclasticClouds() {
        for (BlockDisplay bd : this.pyroclasticClouds) {
            if (!bd.isValid()) continue;
            bd.remove();
        }
    }

    public void runTick() {
        if (this.isFinished) {
            return;
        }
        this.runAsh();
        double distance = TyphonUtils.getTwoDimensionalDistance(this.initLocation, this.location);
        if (distance - this.awayCount > 50.0 && Math.random() < 0.2 && this.radius < maxRadius) {
            ++this.radius;
            if (this.maxDistance > 0 && this.maxPileup > 1.0) {
                this.maxPileup -= 1.0;
            }
            this.awayCount = distance;
        }
        if (this.maxDistance >= 0 && distance > (double)this.maxDistance) {
            this.life = 0;
        }
        if (Math.random() < 0.01) {
            --this.life;
        }
        Location prevLoc = this.location;
        if (!this.isStarting) {
            this.calculateDirection();
        } else {
            this.isStarting = false;
        }
        Location tmpLocation = this.location;
        if (Math.random() < 0.1) {
            double angle = Math.random() * Math.PI / 24.0;
            double x = this.direction.getX();
            double z = this.direction.getZ();
            this.direction = new Vector(x * Math.cos(angle) - z * Math.sin(angle), 0.0, x * Math.sin(angle) + z * Math.cos(angle));
        }
        double forward = Math.max(1.0, (double)this.radius / (2.5 + Math.random() * 1.5));
        Vector copiedDirection = new Vector().copy(this.direction);
        copiedDirection.multiply(forward);
        this.location = this.location.add(copiedDirection);
        this.location = this.getBase(this.location.getBlock()).getLocation();
        int climbupLimit = Math.max(1, (int)((double)this.radius * 1.5));
        if (this.location.getY() > tmpLocation.getY() + (double)climbupLimit) {
            this.location = tmpLocation;
            boolean whichWay = Math.random() < 0.5;
            double x = this.direction.getX();
            double z = this.direction.getZ();
            this.direction = new Vector(whichWay ? z : -z, 0.0, whichWay ? -x : x);
            this.location = this.location.add(copiedDirection);
            this.location = this.getBase(this.location.getBlock()).getLocation();
            if (this.location.getY() > tmpLocation.getY() + (double)climbupLimit) {
                this.location = tmpLocation;
                this.direction = new Vector(whichWay ? -z : z, 0.0, whichWay ? x : -x);
                this.location = this.location.add(copiedDirection);
                this.location = this.getBase(this.location.getBlock()).getLocation();
                if (this.location.getY() > tmpLocation.getY() + (double)climbupLimit) {
                    this.location = tmpLocation;
                    this.life = 0;
                }
            }
        }
        this.updateMinY();
        if (this.location.getBlockY() > this.minY + this.radius) {
            this.location = tmpLocation;
            this.life = 0;
        }
        if (this.location.getY() >= prevLoc.getY()) {
            this.life -= (int)(this.location.getY() - prevLoc.getY() + 1.0);
        }
        if (Math.random() < 0.05 && Math.random() < 0.1) {
            this.location.getWorld().playSound(this.location.add(0.0, 3.0, 0.0), Sound.ENTITY_LIGHTNING_BOLT_THUNDER, SoundCategory.WEATHER, 4.0f, 0.5f);
        }
        if (tmpLocation != this.location) {
            // empty if block
        }
        this.ash.vent.getVolcano().logger.debug(VolcanoLogClass.ASH, "ash trail @ " + TyphonUtils.blockLocationTostring(prevLoc.getBlock()) + " -> " + TyphonUtils.blockLocationTostring(this.location.getBlock()));
        if (this.getPercentage() > 0.95 && Math.random() < 0.1) {
            --this.radius;
        }
        this.isFinished = this.finishConditionCheck();
        if (this.isFinished) {
            TyphonScheduler.runDelayed(this.location.getChunk(), () -> this.shutdown(), 40L);
        }
    }

    public double getMaxDistance() {
        return Math.max(this.ash.vent.getBasinLength() + 20.0, (double)this.ash.maxTravelDistance());
    }

    public double getPercentage() {
        double distance = this.ash.vent.getTwoDimensionalDistance(this.location);
        double maxDistance = this.getMaxDistance();
        return distance / maxDistance;
    }

    public boolean finishConditionCheck() {
        int delta;
        if (this.isFinished) {
            return true;
        }
        if (this.life < 0) {
            return true;
        }
        double distance = this.ash.vent.getTwoDimensionalDistance(this.location);
        double maxDistance = this.getMaxDistance();
        return maxDistance + (double)(delta = (int)(Math.pow(Math.random(), 2.0) * 50.0)) <= distance;
    }

    public void calculateDirection() {
        double prevDistance = this.ash.vent.getTwoDimensionalDistance(this.location);
        List<Block> blocks = VolcanoMath.getHollowCircle(this.location.getBlock(), this.radius);
        Block currentBlock = TyphonUtils.getHighestRocklikes(this.location);
        Location directionTarget = this.location.add(this.direction.clone().normalize().multiply(this.radius));
        Block directionBlock = TyphonUtils.getHighestRocklikes(directionTarget);
        if (directionBlock.getY() <= currentBlock.getY()) {
            return;
        }
        Block lowestBlock = TyphonUtils.getHighestRocklikes(blocks.get(0));
        for (Block block : blocks) {
            Block thisBlock = TyphonUtils.getHighestRocklikes(block);
            if (thisBlock.getY() >= lowestBlock.getY() || !(this.ash.vent.getTwoDimensionalDistance(block.getLocation()) >= prevDistance)) continue;
            lowestBlock = block;
        }
        Vector target = lowestBlock.getLocation().subtract(this.location).toVector().setY(0).normalize();
        this.direction.add(target.multiply(0.05));
    }

    public void runAsh() {
        this.processNearby();
        this.putAsh();
        this.playAshTrail();
    }

    public void processNearby() {
        Block awayBlock;
        int targetY;
        Block baseBlock = TyphonUtils.getHighestRocklikes(this.location.getBlock());
        List<Block> blocks = VolcanoMath.getCube(baseBlock, this.radius);
        VolcanoMetamorphism metamorphism = this.ash.vent.volcano.metamorphism;
        for (Block block : blocks) {
            if (TyphonUtils.isMaterialTree(block.getType())) {
                metamorphism.removeTree(block);
            }
            if (!metamorphism.isPlantlike(block.getType()) && !metamorphism.isPlaceableAnimalEgg(block.getType())) continue;
            this.ash.vent.lavaFlow.queueImmediateBlockUpdate(block, Material.AIR);
        }
        int y = baseBlock.getY();
        int minY = (int)((double)y - (double)this.radius / 1.5);
        Vector direction = this.direction.clone().setY(0).normalize();
        Vector perpendicularDirection = new Vector(-direction.getZ(), 0.0, direction.getX());
        if (Math.random() < 0.5) {
            perpendicularDirection.multiply(-1);
        }
        if ((targetY = TyphonUtils.getHighestRocklikes(awayBlock = baseBlock.getLocation().add(perpendicularDirection.multiply(this.radius)).getBlock()).getY()) < minY) {
            TyphonUtils.smoothBlockHeights(baseBlock, (int)((double)this.radius * 1.5), Material.TUFF);
        }
    }

    public void putAsh() {
        if (this.ash.vent.getTwoDimensionalDistance(this.location) < (double)this.ash.vent.getRadius()) {
            return;
        }
        Block baseBlock = this.getBase(this.location.getBlock());
        double safeDistance = TyphonUtils.getTwoDimensionalDistance(this.initLocation, this.location);
        double summitY = Math.max(this.initLocation.getY(), (double)this.ash.vent.getSummitBlock().getY());
        double baseY = Math.max(this.ash.vent.location.getY(), (double)this.ash.vent.location.getWorld().getSeaLevel());
        double basin = Math.max(this.ash.vent.getBasinLength(), VolcanoPyroclasticFlow.getFlowLength(this.ash.vent));
        double scale = (summitY - baseY) / basin;
        double maxHeight = (summitY -= (double)this.initRadius * scale) - safeDistance * scale;
        Vector srcDirection = new Vector().copy(this.direction).normalize();
        srcDirection.setY(0);
        HashSet<Block> processedBlocks = new HashSet<Block>();
        for (double x = (double)(-this.radius); x <= (double)this.radius; x += 1.0) {
            for (double z = (double)(-this.radius); z <= (double)this.radius; z += 1.0) {
                Block target;
                double rotatedZ;
                double rotatedX = x * srcDirection.getX() - z * srcDirection.getZ();
                Block targetBase = baseBlock.getRelative((int)rotatedX, 0, (int)(rotatedZ = x * srcDirection.getZ() + z * srcDirection.getX()));
                if (processedBlocks.contains(targetBase)) continue;
                processedBlocks.add(targetBase);
                double distanceFromCenterLine = Math.abs(z);
                double heightFactor = 1.0 - distanceFromCenterLine / (double)this.radius;
                heightFactor = Math.max(0.0, heightFactor);
                int ashHeight = (int)((double)this.initRadius / 2.0 * heightFactor);
                Block baseBlockHere = this.getBase(targetBase);
                if ((double)baseBlockHere.getY() > maxHeight) continue;
                boolean hasUnderTheWater = false;
                if (ashHeight > 0) {
                    for (int y = 1; y <= ashHeight; ++y) {
                        Block targetBlock = baseBlockHere.getRelative(0, y, 0);
                        if ((double)targetBlock.getY() > Math.min((double)(baseBlock.getY() + ashHeight), maxHeight)) continue;
                        this.ash.vent.lavaFlow.queueBlockUpdate(targetBlock, Material.TUFF);
                        this.ash.vent.record.addEjectaVolume(1);
                    }
                    if (!this.underTheWater) {
                        if (baseBlockHere.getY() + ashHeight > baseBlockHere.getWorld().getSeaLevel()) {
                            this.updateLongestFlow(baseBlockHere.getLocation());
                        } else {
                            hasUnderTheWater = true;
                        }
                    }
                } else if (Math.random() < 0.2 && VolcanoMetamorphism.isNaturalSoil((target = TyphonUtils.getHighestRocklikes(baseBlockHere)).getType())) {
                    this.ash.vent.lavaFlow.queueBlockUpdate(target, Material.TUFF);
                }
                if (!hasUnderTheWater) continue;
                this.underTheWater = true;
            }
        }
    }

    private void updateLongestFlow(Location location) {
        double distance = this.ash.vent.getTwoDimensionalDistance(location);
        if (distance > this.ash.vent.currentAshNormalFlowLength) {
            this.ash.vent.currentAshNormalFlowLength = distance;
        }
        if (distance > this.ash.vent.longestAshNormalFlowLength) {
            this.ash.vent.longestAshNormalFlowLength = distance;
        }
    }

    public void playAshTrail() {
        int ashTrailRadius = this.radius * 2;
        float radiusHalf = (float)ashTrailRadius / 2.0f;
        BlockDisplay bd = (BlockDisplay)this.location.getWorld().spawn(this.location, BlockDisplay.class, _bd -> {
            _bd.setBlock(Material.TUFF.createBlockData());
            _bd.setTransformation(new Transformation(new Vector3f(-radiusHalf, -radiusHalf, -radiusHalf), new AxisAngle4f(), new Vector3f((float)ashTrailRadius, (float)ashTrailRadius, (float)ashTrailRadius), new AxisAngle4f()));
        });
        this.pyroclasticClouds.add(bd);
        TyphonScheduler.runDelayed(bd.getChunk(), () -> bd.remove(), 60L);
    }

    public Block get2DBlock(Block block) {
        int y = this.ash.vent.location.getBlock().getY();
        return block.getRelative(0, y - block.getY(), 0);
    }
}

