/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.bomb;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import me.alex4386.plugin.typhon.TyphonBlocks;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.VolcanoComposition;
import me.alex4386.plugin.typhon.volcano.bomb.VolcanoBombListener;
import me.alex4386.plugin.typhon.volcano.bomb.VolcanoBombs;
import me.alex4386.plugin.typhon.volcano.lavaflow.VolcanoLavaFlow;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoMath;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentStatus;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class VolcanoBomb {
    public VolcanoVent vent;
    public Location launchLocation;
    public float bombPower;
    FallingBlock block;
    public int bombRadius;
    public int bombTrailScheduleId;
    public Location landingLocation;
    public Location targetLocation;
    public Location prevLocation = null;
    public int bombDelay;
    public boolean isTrailOn = false;
    public int explodeTimer = -1;
    public int heatTimer = 15;
    public int lifeTime = 0;
    public static Material defaultBombMaterial = Material.MAGMA_BLOCK;
    private int lifeTimeRed = 20;
    Material targetMaterial = null;
    public boolean isLanded = false;

    public VolcanoBomb(VolcanoVent vent, Location loc, Location targetLocation, float bombPower, int bombRadius, int bombDelay) {
        this.vent = vent;
        this.bombPower = bombPower;
        this.bombRadius = bombRadius;
        this.bombDelay = bombDelay;
        this.launchLocation = loc;
        this.targetLocation = targetLocation;
        double randomMultiplier = 1.0 + Math.random() * 0.25;
        this.heatTimer = (int)(15.0 * randomMultiplier);
        this.lifeTimeRed = (int)(20.0 * randomMultiplier);
    }

    public double getDistanceRatio() {
        return this.getDistanceRatio(this.landingLocation);
    }

    public double getDistanceRatio(Location location) {
        if (this.vent == null) {
            return 1.0;
        }
        return this.vent.lavaFlow.getDistanceRatio(location);
    }

    public Team getAdequateTeam() {
        if (this.heatTimer > 0) {
            return VolcanoBombs.bombGlowYellow;
        }
        if (this.lifeTime < this.lifeTimeRed) {
            return VolcanoBombs.bombGlowGold;
        }
        return VolcanoBombs.bombGlowRed;
    }

    public void removeFromOthers() {
        if (this.block == null) {
            return;
        }
        if (VolcanoBombs.bombGlowYellow != null) {
            VolcanoBombs.bombGlowYellow.removeEntity((Entity)this.block);
        }
        if (VolcanoBombs.bombGlowGold != null) {
            VolcanoBombs.bombGlowGold.removeEntity((Entity)this.block);
        }
        if (VolcanoBombs.bombGlowRed != null) {
            VolcanoBombs.bombGlowRed.removeEntity((Entity)this.block);
        }
    }

    public void updateTeam() {
        if (this.block == null) {
            return;
        }
        try {
            this.removeFromOthers();
            this.getAdequateTeam().addEntity((Entity)this.block);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void customLaunch(Vector launchVector) {
        try {
            this.block = (FallingBlock)this.launchLocation.getWorld().spawn(this.launchLocation, FallingBlock.class, entity -> {
                FallingBlock block = entity;
                block.setGlowing(true);
                block.setInvulnerable(true);
                block.setMetadata("DropItem", (MetadataValue)new FixedMetadataValue(TyphonPlugin.plugin, (Object)0));
                block.setDropItem(false);
                block.setGravity(true);
                block.setVelocity(launchVector);
                BlockState state = block.getBlockState();
                state.setType(defaultBombMaterial);
                block.setBlockState(state);
                block.setFireTicks(1000);
            });
            this.updateTeam();
        }
        catch (Exception e) {
            if (this.block != null) {
                this.block.remove();
            }
            this.land();
            return;
        }
        this.vent.getVolcano().logger.debug(VolcanoLogClass.BOMB_LAUNCHER, "Volcanic Bomb Just launched from: " + TyphonUtils.blockLocationTostring(this.launchLocation.getBlock()));
    }

    public void launch() {
        int maxY = this.vent.getSummitBlock().getY();
        int yToLaunch = maxY - this.launchLocation.getWorld().getHighestBlockYAt(this.launchLocation);
        double explosionScale = Math.pow(this.vent.erupt.getStyle().bombMultiplier / 5.0, 0.8);
        if (yToLaunch < 2) {
            yToLaunch = 2;
        }
        this.launchWithCustomHeight(yToLaunch + 3 + (int)((0.5 + Math.random()) * 9.0 * explosionScale));
    }

    public void launchWithCustomHeight(int launchHeight) {
        Vector launchVector = TyphonUtils.calculateVelocity(new Vector(0, 0, 0), this.targetLocation.toVector().subtract(this.launchLocation.toVector()), launchHeight);
        this.customLaunch(launchVector);
    }

    public double getLifetimeSeconds() {
        return (double)this.lifeTime / (double)VolcanoBombListener.updatesPerSeconds;
    }

    public void createSmoke() {
        if (this.block != null) {
            Location loc = this.block.getLocation();
            loc.getWorld().spawnParticle(Particle.LAVA, loc, 1);
        }
    }

    public void handleHeat() {
        if (this.heatTimer > 0) {
            --this.heatTimer;
        }
        if (this.heatTimer == 0) {
            this.coolDownFallingBlock();
        }
    }

    public void startTrail() {
        if (!this.isTrailOn && this.block != null) {
            this.bombTrailScheduleId = TyphonScheduler.registerTask(this.block.getChunk(), () -> this.createSmoke(), 1L);
            this.isTrailOn = true;
        }
    }

    public void stopTrail() {
        if (this.isTrailOn && this.block != null) {
            TyphonScheduler.unregisterTask(this.bombTrailScheduleId);
            this.isTrailOn = false;
        }
    }

    public void coolDownFallingBlock() {
        BlockState state;
        this.heatTimer = 0;
        if (this.block != null && (state = this.block.getBlockState()).getType() == defaultBombMaterial) {
            state.setType(VolcanoComposition.getBombRock(this.vent.lavaFlow.settings.silicateLevel, this.getDistanceRatio()));
            this.block.setBlockState(state);
        }
    }

    public void skipMe() {
        if (this.block != null) {
            this.coolDownFallingBlock();
            this.block.remove();
            this.isLanded = true;
            TyphonBlocks.setBlockType(this.block.getLocation().getBlock(), Material.AIR);
        }
    }

    public void emergencyLand() {
        this.isLanded = true;
        if (this.block != null) {
            this.block.remove();
        }
        this.block = null;
        this.land();
    }

    public void land() {
        double error;
        Volcano volcano = this.vent.getVolcano();
        if (this.targetLocation != null && this.landingLocation == null) {
            this.landingLocation = this.targetLocation;
        }
        if (this.block != null) {
            this.landingLocation = this.block.getLocation();
        } else if (this.landingLocation == null) {
            this.isLanded = true;
            if (this.block != null) {
                this.coolDownFallingBlock();
                this.block.remove();
            }
            return;
        }
        Material targetMaterial = VolcanoComposition.getBombRock(this.vent.lavaFlow.settings.silicateLevel, this.getDistanceRatio());
        if (this.block != null) {
            BlockState state = this.block.getBlockState();
            if (state.getType() == defaultBombMaterial) {
                targetMaterial = VolcanoComposition.getBombRock(this.vent.lavaFlow.settings.silicateLevel, this.getDistanceRatio());
                state.setType(targetMaterial);
                this.block.setBlockState(state);
            } else {
                targetMaterial = state.getType();
            }
            this.block.remove();
        }
        this.targetMaterial = targetMaterial;
        if (!this.isLanded) {
            this.isLanded = true;
        }
        if (this.targetLocation != null && (error = TyphonUtils.getTwoDimensionalDistance(this.landingLocation, this.targetLocation)) > 7.0) {
            this.vent.getVolcano().logger.debug(VolcanoLogClass.BOMB, "Volcano Bomb targetted for " + TyphonUtils.blockLocationTostring(this.targetLocation.getBlock()) + " is wrongly landed at " + TyphonUtils.blockLocationTostring(this.block.getLocation().getBlock()) + ". Relocating.");
            this.landingLocation = this.targetLocation.getWorld().getHighestBlockAt(this.targetLocation).getLocation().add(0.0, 1.0, 0.0);
        }
        Block block = this.landingLocation.getBlock();
        while (!TyphonUtils.isMaterialRocklikes(block.getRelative(BlockFace.DOWN).getType())) {
            if (block.getY() < TyphonUtils.getMinimumY(block.getWorld())) {
                return;
            }
            if (TyphonUtils.isMaterialTree(block.getType())) {
                this.vent.volcano.metamorphism.removeTree(block);
                TyphonUtils.getHighestNonTreeSolid(block).getLocation();
            }
            if (this.vent != null) {
                VolcanoLavaFlow flow = this.vent.lavaFlow;
                flow.queueImmediateBlockUpdate(block, Material.AIR);
            } else {
                TyphonBlocks.setBlockType(block, Material.AIR);
            }
            block = block.getRelative(BlockFace.DOWN);
        }
        this.landingLocation = block.getLocation();
        Location loc = block.getLocation();
        VolcanoVent nearestVent = this.vent.getVolcano().manager.getNearestVent(loc);
        double distance = TyphonUtils.getTwoDimensionalDistance(nearestVent.getNearestCoreBlock(loc).getLocation(), loc);
        if (!VolcanoBombListener.groundChecker(loc, this.bombRadius)) {
            volcano.logger.debug(VolcanoLogClass.BOMB_LAUNCHER, "Volcanic Bomb from " + TyphonUtils.blockLocationTostring(this.launchLocation.getBlock()) + " did not landed properly at " + TyphonUtils.blockLocationTostring(block));
            this.isLanded = true;
            return;
        }
        if (nearestVent.getStatus() == VolcanoVentStatus.ERUPTING) {
            int summitRange;
            if (distance < (double)nearestVent.craterRadius && !TyphonPlugin.isShuttingdown) {
                VolcanoBomb bomb = this.vent.bombs.generateBomb();
                bomb.land();
            }
            if (distance < (double)(summitRange = nearestVent.craterRadius + (int)Math.max(Math.min((double)nearestVent.craterRadius * 0.5, 20.0), 10.0))) {
                if (this.block != null) {
                    this.block.remove();
                }
                if (TyphonPlugin.isShuttingdown) {
                    return;
                }
                Block targetVentBlock = nearestVent.requestFlow();
                if (targetVentBlock.getType() != Material.LAVA) {
                    if ((targetVentBlock = targetVentBlock.getRelative(BlockFace.UP)).getType() == Material.LAVA) {
                        return;
                    }
                    nearestVent.lavaFlow.flowVentLavaFromBomb(targetVentBlock);
                    nearestVent.flushSummitCache();
                }
                return;
            }
        }
        if (this.vent.volcano.manager.isInAnyFormingCaldera(loc)) {
            return;
        }
        this.stopTrail();
        if (this.vent != null) {
            if (this.vent.bombs.maxDistance < this.vent.getTwoDimensionalDistance(this.targetLocation)) {
                this.vent.bombs.maxDistance = this.vent.getTwoDimensionalDistance(this.targetLocation);
            }
            if (this.block != null && this.vent.isInVent(this.block.getLocation())) {
                this.block.remove();
                this.vent.lavaFlow.queueImmediateBlockUpdate(this.block.getLocation().getBlock(), Material.AIR);
            }
        }
        if (TyphonPlugin.isShuttingdown) {
            this.buildBomb(false);
            return;
        }
        if (this.landingLocation.getBlock().getChunk().getInhabitedTime() > 0L) {
            this.buildBomb();
            this.explodeTimer = TyphonPlugin.minecraftTicksPerSeconds * this.bombDelay;
        } else {
            this.buildBomb(false);
        }
    }

    public void buildBomb() {
        this.buildBomb(true);
    }

    public void buildBomb(boolean flowLava) {
        Block temp;
        Block finalBlock;
        int totalEjecta = 0;
        VolcanoLavaFlow lavaFlow = this.vent.lavaFlow;
        if (flowLava) {
            lavaFlow.registerEvent();
            lavaFlow.registerTask();
        }
        if (!(finalBlock = this.landingLocation.getBlock()).getRelative(BlockFace.DOWN).getType().isBlock() && (temp = TyphonUtils.getHighestRocklikes(finalBlock).getRelative(BlockFace.UP)).getY() < finalBlock.getY()) {
            finalBlock = temp;
        }
        int baseFlowLimit = Math.max(this.bombRadius / 2, 2);
        if (this.bombRadius <= 1) {
            List<Block> bomb = VolcanoMath.getSphere(finalBlock, this.bombRadius);
            if (flowLava) {
                for (Block bombBlock : bomb) {
                    lavaFlow.flowLavaFromBomb(bombBlock, baseFlowLimit);
                }
                finalBlock.getWorld().createExplosion(finalBlock.getLocation(), 1.0f, true, false);
            } else {
                for (Block bombBlock : bomb) {
                    Material material = VolcanoComposition.getBombRock(lavaFlow.settings.silicateLevel, this.getDistanceRatio(finalBlock.getLocation(bombBlock.getLocation())));
                    if (this.targetMaterial != null) {
                        material = this.targetMaterial;
                    }
                    if (this.vent == null) {
                        TyphonBlocks.setBlockType(bombBlock, material);
                        continue;
                    }
                    this.vent.lavaFlow.queueBlockUpdate(bombBlock, material);
                }
            }
            totalEjecta = bomb.size();
        } else {
            List<Block> bomb = VolcanoMath.getSphere(finalBlock, this.bombRadius);
            for (Block bombBlock : bomb) {
                Random random = new Random();
                Material material = VolcanoComposition.getBombRock(lavaFlow.settings.silicateLevel, this.getDistanceRatio());
                switch (random.nextInt(3)) {
                    case 0: {
                        material = null;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (!flowLava) break;
                        lavaFlow.flowLavaFromBomb(bombBlock);
                        material = null;
                    }
                }
                if (material == null) continue;
                if (this.vent == null) {
                    TyphonBlocks.setBlockType(bombBlock, material);
                    continue;
                }
                this.vent.lavaFlow.queueBlockUpdate(bombBlock, material);
            }
            totalEjecta = bomb.size();
        }
        this.vent.record.addEjectaVolume(totalEjecta);
    }

    public void explode() {
        Volcano volcano = this.vent.getVolcano();
        if (this.bombRadius >= 1) {
            Block bombCenter = this.landingLocation.add(0.0, (double)this.bombRadius, 0.0).getBlock();
            volcano.logger.debug(VolcanoLogClass.BOMB, "Volcanic Bomb from " + TyphonUtils.blockLocationTostring(this.launchLocation.getBlock()) + " just exploded at " + TyphonUtils.blockLocationTostring(this.landingLocation.getBlock()) + " with Power: " + this.bombPower + ", radius: " + this.bombRadius + ", lifeTime: " + this.lifeTime + " (= " + this.getLifetimeSeconds() + "s)");
            if (this.vent != null) {
                boolean shouldExplode = true;
                if (this.vent.erupt.getStyle().lavaMultiplier == 0.0) {
                    int height = Math.max(0, this.vent.getSummitBlock().getY() - this.vent.location.getBlockY());
                    if (this.vent.getTwoDimensionalDistance(bombCenter.getLocation()) <= (double)height * Math.sqrt(3.0)) {
                        shouldExplode = false;
                    }
                }
                if (shouldExplode) {
                    VolcanoBombListener.lavaSplashExplosions.put(bombCenter.getLocation().getBlock(), this.vent);
                    this.landingLocation.getWorld().createExplosion(bombCenter.getLocation(), this.bombPower, true, !volcano.manager.isInAnyVent(this.landingLocation));
                }
            }
            if (this.bombRadius > 4) {
                List<Block> circle = VolcanoMath.getCircle(bombCenter, this.bombRadius * 2, this.bombRadius + 1);
                Random random = new Random();
                int lavaSpread = random.nextInt(this.bombRadius * 2);
                Collections.shuffle(circle);
                for (int i = 0; i < lavaSpread; ++i) {
                    Block block = TyphonUtils.getHighestOceanFloor(circle.get(i).getLocation()).getBlock();
                    this.vent.lavaFlow.flowLavaFromBomb(block);
                }
            }
        }
        this.isLanded = true;
    }
}

