/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.commands;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.alex4386.plugin.typhon.TyphonCommand;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.commands.VolcanoCommandAction;
import me.alex4386.plugin.typhon.volcano.commands.VolcanoCommandUtils;
import me.alex4386.plugin.typhon.volcano.commands.VolcanoMessage;
import me.alex4386.plugin.typhon.volcano.commands.VolcanoVentCommand;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.json.simple.parser.ParseException;

public class VolcanoCommand {
    Volcano volcano;

    public VolcanoCommand(Volcano volcano) {
        this.volcano = volcano;
    }

    public VolcanoCommand(String string) throws ClassNotFoundException {
        Volcano volcano = TyphonPlugin.listVolcanoes.get(string);
        if (volcano == null) {
            throw new ClassNotFoundException();
        }
        this.volcano = volcano;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length >= 2) {
            VolcanoCommandAction action;
            String operationName = args[1];
            if (args.length == 2) {
                return TyphonCommand.search(operationName, VolcanoCommandAction.listAll(sender));
            }
            if (args.length >= 3 && (action = VolcanoCommandAction.getAction(operationName)) != null) {
                if (action.equals((Object)VolcanoCommandAction.SUB_VENT)) {
                    VolcanoVent vent;
                    if (args.length == 3) {
                        String query = args[2];
                        if (TyphonCommand.hasPermission(sender, "vent.list")) {
                            return TyphonCommand.search(query, this.volcano.subVents.keySet());
                        }
                    } else if (args.length >= 4 && (vent = this.volcano.subVents.get(args[2])) != null) {
                        VolcanoVentCommand cmd = new VolcanoVentCommand(vent, false);
                        return cmd.onTabComplete(sender, command, label, args);
                    }
                } else {
                    if (action.equals((Object)VolcanoCommandAction.AUTO_START)) {
                        String[] values = new String[]{"enable", "disable"};
                        return Arrays.asList((String[])values.clone());
                    }
                    if (action.equals((Object)VolcanoCommandAction.MAIN_VENT)) {
                        VolcanoVent vent = this.volcano.mainVent;
                        if (vent != null) {
                            VolcanoVentCommand cmd = new VolcanoVentCommand(vent, true);
                            return cmd.onTabComplete(sender, command, label, args);
                        }
                    } else if (action.equals((Object)VolcanoCommandAction.CREATE)) {
                        if (args.length == 3) {
                            String[] types = new String[]{"crater", "fissure", "flank", "autovent"};
                            return Arrays.asList((String[])types.clone());
                        }
                        if (args.length > 3) {
                            String option = args[2];
                            if (option.toLowerCase().equals("crater")) {
                                String[] result = new String[]{"<name>"};
                                return Arrays.asList(result);
                            }
                            if (option.toLowerCase().equals("flank")) {
                                if (args.length == 4) {
                                    String[] result = new String[]{"<name>"};
                                    return Arrays.asList(result);
                                }
                            } else if (option.toLowerCase().equals("autovent") && args.length == 4) {
                                String[] result = new String[]{"<playerName>"};
                                return Arrays.asList(result);
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block61: {
            block58: {
                block59: {
                    block60: {
                        if (args.length < 2) break block58;
                        operationName = args[1];
                        action = VolcanoCommandAction.getAction(operationName);
                        msg = new VolcanoMessage(this.volcano, sender);
                        ventCmd = null;
                        if (action == null) break block59;
                        if (!action.hasPermission(sender)) break block60;
                        switch (1.$SwitchMap$me$alex4386$plugin$typhon$volcano$commands$VolcanoCommandAction[action.ordinal()]) {
                            case 1: {
                                msg.warn(sender, "Using Volcano's default start/stop has been deprecated.");
                                msg.warn(sender, "Please, Use /volcano " + this.volcano.name + " mainVent start");
                                this.volcano.start();
                                msg.ok(sender, "Volcano " + this.volcano.name + " has started!");
                                break;
                            }
                            case 2: {
                                msg.warn(sender, "Using Volcano's default start/stop has been deprecated.");
                                msg.warn(sender, "Please, Use /volcano " + this.volcano.name + " mainVent stop");
                                this.volcano.stop();
                                msg.ok(sender, "Volcano " + this.volcano.name + " has stopped!");
                                break;
                            }
                            case 3: {
                                prevName = this.volcano.name;
                                try {
                                    newName = args[2];
                                    this.volcano.rename(newName);
                                }
                                catch (IOException e) {
                                    msg.error(sender, "Volcano " + prevName + " has failed to rename!");
                                    e.printStackTrace();
                                }
                            }
                            case 4: {
                                try {
                                    this.volcano.delete();
                                    msg.ok(sender, "Volcano " + this.volcano.name + " has been deleted!");
                                }
                                catch (IOException e) {
                                    msg.error(sender, "Volcano " + this.volcano.name + " has failed to delete!");
                                    e.printStackTrace();
                                }
                                break;
                            }
                            case 5: {
                                this.volcano.shutdown();
                                msg.ok(sender, "Volcano " + this.volcano.name + " has been shut down!");
                                break;
                            }
                            case 6: {
                                this.volcano.quickCool();
                                msg.ok(sender, "Volcano " + this.volcano.name + " has cooled all flowing lava!");
                                break;
                            }
                            case 7: {
                                if (args.length != 2) ** GOTO lbl51
                                msg.info("AutoStart: " + (this.volcano.autoStart.canAutoStart != false ? "enabled" : "disabled"));
                                ** GOTO lbl59
lbl51:
                                // 1 sources

                                value = args[2];
                                if (!value.equalsIgnoreCase("enable")) ** GOTO lbl56
                                this.volcano.autoStart.canAutoStart = true;
                                msg.ok("AutoStart has been enabled!");
                                ** GOTO lbl59
lbl56:
                                // 1 sources

                                if (value.equalsIgnoreCase("disable")) {
                                    this.volcano.autoStart.canAutoStart = false;
                                    msg.ok("AutoStart has been disabled!");
                                }
                            }
lbl59:
                            // 6 sources

                            case 8: {
                                if (args.length >= 3) {
                                    if (args[2].equals("trigger")) {
                                        if (sender instanceof Player) {
                                            player = (Player)sender;
                                            this.volcano.succession.runSuccession(player.getLocation().getBlock(), true);
                                            msg.ok("Primary Succession has been triggered at your location");
                                            break;
                                        }
                                        msg.error("This command can not be used by console.");
                                        break;
                                    }
                                    state = Boolean.parseBoolean(args[2]);
                                    if (args[2].equalsIgnoreCase("enable")) {
                                        state = true;
                                    } else if (args[2].equalsIgnoreCase("disable")) {
                                        state = false;
                                    }
                                    this.volcano.succession.setEnabled(state);
                                    if (state) {
                                        msg.ok("Primary Succession has been enabled!");
                                    } else {
                                        msg.ok("Primary Succession has been disabled!");
                                    }
                                    this.volcano.trySave(true);
                                    break;
                                }
                                msg.info("Primary Succession: " + (this.volcano.succession.isEnabled() != false ? "enabled" : "disabled"));
                                break;
                            }
                            case 9: {
                                if (sender instanceof Entity) {
                                    senderEntity = (Entity)sender;
                                    this.volcano.mainVent.teleport(senderEntity);
                                    msg.ok("You have been teleported to mainVent of Volcano " + this.volcano.name);
                                    break;
                                }
                                msg.error("This command can not be used by console.");
                                break;
                            }
                            case 10: {
                                if (sender instanceof Player) {
                                    player = (Player)sender;
                                    location = player.getLocation();
                                    nearestVent = this.volcano.manager.getNearestVent(location);
                                    msg.info("Nearest Vent: " + nearestVent.getName() + " @ " + String.format("%.2f", new Object[]{nearestVent.getTwoDimensionalDistance(location)}) + "m");
                                    msg.info("Status  : " + String.valueOf(this.volcano.manager.getVentChatColor(nearestVent)) + nearestVent.getStatus().toString());
                                    msg.info("LavaFlow: " + (String)(this.volcano.manager.isInAnyLavaFlow(location) != false ? String.valueOf(ChatColor.RED) + "Affected" : "Not Affected"));
                                    msg.info("Bombs   : " + (String)(this.volcano.manager.isInAnyBombAffected(location) != false ? String.valueOf(ChatColor.RED) + "Affected" : "Not Affected"));
                                    break;
                                }
                                msg.error("This command can not be used by console.");
                                break;
                            }
                            case 11: {
                                if (args.length < 4) ** GOTO lbl152
                                type = args[2];
                                name = args[3];
                                if (sender instanceof Player) {
                                    player = (Player)sender;
                                    if (type.equalsIgnoreCase("crater")) {
                                        if (this.volcano.subVents.get(name) == null) {
                                            vent = new VolcanoVent(this.volcano, player.getLocation(), name);
                                            vent.setType(VolcanoVentType.CRATER);
                                            this.volcano.addVolcanoVent(vent);
                                            vent.initialize();
                                            msg.ok("Vent " + vent.name + " has been created!");
                                            break;
                                        }
                                        msg.error(sender, "Vent " + name + " already exists on Volcano " + this.volcano.name + "!");
                                        break;
                                    }
                                    if (type.equalsIgnoreCase("fissure")) {
                                        if (this.volcano.subVents.get(name) == null) {
                                            vent = new VolcanoVent(this.volcano, player.getLocation(), name);
                                            vent.setType(VolcanoVentType.FISSURE);
                                            vent.lavaFlow.settings.silicateLevel = 0.45;
                                            this.volcano.subVents.put(name, vent);
                                            vent.initialize();
                                            msg.ok("Vent " + vent.name + " has been created!");
                                            break;
                                        }
                                        msg.error(sender, "Vent " + name + " already exists on Volcano " + this.volcano.name + "!");
                                        break;
                                    }
                                    if (type.equalsIgnoreCase("flank")) {
                                        if (this.volcano.subVents.get(name) == null) {
                                            if (this.volcano.autoStart.canDoFlankEruption()) {
                                                vent = this.volcano.mainVent.erupt.openFissure();
                                                if (vent != null) {
                                                    vent.shutdown();
                                                    this.volcano.subVents.remove(vent.name);
                                                    this.volcano.addVolcanoVent(vent);
                                                    vent.initialize();
                                                    msg.ok("Vent " + vent.name + " has been created!");
                                                    break;
                                                }
                                                msg.error(sender, "Failed to generate flank eruption vent " + name + " on Volcano " + this.volcano.name + "! Try it again.");
                                                break;
                                            }
                                            msg.error(sender, "Volcano " + this.volcano.name + " is incapable of creating flank eruption!");
                                            break;
                                        }
                                        msg.error(sender, "Vent " + name + " already exists on Volcano " + this.volcano.name + "!");
                                        break;
                                    }
                                }
                                break block61;
lbl152:
                                // 1 sources

                                msg.error(sender, "Not enough arguments for command " + action.getCommand());
                                msg.error(sender, String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Usage: " + String.valueOf(ChatColor.RESET) + "/vol " + this.volcano.name + " create " + String.valueOf(ChatColor.YELLOW) + "<crater | fissure>" + String.valueOf(ChatColor.GRAY) + " <name> ...");
                                break;
                            }
                            case 12: {
                                msg.info("C.Ejecta: " + this.volcano.manager.getCurrentEjecta() + " blocks (VEI: " + TyphonUtils.getVEIScale(this.volcano.manager.getCurrentEjecta()) + ")");
                                msg.info("Ejecta  : " + this.volcano.manager.getTotalEjecta() + " blocks (VEI: " + TyphonUtils.getVEIScale(this.volcano.manager.getTotalEjecta()) + ")");
                                break;
                            }
                            case 13: {
                                ventCmd = new VolcanoVentCommand(this.volcano.mainVent, true);
                                return ventCmd.onCommand(sender, command, label, args);
                            }
                            case 14: {
                                if (args.length >= 3) {
                                    subVentName = args[2];
                                    subVent = this.volcano.subVents.get(subVentName);
                                    if (subVent != null) {
                                        subVent.name = subVentName;
                                        ventCmd = new VolcanoVentCommand(subVent, false);
                                        return ventCmd.onCommand(sender, command, label, args);
                                    }
                                    msg.error(sender, "Subvent " + subVentName + " doesn't exist on volcano " + this.volcano.name);
                                    break;
                                }
                                sender.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Plugin] " + String.valueOf(ChatColor.GOLD) + "Volcano Vents");
                                for (Map.Entry<String, VolcanoVent> subVent : this.volcano.subVents.entrySet()) {
                                    ventName = subVent.getKey();
                                    vent = subVent.getValue();
                                    isExploding = vent.isExploding();
                                    isFlowing = vent.isFlowingLava();
                                    ventState = isFlowing != false && isExploding != false ? ChatColor.GOLD : (isFlowing != false ? ChatColor.RED : (isExploding != false ? ChatColor.YELLOW : ChatColor.RESET));
                                    sender.sendMessage(" - " + String.valueOf(ventState) + ventName + String.valueOf(ChatColor.RESET) + ": " + String.valueOf(this.volcano.manager.getVentChatColor(vent)) + vent.getStatus().toString());
                                }
                                break block61;
                            }
                            case 15: {
                                if (args.length == 3) {
                                    this.volcano.updateRate = Integer.parseInt(args[2]);
                                    this.volcano.shutdown(true);
                                    this.volcano.startup();
                                }
                                msg.info("Volcano " + this.volcano.name + "'s updaterate = " + this.volcano.updateRate + " ticks.");
                                break;
                            }
                            case 16: {
                                sender.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Plugin] " + String.valueOf(ChatColor.GOLD) + "Volcano Summit of " + this.volcano.name);
                                summitVent = this.volcano.manager.getSummitVent();
                                VolcanoCommandUtils.findSummitAndSendToSender(sender, summitVent);
                                break;
                            }
                            case 17: {
                                msg.error("Implementation in progress...");
                                break;
                            }
                            case 18: {
                                vent = this.volcano.manager.getHighestStatusVent();
                                msg.info("Highest Status: " + vent.getStatus().name());
                                break;
                            }
                            case 19: {
                                if (sender instanceof Player) {
                                    player = (Player)sender;
                                    msg.info("Heat value of current location: " + this.volcano.manager.getHeatValue(player.getLocation()));
                                    break;
                                }
                                msg.error("This command is built for in-game only.");
                                break;
                            }
                            case 20: {
                                this.volcano.shutdown();
                                try {
                                    this.volcano.load();
                                    this.volcano.startup();
                                }
                                catch (IOException | ParseException e) {
                                    msg.error("Error occurred while reloading!");
                                }
                                break;
                            }
                            case 21: {
                                if (args.length == 3) {
                                    this.volcano.isDebug = Boolean.parseBoolean(args[2]);
                                }
                                msg.info("isDebug: " + this.volcano.isDebug);
                                break;
                            }
                            case 22: {
                                try {
                                    msg.info("Saving Volcano...");
                                    this.volcano.save(true);
                                    msg.ok("Saved Successfully.");
                                    break;
                                }
                                catch (IOException e) {
                                    msg.error("Error while saving volcano");
                                }
                            }
                        }
                        break block61;
                    }
                    msg.error(sender, "You don't have enough permission to run " + action.getCommand());
                    break block61;
                }
                msg.error(sender, "Invalid command: " + operationName);
                break block61;
            }
            sender.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Plugin] " + String.valueOf(ChatColor.GOLD) + "Volcano Command Manual");
            manuals = VolcanoCommandAction.getAllManual(sender, label, this.volcano.name);
            sender.sendMessage(manuals);
        }
        return true;
    }
}

