/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.erupt;

import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.erupt.VolcanoEruptStyle;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoNamer;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentGenesis;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentStatus;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import org.bukkit.Location;
import org.json.simple.JSONObject;

public class VolcanoErupt {
    VolcanoVent vent;
    VolcanoEruptStyle style = VolcanoEruptStyle.STROMBOLIAN;
    private boolean erupting = false;

    public VolcanoErupt(VolcanoVent vent) {
        this.vent = vent;
    }

    public void start() {
        if (this.vent != null && this.vent.isKillSwitchActive()) {
            return;
        }
        if (this.erupting) {
            return;
        }
        if (this.style.flowsLava()) {
            this.startFlowingLava();
        }
        if (this.style.isExplosive()) {
            this.startExploding();
        }
        if (this.style == VolcanoEruptStyle.HAWAIIAN) {
            this.vent.bombs.resetBaseY();
        } else if (this.style == VolcanoEruptStyle.LAVA_DOME) {
            this.vent.lavadome.configure();
        }
        this.vent.resetCurrentMetrics();
        this.erupting = true;
    }

    public void stop() {
        this.stopExploding();
        this.stopFlowingLava();
        this.erupting = false;
    }

    public void autoConfig() {
        this.autoConfig(true);
    }

    public void autoConfig(boolean updateSilicate) {
        if (this.style == VolcanoEruptStyle.HAWAIIAN) {
            this.vent.lavaFlow.settings.silicateLevel = 0.45 + Math.random() * 0.03999999999999998;
            this.vent.lavaFlow.settings.flowed = 10;
            this.vent.lavaFlow.settings.delayFlowed = 14;
            this.vent.explosion.settings.minBombCount = 3;
            this.vent.explosion.settings.maxBombCount = 6;
            this.vent.explosion.settings.queueSize = 2;
        } else {
            this.vent.explosion.enabled = true;
            if (this.style == VolcanoEruptStyle.STROMBOLIAN || this.style == VolcanoEruptStyle.VULCANIAN) {
                if (this.vent.lavaFlow.settings.silicateLevel > 0.57 && updateSilicate) {
                    this.vent.lavaFlow.settings.silicateLevel = 0.45 + Math.random() * 0.11999999999999994;
                }
                this.vent.lavaFlow.settings.delayFlowed = 10;
                this.vent.lavaFlow.settings.flowed = 7;
                this.vent.explosion.settings.minBombCount = 10;
                this.vent.explosion.settings.maxBombCount = 20;
                this.vent.explosion.settings.queueSize = 15;
                if (this.style == VolcanoEruptStyle.VULCANIAN) {
                    if (this.vent.lavaFlow.settings.silicateLevel < 0.57 && updateSilicate) {
                        this.vent.lavaFlow.settings.silicateLevel = 0.57 + Math.random() * 0.050000000000000044;
                    }
                    this.vent.explosion.settings.minBombCount = 50;
                    this.vent.explosion.settings.maxBombCount = 75;
                    this.vent.explosion.settings.queueSize = 25;
                } else if (this.style == VolcanoEruptStyle.PELEAN && this.vent.lavaFlow.settings.silicateLevel < 0.72 && updateSilicate) {
                    this.vent.lavaFlow.settings.silicateLevel = 0.61 + Math.random() * 0.10999999999999999;
                }
            }
        }
    }

    public Location getVentLocation() {
        boolean isCalderaAvailable;
        Volcano volcano = this.vent.getVolcano();
        boolean bl = isCalderaAvailable = (double)(this.vent.craterRadius + 10) < this.vent.calderaRadius * 0.7;
        if (this.vent.isCaldera() && isCalderaAvailable) {
            Location location = TyphonUtils.getRandomBlockInRange(this.vent.getCoreBlock(), this.vent.craterRadius + 10, (int)(this.vent.calderaRadius * 0.7)).getLocation();
            return location;
        }
        if (volcano.isVolcanicField()) {
            Location location = TyphonUtils.getRandomBlockInRange(this.vent.getCoreBlock(), 40, (int)Math.max(80.0, this.vent.getVolcanicRadius())).getLocation();
            if (TyphonUtils.getTwoDimensionalDistance(location, this.vent.location) > (double)volcano.fieldRange) {
                return null;
            }
            return location;
        }
        double coneSize = this.vent.getVolcanicRadius();
        int minDistance = (int)Math.max((double)(this.vent.craterRadius + 50), coneSize / 2.0);
        int maxDistance = (int)Math.max(this.vent.longestFlowLength, Math.max((double)minDistance, coneSize + 60.0));
        Location location = TyphonUtils.getRandomBlockInRange(this.vent.getCoreBlock(), minDistance, maxDistance).getLocation();
        if (volcano.manager.getNearestVent(location).isInVent(location)) {
            return null;
        }
        return location;
    }

    public VolcanoVentType getNewVentType() {
        double fissureProbability = 0.0;
        if (this.vent.lavaFlow.settings.silicateLevel < 0.53) {
            fissureProbability = Math.max(1.0 - Math.min(0.8, Math.max(this.vent.lavaFlow.settings.silicateLevel - 7.833333333333326, 0.0)), 0.0) * 0.75;
        }
        if (fissureProbability > Math.random()) {
            return VolcanoVentType.FISSURE;
        }
        return VolcanoVentType.CRATER;
    }

    public VolcanoVent openFissure() {
        Location location;
        Object name = "";
        boolean generated = false;
        Volcano volcano = this.vent.getVolcano();
        for (int key = 1; key < 999; ++key) {
            name = "fiss_" + key;
            if (volcano.subVents.get(name) != null) continue;
            generated = true;
            break;
        }
        if ((location = this.getVentLocation()) == null) {
            generated = false;
        }
        if (generated) {
            VolcanoVent newVent = new VolcanoVent(volcano, location, (String)name);
            VolcanoVentType type = this.getNewVentType();
            newVent.erupt.setStyle(this.vent.erupt.getStyle());
            newVent.explosion.settings.explosionSize = this.vent.explosion.settings.explosionSize;
            newVent.explosion.settings.maxBombCount = this.vent.explosion.settings.maxBombCount;
            newVent.explosion.settings.minBombCount = this.vent.explosion.settings.minBombCount;
            newVent.explosion.settings.damagingExplosionSize = this.vent.explosion.settings.damagingExplosionSize;
            newVent.lavaFlow.settings.flowed = this.vent.lavaFlow.settings.flowed;
            newVent.lavaFlow.settings.flowing = this.vent.lavaFlow.settings.flowing;
            newVent.lavaFlow.settings.silicateLevel = this.vent.lavaFlow.settings.silicateLevel;
            if (newVent.erupt.getStyle() == VolcanoEruptStyle.HAWAIIAN && type == VolcanoVentType.CRATER) {
                newVent.erupt.setStyle(VolcanoEruptStyle.STROMBOLIAN);
                newVent.name = VolcanoNamer.generate();
                name = newVent.name;
                newVent.explosion.settings.minBombCount = 3;
                newVent.explosion.settings.maxBombCount = 5;
            } else if (newVent.erupt.getStyle() == VolcanoEruptStyle.STROMBOLIAN && type == VolcanoVentType.FISSURE) {
                newVent.erupt.setStyle(VolcanoEruptStyle.HAWAIIAN);
                newVent.fissureAngle = this.vent.fissureAngle;
                newVent.explosion.settings.minBombCount = 0;
                newVent.explosion.settings.maxBombCount = 2;
            }
            newVent.genesis = VolcanoVentGenesis.MONOGENETIC;
            if (!volcano.isVolcanicField() && Math.random() < 0.25) {
                newVent.genesis = VolcanoVentGenesis.POLYGENETIC;
            }
            newVent.setType(type);
            newVent.name = name;
            volcano.addVolcanoVent(newVent);
            return newVent;
        }
        return null;
    }

    public void updateVentConfig() {
        if (this.vent == null) {
            return;
        }
        if ((this.style == VolcanoEruptStyle.HAWAIIAN || this.style == VolcanoEruptStyle.STROMBOLIAN) && this.vent.getType() == VolcanoVentType.FISSURE) {
            int prevFissureLength = this.vent.fissureLength;
            int targetLength = (int)Math.max(this.vent.getVolcanicRadius() * 2.0, (double)this.vent.fissureLength);
            this.vent.fissureLength = this.vent.fissureLength >= 0 ? Math.min(targetLength, this.vent.maxFissureLength) : targetLength;
            if (prevFissureLength != this.vent.fissureLength) {
                this.vent.flushCache();
            }
        }
    }

    public boolean isErupting() {
        return this.erupting;
    }

    public VolcanoEruptStyle getStyle() {
        return this.style;
    }

    public void setStyle(VolcanoEruptStyle style) {
        this.style = style;
        this.vent.flushCache();
        if (this.isErupting()) {
            this.stop();
            this.start();
        }
    }

    public void startFlowingLava() {
        if (this.vent != null && this.vent.isKillSwitchActive()) {
            return;
        }
        this.vent.initialize();
        this.vent.setStatus(VolcanoVentStatus.ERUPTING);
        this.vent.lavaFlow.resetThisFlow();
        this.vent.lavaFlow.settings.flowing = true;
    }

    public void stopFlowingLava() {
        if (this.vent != null && this.vent.isKillSwitchActive()) {
            return;
        }
        this.vent.lavaFlow.settings.flowing = false;
        this.vent.setStatus(!this.vent.isExploding() ? VolcanoVentStatus.MAJOR_ACTIVITY : this.vent.getStatus());
        this.vent.cool();
        if (this.vent.getStatus() != VolcanoVentStatus.ERUPTING) {
            this.vent.record.endEjectaTrack();
        }
        this.vent.lavadome.postConeBuildHandler();
    }

    public void startExploding() {
        this.vent.initialize();
        this.vent.setStatus(VolcanoVentStatus.ERUPTING);
        this.vent.explosion.running = true;
        if (this.vent.erupt.getStyle().canFormCaldera) {
            if (!this.vent.caldera.isSettedUp()) {
                this.vent.caldera.autoSetup();
            }
            this.vent.caldera.startErupt();
        }
    }

    public void stopExploding() {
        this.vent.explosion.running = false;
        this.vent.setStatus(!this.vent.isFlowingLava() ? VolcanoVentStatus.MAJOR_ACTIVITY : this.vent.getStatus());
        if (this.vent.getStatus() != VolcanoVentStatus.ERUPTING) {
            this.vent.record.endEjectaTrack();
        }
        this.vent.lavadome.postConeBuildHandler();
    }

    public void importConfig(JSONObject json) {
        this.setStyle(VolcanoEruptStyle.getVolcanoEruptStyle((String)json.get("style")));
    }

    public JSONObject exportConfig() {
        JSONObject json = new JSONObject();
        json.put("style", this.style.toString());
        return json;
    }
}

