/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.intrusions;

import io.papermc.paper.world.WeatheringCopperState;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import me.alex4386.plugin.typhon.TyphonBlocks;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.VolcanoComposition;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoMath;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class VolcanoMetamorphism {
    Volcano volcano;
    Random random = new Random();

    public VolcanoMetamorphism(Volcano volcano) {
        this.volcano = volcano;
    }

    public void metamorphoseBlock(Block block, boolean isLavaContact) {
        VolcanoVent vent = this.volcano.manager.getNearestVent(block);
        if (vent == null) {
            return;
        }
        this.metamorphoseBlock(vent, block, isLavaContact);
    }

    public Material oxidizeCopperBlock(Block block) {
        Material material = block.getType();
        String blockTypeName = TyphonUtils.toLowerCaseDumbEdition(material.name());
        Material target = null;
        if (blockTypeName.contains("copper")) {
            String targetName;
            Material targetMaterial;
            String rawName = material.name();
            WeatheringCopperState next = WeatheringCopperState.EXPOSED;
            if (blockTypeName.startsWith("exposed_")) {
                next = WeatheringCopperState.WEATHERED;
                rawName = rawName.replace("EXPOSED_", "");
            } else if (blockTypeName.startsWith("weathered_")) {
                next = WeatheringCopperState.OXIDIZED;
                rawName = rawName.replace("WEATHERED_", "");
            } else if (blockTypeName.startsWith("oxidized_")) {
                next = null;
                rawName = rawName.replace("OXIDIZED_", "");
            }
            if (next != null && (targetMaterial = Material.getMaterial((String)(targetName = next.name() + "_" + rawName))) != null) {
                target = targetMaterial;
            }
        }
        if (target != null) {
            return target;
        }
        return null;
    }

    public static boolean isDirt(Material material) {
        String blockTypeName = TyphonUtils.toLowerCaseDumbEdition(material.name());
        boolean typeOfDirt = blockTypeName.contains("dirt") || blockTypeName.contains("podzol") || blockTypeName.contains("grass_block") || blockTypeName.contains("farmland");
        return typeOfDirt;
    }

    public static boolean isNaturalSoil(Material material) {
        return VolcanoMetamorphism.isDirt(material);
    }

    public void metamorphoseBlock(VolcanoVent vent, Block block, boolean isLavaContact) {
        Material material = block.getType();
        if (material.isAir()) {
            return;
        }
        String blockTypeName = TyphonUtils.toLowerCaseDumbEdition(material.name());
        Material target = null;
        if (blockTypeName.contains("log") || blockTypeName.contains("leaves")) {
            if (!isLavaContact) {
                this.killTree(block);
            } else {
                this.removeTree(block);
            }
            return;
        }
        if (block.getType().isBurnable()) {
            this.setBlock(block, Material.AIR);
            return;
        }
        boolean typeOfDirt = VolcanoMetamorphism.isDirt(material);
        if (block.isLiquid()) {
            return;
        }
        if (typeOfDirt) {
            target = block.getType() == Material.COARSE_DIRT ? Material.STONE : Material.COARSE_DIRT;
        } else if (blockTypeName.contains("cobblestone") || blockTypeName.contains("gravel") || blockTypeName.contains("infested")) {
            if (blockTypeName.contains("infested")) {
                block.getWorld().playSound(block.getLocation(), Sound.ENTITY_SILVERFISH_DEATH, 1.0f, 0.0f);
            }
            target = Material.STONE;
        } else if (material == Material.SAND) {
            target = Material.SANDSTONE;
        } else if (material == Material.RED_SAND) {
            target = Material.RED_SANDSTONE;
        } else if (material == Material.CLAY) {
            target = Material.TERRACOTTA;
        } else {
            return;
        }
        if (material == Material.STONE) {
            target = VolcanoComposition.getExtrusiveRock(vent.lavaFlow.settings.silicateLevel);
        } else if (blockTypeName.contains("copper")) {
            target = this.oxidizeCopperBlock(block);
        }
        if (target != null) {
            vent.lavaFlow.queueBlockUpdate(block, target);
        }
    }

    public void setBlock(Block block, Material material) {
        this.setBlock(block, material, null);
    }

    public void setBlock(Block block, Material material, Consumer<Block> e) {
        if (this.volcano != null && this.volcano.mainVent != null && this.volcano.mainVent.lavaFlow != null && !TyphonPlugin.isShuttingdown) {
            this.volcano.mainVent.lavaFlow.queueBlockUpdate(block, material, e);
        } else {
            TyphonBlocks.setBlockType(block, material);
            e.accept(block);
        }
    }

    public void evaporateWater(Block block) {
        int radius = 1;
        if (block.getType() == Material.WATER) {
            if (block.getY() < block.getWorld().getSeaLevel() - 1) {
                this.setBlock(block, Material.AIR);
                return;
            }
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        Block nearby;
                        if (x == 0 && y == 0 && z == 0 || (nearby = block.getRelative(x, y, z)).getType() != Material.WATER) continue;
                        this.setBlock(nearby, Material.AIR);
                    }
                }
            }
        }
    }

    private int getRecursionAmount(Block baseBlock) {
        String name = TyphonUtils.toLowerCaseDumbEdition(baseBlock.getType().name());
        if (name.contains("cherry")) {
            return 45;
        }
        return 30;
    }

    public void killTree(Block baseBlock) {
        this.removeTree(baseBlock, this.getRecursionAmount(baseBlock), true);
    }

    public void removeTree(Block baseBlock) {
        this.removeTree(baseBlock, this.getRecursionAmount(baseBlock), false);
    }

    public void removeTree(Block baseBlock, int maxRecursion, boolean leavesOnly) {
        double percentage;
        HashSet<Block> visitedBlocks = new HashSet<Block>();
        HashSet<Block> treeBlocks = new HashSet<Block>();
        HashSet<Block> logBlocks = new HashSet<Block>();
        this.removeTree(baseBlock, maxRecursion, leavesOnly, visitedBlocks, treeBlocks, logBlocks);
        double d = percentage = leavesOnly ? 0.5 : 1.0;
        if (Math.random() < percentage) {
            this.timberTree(logBlocks);
        }
    }

    public void timberTree(Set<Block> logBlocks) {
        if (logBlocks.isEmpty()) {
            return;
        }
        Block rootBlock = logBlocks.iterator().next();
        for (Block block : logBlocks) {
            if (block.getY() >= rootBlock.getY()) continue;
            rootBlock = block;
        }
        VolcanoVent vent = this.volcano.manager.getNearestVent(rootBlock);
        Block ventBlock = vent.location.getBlock();
        Location ventLocation = ventBlock.getRelative(0, -ventBlock.getY(), 0).getLocation();
        Location rootBlockLoc = rootBlock.getRelative(0, -rootBlock.getY(), 0).getLocation();
        Vector newY = rootBlockLoc.subtract(ventLocation).toVector().setY(0).normalize();
        for (Block block : logBlocks) {
            if (block.isEmpty()) continue;
            Vector relativePosition = block.getLocation().toVector().subtract(rootBlock.getLocation().toVector());
            Vector rotatedVector = VolcanoMath.rotateVectorToYAxis(newY, relativePosition);
            Location newLocation = rootBlock.getLocation().clone().add(rotatedVector.getX(), rotatedVector.getY(), rotatedVector.getZ());
            Block targetBlock = TyphonUtils.getHighestRocklikes(newLocation.getBlock());
            targetBlock = targetBlock.getRelative(BlockFace.UP);
            BlockFace newFace = TyphonUtils.getAdequateBlockFace(newY);
            Consumer<Block> callback = TyphonUtils.getBlockFaceUpdater(newFace);
            this.setBlock(targetBlock, block.getType(), callback);
            this.setBlock(block, Material.AIR);
        }
    }

    private void removeTree(Block baseBlock, int maxRecursion, boolean leavesOnly, Set<Block> visitedBlocks, Set<Block> treeBlocks, Set<Block> logBlocks) {
        String name;
        BlockFace[] facesToSearch;
        if (visitedBlocks.contains(baseBlock)) {
            return;
        }
        visitedBlocks.add(baseBlock);
        if (maxRecursion < 0 || !TyphonUtils.isMaterialTree(baseBlock.getType())) {
            return;
        }
        treeBlocks.add(baseBlock);
        for (BlockFace face : facesToSearch = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.WEST, BlockFace.DOWN, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.DOWN}) {
            Block block = baseBlock.getRelative(face);
            if (!TyphonUtils.isMaterialTree(block.getType())) continue;
            this.removeTree(block, maxRecursion - 1, leavesOnly, visitedBlocks, treeBlocks, logBlocks);
        }
        if (baseBlock.getType() == Material.CHERRY_LOG || baseBlock.getType() == Material.ACACIA_LOG) {
            Block upBlock = baseBlock.getRelative(BlockFace.UP);
            for (BlockFace face : facesToSearch) {
                Block block = upBlock.getRelative(face);
                if (!TyphonUtils.isMaterialTree(block.getType())) continue;
                this.removeTree(block, maxRecursion - 1, leavesOnly, visitedBlocks, treeBlocks, logBlocks);
            }
        }
        if ((name = TyphonUtils.toLowerCaseDumbEdition(baseBlock.getType().name())).contains("log")) {
            if (!leavesOnly) {
                Location loc = baseBlock.getLocation();
                this.setBlock(baseBlock, Material.COAL_BLOCK);
            }
            logBlocks.add(baseBlock);
        } else {
            this.setBlock(baseBlock, Material.AIR);
        }
        treeBlocks.add(baseBlock);
    }

    public void removePlant(Block baseBlock) {
        this.removePlant(baseBlock, 25);
    }

    public void removePlant(Block baseBlock, int maxRecursion) {
        this.removePlant(baseBlock, maxRecursion, new HashSet<Block>());
    }

    private void removePlant(Block baseBlock, int maxRecursion, Set<Block> visitedBlocks) {
        BlockFace[] facesToSearch;
        if (maxRecursion < 0 || !TyphonUtils.isMaterialPlant(baseBlock.getType())) {
            return;
        }
        if (visitedBlocks.contains(baseBlock)) {
            return;
        }
        visitedBlocks.add(baseBlock);
        for (BlockFace face : facesToSearch = new BlockFace[]{BlockFace.UP}) {
            Block block = baseBlock.getRelative(face);
            if (!TyphonUtils.isMaterialPlant(block.getType())) continue;
            this.removePlant(block, maxRecursion - 1, visitedBlocks);
        }
        this.setBlock(baseBlock, Material.AIR);
    }

    public boolean isFlower(Material material) {
        return material == Material.DANDELION || material == Material.POPPY || material == Material.BLUE_ORCHID || material == Material.ALLIUM || material == Material.AZURE_BLUET || material == Material.RED_TULIP || material == Material.ORANGE_TULIP || material == Material.WHITE_TULIP || material == Material.PINK_TULIP || material == Material.OXEYE_DAISY || material == Material.CORNFLOWER || material == Material.LILY_OF_THE_VALLEY || material == Material.TORCHFLOWER || material == Material.WITHER_ROSE || material == Material.SUNFLOWER || material == Material.LILAC || material == Material.ROSE_BUSH || material == Material.PEONY || material == Material.PITCHER_PLANT || material == Material.PITCHER_POD;
    }

    public boolean isPlantlike(Material material) {
        return this.isFlower(material) || material == Material.SMALL_DRIPLEAF || material == Material.BIG_DRIPLEAF || material == Material.BIG_DRIPLEAF_STEM || material == Material.GLOW_LICHEN || material == Material.HANGING_ROOTS || material == Material.ROOTED_DIRT || material == Material.MANGROVE_ROOTS || material == Material.MUDDY_MANGROVE_ROOTS || material == Material.SPORE_BLOSSOM;
    }

    public boolean isPlaceableAnimalEgg(Material material) {
        return material == Material.DRAGON_EGG || material == Material.TURTLE_EGG || material == Material.SNIFFER_EGG || material == Material.DRIED_GHAST || material == Material.BLUE_EGG || material == Material.BROWN_EGG || material == Material.FROGSPAWN;
    }

    public void evaporateBlock(Block block) {
        Material material = block.getType();
        String blockTypeName = TyphonUtils.toLowerCaseDumbEdition(material.name());
        VolcanoVent vent = this.volcano.manager.getNearestVent(block);
        double silicateLevel = vent == null ? 0.45 : vent.lavaFlow.settings.silicateLevel;
        Material target = null;
        if (material.isBurnable()) {
            for (BlockFace face : BlockFace.values()) {
                Block relativeBlock = block.getRelative(face);
                if (!relativeBlock.getType().isAir()) continue;
                target = Material.FIRE;
            }
        }
        if (material == Material.WATER) {
            this.evaporateWater(block);
        } else if (blockTypeName.contains("snow")) {
            target = Material.AIR;
        } else if (blockTypeName.contains("coral")) {
            target = Material.SAND;
        } else if (material == Material.SHORT_GRASS) {
            target = Material.SHORT_DRY_GRASS;
        } else if (material == Material.TALL_GRASS) {
            target = Material.TALL_DRY_GRASS;
        } else if (material == Material.SHORT_DRY_GRASS || material == Material.TALL_DRY_GRASS) {
            if (Math.random() < 0.2) {
                target = Material.AIR;
            }
        } else if (material == Material.PINK_PETALS || material == Material.BUSH || blockTypeName.endsWith("_bush") || material == Material.LEAF_LITTER) {
            target = Material.AIR;
        } else if (material == Material.GRASS_BLOCK || material == Material.ROOTED_DIRT || material == Material.MUDDY_MANGROVE_ROOTS) {
            target = Material.DIRT;
        } else if (material == Material.CACTUS_FLOWER) {
            target = Material.AIR;
            underBlock = block.getRelative(BlockFace.DOWN);
            if (underBlock.getType() == Material.CACTUS) {
                this.evaporateBlock(underBlock);
            }
        } else if (material == Material.CACTUS) {
            target = Material.AIR;
            underBlock = block.getRelative(BlockFace.DOWN);
            if (underBlock.getType() == Material.CACTUS) {
                this.evaporateBlock(underBlock);
            }
        } else if (material == Material.LARGE_FERN || material == Material.BAMBOO) {
            underBlock = block.getRelative(BlockFace.DOWN);
            target = underBlock.getType() == material ? Material.AIR : Material.DEAD_BUSH;
        } else if (blockTypeName.contains("sapling") || material == Material.MANGROVE_PROPAGULE) {
            target = Material.DEAD_BUSH;
        } else if (this.isFlower(material)) {
            target = Material.DEAD_BUSH;
        } else if (this.isPlantlike(material)) {
            target = Material.AIR;
        } else if (this.isPlaceableAnimalEgg(material)) {
            target = Material.AIR;
        } else if (material == Material.SEAGRASS || material == Material.TALL_SEAGRASS) {
            target = Material.AIR;
        } else if (material == Material.WATER_CAULDRON) {
            target = Material.CAULDRON;
        } else if (material == Material.MOSS_BLOCK) {
            target = Material.DIRT;
        } else if (blockTypeName.contains("infested")) {
            target = VolcanoComposition.getExtrusiveRock(silicateLevel);
        } else if (material == Material.SEA_PICKLE) {
            target = Material.AIR;
        }
        if (target != null) {
            this.setBlock(block, target);
        }
    }
}

