/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.vent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.alex4386.plugin.typhon.TyphonBlueMapUtils;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.ash.VolcanoPyroclasticFlow;
import me.alex4386.plugin.typhon.volcano.bomb.VolcanoBomb;
import me.alex4386.plugin.typhon.volcano.erupt.VolcanoEruptStyle;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoMath;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class VolcanoVentCaldera {
    public VolcanoVent vent;
    int minBombs = 50;
    int maxBombs = 100;
    public int radius = -1;
    int deep = -1;
    Block baseBlock = null;
    boolean isRunning = false;
    public int currentRadius = 0;
    public Block currentBase = null;
    int randomnessHeight = 5;
    int tuffLayer = 3;
    long notProcessedEjecta = 0L;
    int scheduleID = -1;
    int targetY = 0;
    int oceanY = 0;
    double[][] noise = null;
    VolcanoEruptStyle backedupStyle = VolcanoEruptStyle.STROMBOLIAN;
    int currentIteration = 0;
    Map<Chunk, List<Block>> currentIterationPerChunks = new HashMap<Chunk, List<Block>>();

    VolcanoVentCaldera(VolcanoVent vent) {
        this.vent = vent;
    }

    public void registerTask() {
        this.vent.getVolcano().logger.log(VolcanoLogClass.CALDERA, "Registering Eruption tick");
        if (this.scheduleID < 0) {
            this.scheduleID = TyphonScheduler.registerGlobalTask(this::runEruptTick, 4L);
        }
    }

    public void unregisterTask() {
        this.vent.getVolcano().logger.log(VolcanoLogClass.CALDERA, "Unregistering Eruption tick");
        if (this.scheduleID >= 0) {
            TyphonScheduler.unregisterTask(this.scheduleID);
            this.scheduleID = -1;
        }
    }

    public int getTargetY(Block coreBlock, int radius) {
        double circumference = (double)(radius * 2) * Math.PI;
        int sampleSize = (int)Math.min(circumference / 4.0, 50.0);
        HashSet<Block> usedBlocks = new HashSet<Block>();
        int totalY = 0;
        for (int i = 0; i < sampleSize; ++i) {
            Block block = TyphonUtils.getRandomBlockInRange(coreBlock, radius, radius);
            if (usedBlocks.contains(block)) continue;
            usedBlocks.add(block);
            block = TyphonUtils.getHighestRocklikes(block);
            totalY += block.getY();
        }
        int targetY = totalY / usedBlocks.size();
        return targetY;
    }

    public int getDeep(int radius) {
        return (int)Math.max(10.0, (double)radius / (1.5 + Math.random() * 0.5));
    }

    public void autoSetup() {
        double radius = this.vent.longestNormalLavaFlowLength / (2.0 + Math.random());
        if (radius == 0.0) {
            radius = this.vent.longestFlowLength / (2.0 + Math.random());
        }
        radius = Math.max(50.0, radius);
        this.autoSetup((int)radius);
    }

    public void autoSetup(int radius) {
        int deep = this.getDeep(radius);
        this.autoSetup(radius, deep);
    }

    public void autoSetup(int radius, int deep) {
        Block block = this.vent.getCoreBlock();
        int y = this.getTargetY(block, radius);
        int oceanDepth = (int)((double)deep / (2.0 + Math.random()));
        boolean fillWater = Math.random() < 0.3;
        int oceanY = Integer.MIN_VALUE;
        if (fillWater) {
            oceanY = y - deep + this.tuffLayer + oceanDepth;
        }
        this.setupWork(block, radius, deep, oceanY);
    }

    public void autoSetup(int radius, int deep, int oceanY) {
        Block block = this.vent.getCoreBlock();
        this.setupWork(block, radius, deep, oceanY);
    }

    public void setupWork(Block block, int radius, int deep, int oceanY) {
        this.vent.getVolcano().logger.log(VolcanoLogClass.CALDERA, "Setting up caldera formation");
        this.radius = radius;
        this.deep = deep;
        Location loc = block.getLocation();
        loc.setY((double)this.vent.getSummitBlock().getY());
        this.baseBlock = loc.getBlock();
        this.targetY = this.getTargetY(this.baseBlock, this.radius);
        this.oceanY = oceanY > this.targetY ? oceanY : this.vent.getVolcano().location.getWorld().getSeaLevel();
        this.initializeNoise();
        this.currentBase = this.baseBlock.getRelative(0, this.vent.getSummitBlock().getY() - this.baseBlock.getY(), 0).getRelative(0, -this.vent.getRadius(), 0);
        this.currentRadius = this.vent.getRadius();
    }

    public void initialize() {
        this.registerTask();
    }

    public void shutdown() {
        this.unregisterTask();
    }

    public boolean canCreateCaldera() {
        if (this.vent.calderaRadius > 0.0) {
            return false;
        }
        if (this.vent.getType() != VolcanoVentType.CRATER) {
            return false;
        }
        return !(this.vent.longestNormalLavaFlowLength < 50.0);
    }

    public int getCurrentTargetY(Block block) {
        double rawDistance = Math.min(TyphonUtils.getTwoDimensionalDistance(this.baseBlock.getLocation(), block.getLocation()), (double)this.radius);
        double distanceRatio = 1.0 - rawDistance / (double)this.radius;
        double heightDeduct = Math.max(0.0, (double)this.deep * distanceRatio);
        int targetYFromHeightDeduct = (int)Math.max((double)(this.targetY - this.deep), (double)this.targetY - heightDeduct);
        int baseBlockStairY = this.currentBase.getY() + (int)rawDistance;
        int targetY = Math.max(targetYFromHeightDeduct, baseBlockStairY);
        return targetY + this.getRandomnessHeight(block);
    }

    public int getRandomnessHeight(Block block) {
        int x = block.getX() - this.baseBlock.getX() + this.radius - 1;
        int z = block.getZ() - this.baseBlock.getZ() + this.radius - 1;
        if (x < 0 || x >= this.radius * 2 || z < 0 || z >= this.radius * 2) {
            return 0;
        }
        this.initializeNoise();
        try {
            double data = this.noise[x][z];
            return (int)(data * (double)this.randomnessHeight);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void initializeNoise() {
        if (this.noise == null) {
            this.noise = VolcanoMath.generatePerlinNoise(this.radius * 2, this.radius * 2, 4.0);
        }
    }

    public int excavateUntilSpecificY(Block block, int targetY) {
        int excavated = 0;
        while (block.getY() > targetY) {
            Material material = Material.AIR;
            if (block.getY() <= this.oceanY) {
                material = Material.WATER;
            }
            this.vent.lavaFlow.queueBlockUpdate(block, material);
            block = block.getRelative(0, -1, 0);
            ++excavated;
        }
        if (block != null) {
            this.vent.lavaFlow.queueBlockUpdate(block, Material.TUFF);
        }
        return excavated;
    }

    public void runSession() {
        if (this.currentIterationPerChunks.isEmpty()) {
            this.currentIteration = 0;
            if (this.currentRadius < this.radius) {
                ++this.currentRadius;
            } else {
                this.endErupt();
                return;
            }
            this.currentBase = this.currentBase.getRelative(0, -1, 0);
            List<Block> blocks = VolcanoMath.getCircle(this.baseBlock, this.currentRadius);
            HashSet<Chunk> chunks = new HashSet<Chunk>();
            for (Block block : blocks) {
                chunks.add(block.getChunk());
            }
            for (Chunk chunk : chunks) {
                ArrayList<Block> list = new ArrayList<Block>();
                for (Block block : blocks) {
                    if (!block.getChunk().equals((Object)chunk)) continue;
                    list.add(block);
                }
                this.currentIterationPerChunks.put(chunk, list);
                TyphonScheduler.run(chunk, () -> this.runSessionPerChunk(chunk));
            }
        }
    }

    public void runSessionPerChunk(Chunk chunk) {
        List<Block> list = this.currentIterationPerChunks.get(chunk);
        if (list == null) {
            return;
        }
        for (Block block : list) {
            int excavated;
            Block targetBlock = TyphonUtils.getHighestRocklikes(block);
            int targetY = this.getCurrentTargetY(block);
            if (targetBlock.getY() <= targetY || (excavated = this.excavateUntilSpecificY(targetBlock, targetY)) <= 0) continue;
            this.vent.record.addEjectaVolume(excavated);
            this.notProcessedEjecta += (long)excavated;
        }
        this.currentIterationPerChunks.remove(chunk);
    }

    public boolean isForming() {
        return this.isSettedUp() && this.isRunning;
    }

    public boolean isInCalderaRange(Location location) {
        if (!this.isSettedUp()) {
            return false;
        }
        return TyphonUtils.getTwoDimensionalDistance(this.baseBlock.getLocation(), location) < (double)this.radius;
    }

    private long getTotal() {
        return this.getTotal(this.radius);
    }

    private long getTotal(int to) {
        int from = this.vent.getRadius();
        long total = 0L;
        for (int i = from; i < to; ++i) {
            total += (long)(Math.pow(i, 2.0) * Math.PI);
        }
        return total;
    }

    public double getProgress() {
        if (!this.isSettedUp()) {
            return 0.0;
        }
        long size = (long)(Math.pow(this.currentRadius, 2.0) * Math.PI);
        double currentIterationPercent = (double)this.currentIteration / (double)size;
        double currentIterationInScale = currentIterationPercent * (double)size / (double)this.getTotal();
        return ((double)this.getTotal(this.currentRadius) + currentIterationInScale) / (double)this.getTotal();
    }

    public boolean isSettedUp() {
        return this.baseBlock != null && this.radius >= 0 && this.deep >= 0;
    }

    public void startErupt() {
        this.vent.getVolcano().logger.log(VolcanoLogClass.CALDERA, "Starting plinian eruption for caldera formation");
        this.backedupStyle = this.vent.erupt.getStyle();
        this.vent.erupt.setStyle(VolcanoEruptStyle.PLINIAN);
        this.initialize();
        this.isRunning = true;
    }

    public void doEruptionPlume() {
        Block randomBlock = TyphonUtils.getRandomBlockInRange(this.baseBlock, this.currentRadius);
        if (Math.random() < 0.95) {
            this.vent.ash.createAshCloud(TyphonUtils.getHighestRocklikes(randomBlock).getLocation(), 1.0);
        } else {
            this.vent.ash.createPumiceCloud(TyphonUtils.getHighestRocklikes(randomBlock).getLocation(), 2.0);
        }
    }

    public void tryEruptionPyroclasticFlows() {
        if (this.vent.ash.activePyroclasticFlows() > 200) {
            return;
        }
        this.doEruptionPyroclasticFlows();
    }

    public VolcanoPyroclasticFlow doEruptionPyroclasticFlows() {
        long total = 0L;
        List<Block> listBlocks = VolcanoMath.getHollowCircle(this.baseBlock, this.currentRadius + 5);
        Block lowestY = TyphonUtils.getHighestRocklikes(listBlocks.get(0));
        for (Block baseBlock : listBlocks) {
            Block block = TyphonUtils.getHighestRocklikes(baseBlock);
            total += (long)block.getY();
            if (block.getY() >= lowestY.getY()) continue;
            lowestY = block;
        }
        double average = (double)total / (double)listBlocks.size();
        Block targetBlock = (double)(lowestY.getY() + 2) <= average ? TyphonUtils.getRandomBlockInRange(this.baseBlock, this.currentRadius + 2, this.currentRadius + 4) : lowestY;
        return this.vent.ash.triggerPyroclasticFlow(TyphonUtils.getHighestRocklikes(targetBlock));
    }

    public void runEruptTick() {
        if (this.isForming()) {
            if (this.notProcessedEjecta <= 0L) {
                this.notProcessedEjecta = 0L;
                this.runSession();
            } else {
                int random = (int)(Math.random() * 100.0);
                for (int i = 0; i < random && this.notProcessedEjecta > 0L; ++i) {
                    int bombSize = (int)(Math.random() * 3.0 + 2.0);
                    VolcanoBomb bomb = Math.random() < 0.5 ? this.vent.bombs.generateBombToDestination(TyphonUtils.getHighestRocklikes(TyphonUtils.getFairRandomBlockInRange(this.baseBlock, this.currentRadius, (int)Math.max((double)(this.radius + 100), this.vent.longestFlowLength))).getLocation(), 1) : this.vent.bombs.tryConeBuildingBomb();
                    if (bomb != null) {
                        if (Math.random() < 0.95) {
                            bomb.land();
                        } else {
                            this.vent.bombs.launchSpecifiedBomb(bomb);
                        }
                        double bombVolume = 4.1887902047863905 * Math.pow(bombSize, 3.0);
                        this.notProcessedEjecta -= (long)Math.ceil(bombVolume);
                    }
                    int plumeCount = (int)(Math.pow((double)random / 100.0, 2.0) * 4.0) + 1;
                    for (int j = 0; j < plumeCount; ++j) {
                        this.doEruptionPlume();
                    }
                    if (!(Math.random() < 0.2)) continue;
                    this.tryEruptionPyroclasticFlows();
                    this.notProcessedEjecta -= 1000L;
                }
            }
        }
    }

    public void endErupt() {
        this.vent.getVolcano().logger.log(VolcanoLogClass.CALDERA, "Ending caldera formation");
        this.shutdown();
        this.finalizeUpdateVentData();
        this.vent.erupt.stop();
        this.vent.volcano.quickCool();
        this.vent.bombs.bombMap.clear();
        this.vent.flushSummitCache();
    }

    public void finalizeUpdateVentData() {
        if (this.radius > 0) {
            this.vent.calderaRadius = this.radius;
        }
        this.vent.erupt.stop();
        this.vent.flushCache();
        this.vent.bombs.resetBaseY();
        TyphonBlueMapUtils.updateVolcanoVentIcon(this.vent);
        this.vent.erupt.setStyle(this.backedupStyle);
        this.isRunning = false;
    }
}

