/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.AssetStorage;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.RenderManager;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentStatus;
import org.bukkit.Chunk;
import org.bukkit.World;

public class TyphonBlueMapUtils {
    public static boolean isInitialized = false;
    public static boolean bluemapFailNotified = false;
    public static String eruptingImgUrl = null;
    public static String dormantImgUrl = null;
    public static Map<Volcano, Long> lastRerender = new HashMap<Volcano, Long>();
    public static long rerenderExpire = 30000L;

    public static BlueMapAPI getBlueMapAPI() {
        if (TyphonPlugin.blueMap == null && !isInitialized) {
            try {
                TyphonPlugin.blueMap = (BlueMapAPI)BlueMapAPI.getInstance().get();
                TyphonPlugin.logger.log(VolcanoLogClass.BLUE_MAP, "Bluemap Detected. Integrating...");
                TyphonBlueMapUtils.initialize();
            }
            catch (NoClassDefFoundError | NoSuchElementException e) {
                if (!bluemapFailNotified) {
                    TyphonPlugin.logger.error(VolcanoLogClass.BLUE_MAP, "Failed to integrate with Bluemap! " + e.getLocalizedMessage());
                    bluemapFailNotified = true;
                }
                return null;
            }
        }
        return TyphonPlugin.blueMap;
    }

    public static void updateChunks(World world, Set<Chunk> chunks) {
        if (!TyphonBlueMapUtils.getBlueMapAvailable()) {
            return;
        }
        Vector2i[] chunkPositions = (Vector2i[])chunks.stream().filter(chunk -> chunk.getWorld().equals((Object)world)).map(chunk -> new Vector2i(chunk.getX(), chunk.getZ())).toArray(Vector2i[]::new);
        TyphonBlueMapUtils.runOnMap(world, (? super BlueMapMap map) -> {
            BlueMapAPI api = TyphonBlueMapUtils.getBlueMapAPI();
            if (api != null) {
                RenderManager man = api.getRenderManager();
                if (!map.isFrozen()) {
                    man.scheduleMapUpdateTask(map, List.of(chunkPositions), true);
                    if (!man.isRunning()) {
                        man.start();
                    }
                }
            }
        });
    }

    public static boolean reRenderVolcano(Volcano volcano) {
        if (!TyphonBlueMapUtils.getBlueMapAvailable()) {
            return false;
        }
        if (lastRerender.containsKey(volcano) && System.currentTimeMillis() - lastRerender.get(volcano) < rerenderExpire) {
            return false;
        }
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        for (VolcanoVent vent : volcano.manager.getVents()) {
            double radius = vent.longestFlowLength;
            chunks.addAll(TyphonUtils.getChunksInRadius(vent.location.getChunk(), radius));
        }
        TyphonBlueMapUtils.updateChunks(volcano.location.getWorld(), chunks);
        return true;
    }

    public static void initialize() {
        isInitialized = true;
        TyphonBlueMapUtils.loadTyphonVolcanoes();
    }

    public static void loadTyphonVolcanoes() {
        TyphonPlugin.logger.log(VolcanoLogClass.BLUE_MAP, "Integrating volcanoes to Bluemap");
        for (Map.Entry<String, Volcano> volcanoEntry : TyphonPlugin.listVolcanoes.entrySet()) {
            Volcano volcano = volcanoEntry.getValue();
            TyphonBlueMapUtils.addVolcanoOnMap(volcano);
        }
    }

    public static boolean getBlueMapAvailable() {
        return TyphonBlueMapUtils.getBlueMapAPI() != null;
    }

    public static boolean checkIfAssetExists(World world, String id) {
        try {
            AssetStorage storage = ((BlueMapMap)TyphonBlueMapUtils.getBlueMapAPI().getMap(world.getName()).get()).getAssetStorage();
            return storage.assetExists(id);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String uploadAndGetURLIfAssetNotExist(World world, String id, byte[] data) {
        AssetStorage storage = ((BlueMapMap)TyphonBlueMapUtils.getBlueMapAPI().getMap(world.getName()).get()).getAssetStorage();
        if (TyphonBlueMapUtils.checkIfAssetExists(world, id)) {
            return storage.getAssetUrl(id);
        }
        try {
            OutputStream out = storage.writeAsset(id);
            out.write(data);
            out.flush();
            out.close();
            return storage.getAssetUrl(id);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getEruptingImgUrl(World world) {
        AssetStorage storage = ((BlueMapMap)TyphonBlueMapUtils.getBlueMapAPI().getMap(world.getName()).get()).getAssetStorage();
        String id = "typhon/erupting.png";
        try {
            if (TyphonBlueMapUtils.checkIfAssetExists(world, id)) {
                return storage.getAssetUrl(id);
            }
            InputStream eruptingImg = TyphonPlugin.plugin.getResource("icons/erupting.png");
            byte[] data = eruptingImg.readAllBytes();
            return TyphonBlueMapUtils.uploadAndGetURLIfAssetNotExist(world, id, data);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getDormantImgUrl(World world) {
        AssetStorage storage = ((BlueMapMap)TyphonBlueMapUtils.getBlueMapAPI().getMap(world.getName()).get()).getAssetStorage();
        String id = "typhon/dormant.png";
        try {
            if (TyphonBlueMapUtils.checkIfAssetExists(world, id)) {
                return storage.getAssetUrl(id);
            }
            InputStream eruptingImg = TyphonPlugin.plugin.getResource("icons/dormant.png");
            byte[] data = eruptingImg.readAllBytes();
            return TyphonBlueMapUtils.uploadAndGetURLIfAssetNotExist(world, id, data);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getMinorActivityImgUrl(World world) {
        AssetStorage storage = ((BlueMapMap)TyphonBlueMapUtils.getBlueMapAPI().getMap(world.getName()).get()).getAssetStorage();
        String id = "typhon/minor-activity.png";
        try {
            if (TyphonBlueMapUtils.checkIfAssetExists(world, id)) {
                return storage.getAssetUrl(id);
            }
            InputStream eruptingImg = TyphonPlugin.plugin.getResource("icons/minor-activity.png");
            byte[] data = eruptingImg.readAllBytes();
            return TyphonBlueMapUtils.uploadAndGetURLIfAssetNotExist(world, id, data);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getMajorActivityImgUrl(World world) {
        AssetStorage storage = ((BlueMapMap)TyphonBlueMapUtils.getBlueMapAPI().getMap(world.getName()).get()).getAssetStorage();
        String id = "typhon/major-activity.png";
        try {
            if (TyphonBlueMapUtils.checkIfAssetExists(world, id)) {
                return storage.getAssetUrl(id);
            }
            InputStream eruptingImg = TyphonPlugin.plugin.getResource("icons/major-activity.png");
            byte[] data = eruptingImg.readAllBytes();
            return TyphonBlueMapUtils.uploadAndGetURLIfAssetNotExist(world, id, data);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getExtinctImgUrl(World world) {
        AssetStorage storage = ((BlueMapMap)TyphonBlueMapUtils.getBlueMapAPI().getMap(world.getName()).get()).getAssetStorage();
        String id = "typhon/extinct.png";
        try {
            if (TyphonBlueMapUtils.checkIfAssetExists(world, id)) {
                return storage.getAssetUrl(id);
            }
            InputStream eruptingImg = TyphonPlugin.plugin.getResource("icons/extinct.png");
            byte[] data = eruptingImg.readAllBytes();
            return TyphonBlueMapUtils.uploadAndGetURLIfAssetNotExist(world, id, data);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getVolcanoMarkerSetID(Volcano volcano) {
        return "Volcano " + volcano.name;
    }

    public static String getVolcanoVentMarkerID(VolcanoVent vent) {
        return vent.getName();
    }

    public static void addVolcanoOnMap(Volcano volcano) {
        if (!TyphonBlueMapUtils.getBlueMapAvailable()) {
            return;
        }
        TyphonBlueMapUtils.runOnMap(volcano, (? super BlueMapMap map) -> {
            TyphonPlugin.logger.log(VolcanoLogClass.BLUE_MAP, "Adding volcano " + volcano.name + " on map.");
            MarkerSet volcanoSet = TyphonBlueMapUtils.getVolcanoMarkers(volcano);
            map.getMarkerSets().put(TyphonBlueMapUtils.getVolcanoMarkerSetID(volcano), volcanoSet);
        });
    }

    public static void removeVolcanoFromMap(Volcano volcano) {
        if (!TyphonBlueMapUtils.getBlueMapAvailable()) {
            return;
        }
        TyphonBlueMapUtils.runOnMap(volcano, (? super BlueMapMap map) -> {
            TyphonPlugin.logger.log(VolcanoLogClass.BLUE_MAP, "Removing volcano " + volcano.name + " on map.");
            map.getMarkerSets().remove(TyphonBlueMapUtils.getVolcanoMarkerSetID(volcano));
        });
    }

    public static MarkerSet getVolcanoMarkers(Volcano volcano) {
        if (!TyphonBlueMapUtils.getBlueMapAvailable()) {
            return null;
        }
        MarkerSet volcanoMarkerSet = MarkerSet.builder().label(volcano.name + " volcano").build();
        for (VolcanoVent vent : volcano.manager.getVents()) {
            TyphonBlueMapUtils.addVolcanoVentToMarkerSet(volcanoMarkerSet, vent);
        }
        return volcanoMarkerSet;
    }

    public static void addVolcanoVentOnMap(VolcanoVent vent) {
        if (!TyphonBlueMapUtils.getBlueMapAvailable()) {
            return;
        }
        TyphonBlueMapUtils.runOnMap(vent, (? super BlueMapMap map) -> {
            TyphonPlugin.logger.log(VolcanoLogClass.BLUE_MAP, "Adding vent " + vent.getName() + " of " + vent.volcano.name + " on map.");
            String markerSetID = TyphonBlueMapUtils.getVolcanoMarkerSetID(vent.volcano);
            MarkerSet set = (MarkerSet)map.getMarkerSets().get(markerSetID);
            if (set != null) {
                set.getMarkers().put(TyphonBlueMapUtils.getVolcanoVentMarkerID(vent), TyphonBlueMapUtils.getVolcanoVentMarker(vent));
            }
        });
    }

    public static String getIconURLByStatus(VolcanoVent vent) {
        return TyphonBlueMapUtils.getIconURLByStatus(vent.location.getWorld(), vent.getStatus());
    }

    public static String getIconURLByStatus(World world, VolcanoVentStatus status) {
        if (status == VolcanoVentStatus.ERUPTING) {
            return TyphonBlueMapUtils.getEruptingImgUrl(world);
        }
        if (status == VolcanoVentStatus.MAJOR_ACTIVITY || status == VolcanoVentStatus.ERUPTION_IMMINENT) {
            return TyphonBlueMapUtils.getMajorActivityImgUrl(world);
        }
        if (status == VolcanoVentStatus.MINOR_ACTIVITY) {
            return TyphonBlueMapUtils.getMinorActivityImgUrl(world);
        }
        if (status == VolcanoVentStatus.DORMANT) {
            return TyphonBlueMapUtils.getDormantImgUrl(world);
        }
        return TyphonBlueMapUtils.getExtinctImgUrl(world);
    }

    public static POIMarker getVolcanoVentMarker(VolcanoVent vent) {
        if (!TyphonBlueMapUtils.getBlueMapAvailable()) {
            return null;
        }
        Vector3d v3d = Vector3d.from((double)vent.location.getX(), (double)vent.getSummitBlock().getY(), (double)vent.location.getZ());
        POIMarker ventMarker = ((POIMarker.Builder)((POIMarker.Builder)POIMarker.builder().label(vent.isMainVent() ? vent.volcano.name + " Volcano" : vent.name + " (" + vent.volcano.name + ")")).icon(TyphonBlueMapUtils.getIconURLByStatus(vent), TyphonBlueMapUtils.getIconSize()).position(v3d)).build();
        return ventMarker;
    }

    public static void updateVolcanoVentMarkerHeight(VolcanoVent vent) {
        TyphonBlueMapUtils.runOnVolcanoVentMarker(vent, marker -> marker.setPosition(new Vector3d(vent.location.getX(), (double)vent.getSummitBlock().getY(), vent.location.getZ())));
    }

    public static void addVolcanoVentToMarkerSet(MarkerSet set, VolcanoVent vent) {
        if (!TyphonBlueMapUtils.getBlueMapAvailable()) {
            return;
        }
        TyphonPlugin.logger.log(VolcanoLogClass.BLUE_MAP, "Adding vent " + vent.getName() + " of " + vent.volcano.name + " on map.");
        String markerId = TyphonBlueMapUtils.getVolcanoVentMarkerID(vent);
        set.getMarkers().put(markerId, TyphonBlueMapUtils.getVolcanoVentMarker(vent));
    }

    public static void runOnVolcanoVentMarker(VolcanoVent vent, Consumer<? super POIMarker> run) {
        TyphonBlueMapUtils.runOnMap(vent, (? super BlueMapMap map) -> {
            Marker marker;
            String markerSetID = TyphonBlueMapUtils.getVolcanoMarkerSetID(vent.volcano);
            MarkerSet set = (MarkerSet)map.getMarkerSets().get(markerSetID);
            if (set != null && (marker = (Marker)set.getMarkers().get(TyphonBlueMapUtils.getVolcanoVentMarkerID(vent))) instanceof POIMarker) {
                POIMarker realMarker = (POIMarker)marker;
                run.accept(realMarker);
            }
        });
    }

    public static void removeVolcanoVentMarker(VolcanoVent vent) {
        TyphonBlueMapUtils.runOnVolcanoVentMarker(vent, marker -> TyphonBlueMapUtils.runOnMap(vent, (? super BlueMapMap map) -> {
            String markerSetID = TyphonBlueMapUtils.getVolcanoMarkerSetID(vent.volcano);
            MarkerSet set = (MarkerSet)map.getMarkerSets().get(markerSetID);
            if (set != null) {
                set.getMarkers().remove(TyphonBlueMapUtils.getVolcanoVentMarkerID(vent));
            }
        }));
    }

    public static Vector2i getIconSize() {
        return new Vector2i(18, 18);
    }

    public static void updateVolcanoVentIcon(VolcanoVent vent) {
        TyphonBlueMapUtils.runOnVolcanoVentMarker(vent, marker -> marker.setIcon(TyphonBlueMapUtils.getIconURLByStatus(vent), TyphonBlueMapUtils.getIconSize()));
    }

    public static void runOnMap(World bukkitWorld, Consumer<? super BlueMapMap> run) {
        if (!TyphonBlueMapUtils.getBlueMapAvailable()) {
            return;
        }
        TyphonBlueMapUtils.getBlueMapAPI().getWorld((Object)bukkitWorld.getUID()).ifPresent(world -> world.getMaps().forEach(run));
    }

    public static void runOnMap(Volcano volcano, Consumer<? super BlueMapMap> run) {
        TyphonBlueMapUtils.runOnMap(volcano.location.getWorld(), run);
    }

    public static void runOnMap(VolcanoVent vent, Consumer<? super BlueMapMap> run) {
        TyphonBlueMapUtils.runOnMap(vent.location.getWorld(), run);
    }
}

