/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon;

import java.util.ArrayList;
import java.util.List;
import me.alex4386.plugin.typhon.TyphonCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public enum TyphonCommandAction {
    CREATE("create", "<name> <?style>", "Create a new volcano"),
    NEAR("near", "", "Get nearby volcanoes"),
    LIST("list", "", "List all available volcanoes generated by typhon"),
    CONSTRUCTIONS("constructions", "", "Show current constructions running by typhon"),
    GAIA("gaia", "<?subcmd>", "Show gaia information"),
    SUCCESSOR("successor", "", "Give a tool for primary succession"),
    DEBUG("debug", "", "Some undocumented debug feature for testing functions.");

    String cmdline;
    String usage;
    String explanation;

    private TyphonCommandAction(String cmdline, String usage, String explanation) {
        this.cmdline = cmdline;
        this.usage = usage;
        this.explanation = explanation;
    }

    public String getCommand() {
        return this.cmdline;
    }

    public static TyphonCommandAction getAction(String string) {
        for (TyphonCommandAction action : TyphonCommandAction.values()) {
            if (!action.getCommand().equalsIgnoreCase(string)) continue;
            return action;
        }
        return null;
    }

    public String getManual(String label) {
        return String.valueOf(ChatColor.LIGHT_PURPLE) + "/" + label + " " + String.valueOf(ChatColor.YELLOW) + this.cmdline + " " + String.valueOf(ChatColor.GRAY) + this.usage + String.valueOf(ChatColor.RESET) + " : " + this.explanation;
    }

    public static List<String> listAll() {
        ArrayList<String> all = new ArrayList<String>();
        for (TyphonCommandAction action : TyphonCommandAction.values()) {
            all.add(action.getCommand());
        }
        return all;
    }

    public static List<String> listAll(CommandSender sender) {
        ArrayList<String> all = new ArrayList<String>();
        for (TyphonCommandAction action : TyphonCommandAction.values()) {
            if (!TyphonCommand.hasPermission(sender, action.getCommand())) continue;
            all.add(action.getCommand());
        }
        return all;
    }

    public static String getAllManual(CommandSender sender, String label) {
        Object all = "";
        for (TyphonCommandAction action : TyphonCommandAction.values()) {
            if (!TyphonCommand.hasPermission(sender, action.getCommand())) continue;
            all = (String)all + action.getManual(label) + "\n";
        }
        return all;
    }
}

