/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class TyphonNavigation {
    double yawDegree;
    double distance;
    Location target;
    Location source;

    TyphonNavigation(Location target, Location source) {
        double deltaYaw;
        this.target = target;
        this.source = source;
        double dx = target.getX() - source.getX();
        double dz = target.getZ() - source.getZ();
        double distance = Math.sqrt(dx * dx + dz * dz);
        double targetYaw = Math.toDegrees(Math.atan2(-dx, dz));
        targetYaw = (targetYaw + 360.0) % 360.0;
        float playerYawRaw = source.getYaw();
        double playerYaw = (playerYawRaw + 360.0f) % 360.0f;
        this.yawDegree = deltaYaw = (targetYaw - playerYaw + 540.0) % 360.0 - 180.0;
        this.distance = distance;
    }

    public String getNavigation() {
        double destinationYaw = this.yawDegree;
        double directDistance = this.distance;
        Object destinationString = "";
        destinationString = Math.abs(Math.floor(destinationYaw)) + " degrees " + (Math.abs(destinationYaw) < 1.0 ? "Forward" : (destinationYaw < 0.0 ? "Left" : "Right")) + (Math.abs(destinationYaw) > 135.0 ? " Backward" : "");
        if (Double.isNaN(destinationYaw) || directDistance < 1.0) {
            return "Arrived!";
        }
        destinationString = (String)destinationString + " / " + String.format("%.2f", directDistance) + " blocks";
        return destinationString;
    }

    private String getSimpleDirectionLabel(double yaw) {
        double abs = Math.abs(yaw);
        if (abs < 15.0) {
            return "Continue straight";
        }
        if (abs < 45.0) {
            return yaw < 0.0 ? "Slight left" : "Slight right";
        }
        if (abs < 90.0) {
            return yaw < 0.0 ? "Turn left" : "Turn right";
        }
        if (abs < 135.0) {
            return yaw < 0.0 ? "Sharp left" : "Sharp right";
        }
        return yaw < 0.0 ? "U-turn left" : "U-turn right";
    }

    public double getClimb() {
        return this.target.getY() - this.source.getY();
    }

    public void sendToSender(CommandSender sender) {
        ChatColor climbColor;
        if (Double.isNaN(this.yawDegree) || this.distance < 1.0) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2713 You\u2019ve arrived at your destination!");
            return;
        }
        double climb = this.getClimb();
        String arrow = this.getArrow();
        String direction = this.getSimpleDirectionLabel(this.yawDegree);
        String distanceStr = String.format("%.0f", this.distance);
        String climbStr = (climb > 0.0 ? "+" : "") + String.format("%.0f", climb);
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + arrow + " " + direction + " " + String.valueOf(ChatColor.GRAY) + "(" + distanceStr + " blocks)");
        ChatColor chatColor = climb < 0.0 ? ChatColor.AQUA : (climbColor = climb > 0.0 ? ChatColor.RED : ChatColor.GRAY);
        String climbArrow = climb > 0.0 ? "\u25b2" : (climb < 0.0 ? "\u25bc" : "-");
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Climb: " + String.valueOf(climbColor) + climbStr + " blocks " + climbArrow);
    }

    public String getArrow() {
        if (Double.isNaN(this.yawDegree) || this.distance < 1.0) {
            return "\u2713";
        }
        double yaw = this.yawDegree;
        if (yaw <= -135.0) {
            return "\u2199";
        }
        if (yaw <= -45.0) {
            return "\u2190";
        }
        if (yaw <= -15.0) {
            return "\u2196";
        }
        if (yaw < 15.0) {
            return "\u2191";
        }
        if (yaw < 45.0) {
            return "\u2197";
        }
        if (yaw < 135.0) {
            return "\u2192";
        }
        return "\u2198";
    }

    public static TyphonNavigation getNavigation(Location from, Location to) {
        if (!from.getWorld().getUID().equals(to.getWorld().getUID())) {
            return null;
        }
        return new TyphonNavigation(to, from);
    }
}

