/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon;

import de.bluecolored.bluemap.api.BlueMapAPI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.alex4386.plugin.typhon.TyphonBlueMapUtils;
import me.alex4386.plugin.typhon.TyphonCommand;
import me.alex4386.plugin.typhon.TyphonCoreProtectUtils;
import me.alex4386.plugin.typhon.TyphonMultithreading;
import me.alex4386.plugin.typhon.TyphonToolEvents;
import me.alex4386.plugin.typhon.TyphonWorldGuardUtils;
import me.alex4386.plugin.typhon.gaia.TyphonGaia;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.bomb.VolcanoBombListener;
import me.alex4386.plugin.typhon.volcano.bomb.VolcanoBombs;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogger;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoConstructionStatus;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.parser.ParseException;

public final class TyphonPlugin
extends JavaPlugin {
    public static File dataDir;
    public static File volcanoDir;
    public static Map<String, Volcano> listVolcanoes;
    public static List<VolcanoConstructionStatus> constructionStatuses;
    public static VolcanoLogger logger;
    public static Plugin plugin;
    public static VolcanoBombListener vbl;
    public static TyphonToolEvents events;
    public static BlueMapAPI blueMap;
    public static boolean enableBlueMap;
    public static TyphonWorldGuardUtils worldGuard;
    public static TyphonCoreProtectUtils coreProtect;
    public static boolean isShuttingdown;
    public static int minecraftTicksPerSeconds;
    public static String version;

    public void onEnable() {
        File[] volcanoDirs;
        plugin = this;
        version = this.getDescription().getVersion();
        logger.log(VolcanoLogClass.INIT, "Initializing...");
        if (version.toLowerCase().contains("snapshot")) {
            logger.warn(VolcanoLogClass.INIT, "You are using developer build of the Typhon or nightly CI Build. Expect Bugs.");
        }
        dataDir = this.getDataFolder();
        volcanoDir = new File(dataDir, "Volcanoes");
        logger.debug(VolcanoLogClass.INIT, "Data directory detected: " + String.valueOf(dataDir));
        if (!dataDir.exists()) {
            logger.debug(VolcanoLogClass.INIT, "Data directory not found, creating one...");
            dataDir.mkdir();
        }
        logger.debug(VolcanoLogClass.INIT, "Volcano Data detected: " + String.valueOf(volcanoDir));
        if (!volcanoDir.exists()) {
            logger.debug(VolcanoLogClass.INIT, "Volcano Data directory not found, creating one...");
            volcanoDir.mkdir();
        }
        logger.debug(VolcanoLogClass.INIT, "Presetting default config if not exists...");
        this.saveDefaultConfig();
        logger.debug(VolcanoLogClass.INIT, "Loading Volcano default config...");
        TyphonPlugin.loadConfig();
        try {
            logger.debug(VolcanoLogClass.INIT, "Initializing WorldGuard support...");
            worldGuard = TyphonWorldGuardUtils.getInstance((Plugin)this);
        }
        catch (NoClassDefFoundError e) {
            logger.debug(VolcanoLogClass.INIT, "WorldGuard could not be found. Skipping...");
        }
        try {
            logger.debug(VolcanoLogClass.INIT, "Initializing CoreProtect support...");
            coreProtect = TyphonCoreProtectUtils.getInstance((Plugin)this);
        }
        catch (NoClassDefFoundError e) {
            logger.debug(VolcanoLogClass.INIT, "CoreProtect could not be found. Skipping...");
        }
        logger.debug(VolcanoLogClass.INIT, "Loading Volcanoes...");
        if (TyphonMultithreading.isPaperMultithread) {
            logger.log(VolcanoLogClass.INIT, "Paper/Folia detected! Enabling MultiThreading Schedulers!");
        }
        for (File volcanoDir : volcanoDirs = TyphonPlugin.volcanoDir.listFiles()) {
            if (!volcanoDir.isDirectory()) continue;
            String volcanoName = volcanoDir.getName();
            try {
                Volcano volcano = new Volcano(volcanoDir.toPath());
                listVolcanoes.put(volcano.name, volcano);
            }
            catch (IOException e) {
                logger.error(VolcanoLogClass.INIT, "Loading volcano " + volcanoName + " at path " + volcanoDir.getPath() + " caused I/O Error!");
            }
            catch (ParseException e) {
                logger.error(VolcanoLogClass.INIT, "Loading volcano " + volcanoName + " at path " + volcanoDir.getPath() + " caused Invalid JSON Error! Please turn on debug mode for verbose output!");
            }
        }
        logger.debug(VolcanoLogClass.CORE, "Loaded Volcanoes!");
        if (enableBlueMap) {
            try {
                BlueMapAPI.onEnable(blueMapAPI -> {
                    blueMap = blueMapAPI;
                    TyphonBlueMapUtils.initialize();
                });
            }
            catch (NoClassDefFoundError e) {
                logger.warn(VolcanoLogClass.CORE, "Could not find BlueMapAPI, disabling BlueMap!");
            }
        }
        logger.log(VolcanoLogClass.PLAYER_EVENT, "Initializing...");
        logger.log(VolcanoLogClass.PLAYER_EVENT, "Initialization complete!");
        logger.log(VolcanoLogClass.BOMB, "Initializing...");
        vbl = new VolcanoBombListener();
        vbl.initialize();
        logger.log(VolcanoLogClass.BOMB, "Initialization Complete!");
        logger.log(VolcanoLogClass.GAIA, "Initializing...");
        TyphonGaia.initialize();
        logger.log(VolcanoLogClass.GAIA, "Initialization Complete!");
        events = new TyphonToolEvents();
        events.initialize();
        logger.log(VolcanoLogClass.INIT, "Initialization Complete!");
    }

    public static void reload() {
        logger.log(VolcanoLogClass.CORE, "Reload Requested. Processing Reload...");
        logger.debug(VolcanoLogClass.CORE, "Shutting down all loaded volcanoes...");
        for (Map.Entry<String, Volcano> entry : listVolcanoes.entrySet()) {
            Volcano volcano = entry.getValue();
            volcano.shutdown();
            try {
                volcano.load();
            }
            catch (IOException e) {
                volcano.logger.error(VolcanoLogClass.INIT, "Reloading volcano " + volcano.name + " at path " + volcanoDir.getPath() + " caused I/O Error!");
            }
            catch (ParseException e) {
                volcano.logger.error(VolcanoLogClass.INIT, "Reloading volcano " + volcano.name + " at path " + volcanoDir.getPath() + " caused Invalid JSON Error! Please turn on debug mode for verbose output!");
            }
            volcano.initialize();
        }
        logger.debug(VolcanoLogClass.CORE, "Unloading Volcanoes...");
        listVolcanoes.clear();
        logger.debug(VolcanoLogClass.CORE, "Reloading Config...");
        plugin.reloadConfig();
        logger.debug(VolcanoLogClass.CORE, "Reloading Default Config...");
        TyphonPlugin.loadConfig();
        logger.log(VolcanoLogClass.CORE, "Reload Complete!");
    }

    public static void loadConfig() {
        enableBlueMap = plugin.getConfig().getBoolean("blueMap.enable", true);
        TyphonGaia.loadConfig(plugin.getConfig());
        FileConfiguration config = plugin.getConfig();
        if (!config.contains("worldGuard.enable")) {
            config.set("worldGuard.enable", (Object)true);
            plugin.saveConfig();
        }
        if (!config.contains("coreProtect.enable")) {
            config.set("coreProtect.enable", (Object)true);
            plugin.saveConfig();
        }
    }

    public void onDisable() {
        logger.debug(VolcanoLogClass.CORE, "Disabling Plugin...");
        isShuttingdown = true;
        TyphonGaia.shutdown();
        for (Volcano volcano : listVolcanoes.values()) {
            try {
                volcano.save(true);
                volcano.shutdown();
            }
            catch (IOException e) {
                volcano.logger.error(VolcanoLogClass.CORE, "Saving Failed! I/O Error detected!");
            }
        }
        vbl.shutdown();
        events.shutdown();
        VolcanoBombs.unregisterBombGlowTeams();
        isShuttingdown = false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        return TyphonCommand.onTabComplete(sender, command, label, args);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return TyphonCommand.onCommand(sender, command, label, args);
    }

    static {
        volcanoDir = new File(dataDir, "Volcanoes");
        listVolcanoes = new HashMap<String, Volcano>();
        constructionStatuses = new ArrayList<VolcanoConstructionStatus>();
        logger = new VolcanoLogger();
        blueMap = null;
        enableBlueMap = true;
        worldGuard = null;
        coreProtect = null;
        isShuttingdown = false;
        minecraftTicksPerSeconds = 20;
        version = "";
    }
}

