/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.gaia;

import java.util.Arrays;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.gaia.TyphonGaia;
import me.alex4386.plugin.typhon.volcano.VolcanoManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class TyphonGaiaCommand {
    public static boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
        if (newArgs.length == 0) {
            if (!sender.hasPermission("typhon.gaia")) {
                TyphonGaiaCommand.noPermission(sender);
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Gaia]");
            sender.sendMessage("Automatic Volcanic eruption system");
            sender.sendMessage("");
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "Enabled Worlds:");
            for (World world : TyphonGaia.enabledWorlds) {
                sender.sendMessage("- " + world.getName());
            }
            sender.sendMessage("");
            TyphonGaiaCommand.sendHelp(sender);
            return true;
        }
        String cmd = newArgs[0].toLowerCase();
        if (cmd.equalsIgnoreCase("enable-world") || cmd.equalsIgnoreCase("disable-world")) {
            String worldName = newArgs[1];
            String currentCmd = cmd.replace("-world", "");
            if (!sender.hasPermission("typhon.gaia.worlds." + currentCmd)) {
                TyphonGaiaCommand.noPermission(sender);
                return true;
            }
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                TyphonGaiaCommand.errorMessage(sender, "The specified world does not exist.");
                return true;
            }
            if (currentCmd.equalsIgnoreCase("enable")) {
                TyphonGaia.enableWorld(world);
            } else {
                TyphonGaia.disableWorld(world);
            }
            sender.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "The specified world (" + world.getName() + ") has been " + currentCmd + "d.");
            return true;
        }
        if (cmd.equalsIgnoreCase("worlds")) {
            if (!sender.hasPermission("typhon.gaia.worlds")) {
                TyphonGaiaCommand.noPermission(sender);
                return true;
            }
            if (newArgs.length == 1) {
                sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "Enabled Worlds:");
                for (World world : TyphonGaia.enabledWorlds) {
                    sender.sendMessage("- " + world.getName());
                }
                sender.sendMessage("");
                sender.sendMessage("Commands:");
                sender.sendMessage("/typhon gaia worlds <world> : Gaia world settings commands");
            } else if (newArgs.length >= 2) {
                World world = Bukkit.getWorld((String)newArgs[1]);
                if (world == null) {
                    TyphonGaiaCommand.errorMessage(sender, "The specified world does not exist.");
                    return true;
                }
                if (!TyphonGaia.enabledWorlds.contains(world)) {
                    TyphonGaiaCommand.errorMessage(sender, "The World " + world.getName() + " is not enabled.");
                    sender.sendMessage("Enable it with /typhon gaia enable-world " + world.getName());
                    return true;
                }
                if (newArgs.length == 2) {
                    sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Gaia]");
                    sender.sendMessage("World Chunk count  : " + TyphonUtils.getChunkCount(world));
                    sender.sendMessage("World Area (Loaded): " + TyphonUtils.getChunkCount(world) * 256L);
                    sender.sendMessage("Adequate volcanoes : " + TyphonGaia.getAdequateVolcanoCount(world));
                    sender.sendMessage("Current Volcanoes  : " + VolcanoManager.getVolcanoesOnWorld(world).size());
                    sender.sendMessage("Active Volcanoes   : " + VolcanoManager.getActiveVolcanoesOnWorld(world).size());
                    sender.sendMessage("");
                    sender.sendMessage("Usage: /typhon gaia worlds <world> help");
                    return true;
                }
                if (newArgs.length >= 3) {
                    String action = newArgs[2].toLowerCase();
                    if (action.equalsIgnoreCase("help")) {
                        sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Gaia] " + String.valueOf(ChatColor.GOLD) + "Gaia World commands");
                        sender.sendMessage("/typhon gaia worlds <world> help   : Show this help");
                        sender.sendMessage("/typhon gaia worlds <world> volcano: List currently detected volcanoes by gaia.");
                        sender.sendMessage("/typhon gaia worlds <world> balance: Balance the world with adequate amount of volcanoes.");
                    } else if (action.equalsIgnoreCase("volcano")) {
                        sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Gaia] " + String.valueOf(ChatColor.GOLD) + "Active Volcanoes");
                        VolcanoManager.getActiveVolcanoesOnWorld(world).forEach(volcano -> sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + " - " + String.valueOf(volcano.manager.getVolcanoChatColor()) + volcano.name));
                    } else if (action.equalsIgnoreCase("balance")) {
                        TyphonGaia.runVolcanoSpawn();
                        sender.sendMessage("Gaia just balanced the world with adequate amount of volcanoes.");
                    } else {
                        sender.sendMessage("Usage: /typhon gaia worlds <world> help");
                    }
                    return true;
                }
                sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Gaia]");
                sender.sendMessage("Usage: /typhon gaia worlds <enable|disable> <world>");
                return true;
            }
        } else if (cmd.equalsIgnoreCase("help")) {
            TyphonGaiaCommand.sendHelp(sender);
        } else {
            if (cmd.equalsIgnoreCase("bubble")) {
                if (newArgs.length == 1) {
                    sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Gaia Volcano Bubble Radius: " + TyphonGaia.bubbleRadius);
                } else if (newArgs.length == 2) {
                    String valueRaw = newArgs[1];
                    int value = Integer.parseInt(valueRaw);
                    if (value <= 0) {
                        TyphonGaiaCommand.errorMessage(sender, "Value must be greater than 0.");
                        return true;
                    }
                    TyphonGaia.bubbleRadius = value;
                    TyphonGaia.saveConfig();
                    sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Bubble radius set to " + value);
                } else {
                    TyphonGaiaCommand.errorMessage(sender, "Usage: /typhon gaia bubble <?value>");
                }
                return true;
            }
            TyphonGaiaCommand.errorMessage(sender, "Unknown command.");
            sender.sendMessage("Usage: /typhon gaia help");
        }
        return true;
    }

    public static void sendHelp(CommandSender sender) {
        sender.sendMessage("Commands:");
        sender.sendMessage("/typhon gaia worlds: Use Gaia world management commands.");
        sender.sendMessage("/typhon gaia spawn : Use Gaia volcano spawn commands.");
        sender.sendMessage("/typhon gaia bubble <?value> : Get/Set Gaia volcano spawn \"bubble\".");
        sender.sendMessage("/typhon gaia enable-world <? world>: Enable world for Gaia.");
        sender.sendMessage("/typhon gaia disable-world <? world>: Disable world for Gaia.");
    }

    public static void noPermission(CommandSender sender) {
        TyphonGaiaCommand.errorMessage(sender, "You do not have permission to use this command.");
    }

    public static void errorMessage(CommandSender sender, String message) {
        sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Gaia]");
        sender.sendMessage(message);
    }
}

