/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano;

import java.util.Random;
import me.alex4386.plugin.typhon.TyphonUtils;
import org.bukkit.Material;

public class VolcanoComposition {
    public static Material getBombRock(double silicateLevel) {
        return VolcanoComposition.getBombRock(silicateLevel, 1.0);
    }

    public static Material getBombRock(double silicateLevel, double distanceScale) {
        Random random = new Random();
        if (silicateLevel < 0.57) {
            double redScoriaRatio = (silicateLevel - 0.45) / 0.11999999999999994;
            double redScoriaPercentage = Math.max(0.0, Math.min(Math.pow(redScoriaRatio, 2.0), 1.0));
            double threshold = 0.6;
            double adapted = 1.0;
            if (distanceScale < threshold) {
                adapted = 1.0 - Math.pow(1.0 - distanceScale / threshold, 2.0);
            }
            double scaled = Math.max(0.1, adapted);
            double s = random.nextDouble();
            if (s < scaled) {
                return Material.COBBLED_DEEPSLATE;
            }
            if (Math.random() > redScoriaPercentage) {
                if (Math.random() < 1.0E-4) {
                    return Material.NETHER_QUARTZ_ORE;
                }
                return Material.NETHERRACK;
            }
            return Material.COBBLED_DEEPSLATE;
        }
        if (silicateLevel < 0.7) {
            return Material.TUFF;
        }
        if (silicateLevel < 0.9) {
            double s = random.nextDouble();
            if (s > 0.2) {
                return Material.TUFF;
            }
            if (s > 0.1) {
                return Material.AMETHYST_BLOCK;
            }
            if (Math.random() < 0.9) {
                return Material.NETHER_QUARTZ_ORE;
            }
            return Material.QUARTZ_BLOCK;
        }
        if (Math.random() < 0.9) {
            return Material.NETHER_QUARTZ_ORE;
        }
        return Material.QUARTZ_BLOCK;
    }

    public static Material getExtrusiveRock(double silicateLevel) {
        Random random = new Random();
        if (silicateLevel < 0.41) {
            return Material.DEEPSLATE;
        }
        if (silicateLevel < 0.45) {
            double ratio = (silicateLevel - 0.45) / 0.040000000000000036;
            double s = random.nextDouble();
            if (s > ratio) {
                return Material.DEEPSLATE;
            }
            if (random.nextBoolean()) {
                return Material.POLISHED_BASALT;
            }
            return Material.BASALT;
        }
        if (silicateLevel < 0.53) {
            if (random.nextBoolean()) {
                return Material.POLISHED_BASALT;
            }
            return Material.BASALT;
        }
        if (silicateLevel < 0.57) {
            double ratio = (silicateLevel - 0.53) / 0.039999999999999925;
            double s = random.nextDouble();
            if (s > ratio) {
                if (random.nextBoolean()) {
                    return Material.POLISHED_BASALT;
                }
                return Material.BASALT;
            }
            return VolcanoComposition.getExtrusiveRock(0.64);
        }
        if (silicateLevel < 0.65) {
            if (Math.random() < 0.3) {
                return Material.TUFF;
            }
            return Material.ANDESITE;
        }
        if (silicateLevel < 0.69) {
            double ratio = (silicateLevel - 0.65) / 0.039999999999999925;
            double s = random.nextDouble();
            if (s > ratio) {
                return VolcanoComposition.getExtrusiveRock(0.64);
            }
            if (random.nextDouble() < 0.01 * ratio) {
                return Material.QUARTZ_BLOCK;
            }
            if (random.nextDouble() < 0.5 * ratio) {
                return random.nextDouble() < 0.9 ? Material.OBSIDIAN : Material.CRYING_OBSIDIAN;
            }
            if (random.nextDouble() < 0.1 * ratio) {
                return Material.GRANITE;
            }
            return Math.random() < 0.3 ? Material.COBBLESTONE : Material.STONE;
        }
        if (silicateLevel < 0.77) {
            double ratio = (silicateLevel - 0.77) / 0.05999999999999994;
            double s = random.nextDouble();
            if (s > ratio) {
                if (random.nextDouble() < 0.02) {
                    return Material.QUARTZ_BLOCK;
                }
                if (random.nextBoolean()) {
                    return Material.OBSIDIAN;
                }
                return Material.STONE;
            }
            if (random.nextDouble() < 0.5 * ratio) {
                return Material.AMETHYST_BLOCK;
            }
            return Material.GRANITE;
        }
        if (silicateLevel < 0.9) {
            double silicateRatio;
            double ratio = (silicateLevel - 0.77) / 0.13;
            double s = random.nextDouble();
            if (s > ratio && silicateLevel < 0.83) {
                if (random.nextDouble() < 0.5 * ratio) {
                    return Material.AMETHYST_BLOCK;
                }
                return Material.GRANITE;
            }
            s = random.nextDouble();
            if (s > (silicateRatio = (silicateLevel - 0.83) / 0.07000000000000006)) {
                return Material.AMETHYST_BLOCK;
            }
            return Material.QUARTZ_BLOCK;
        }
        return Material.QUARTZ_BLOCK;
    }

    @Deprecated
    public static Material getIntrusiveRock(double silicateLevel) {
        Random random = new Random();
        if (silicateLevel < 0.45) {
            return Material.BLACKSTONE;
        }
        if (silicateLevel < 0.53) {
            return Material.BASALT;
        }
        if (silicateLevel < 0.57) {
            double ratio = (silicateLevel - 0.53) / 0.039999999999999925;
            double s = random.nextDouble();
            if (s > ratio) {
                return Material.BASALT;
            }
            return Material.DIORITE;
        }
        if (silicateLevel < 0.65) {
            return Material.DIORITE;
        }
        if (silicateLevel < 0.69) {
            double ratio = (silicateLevel - 0.65) / 0.039999999999999925;
            double s = random.nextDouble();
            if (s > ratio) {
                return Material.DIORITE;
            }
            return Material.GRANITE;
        }
        if (silicateLevel < 0.77) {
            return Material.GRANITE;
        }
        if (silicateLevel < 0.83) {
            double ratio = (silicateLevel - 0.77) / 0.05999999999999994;
            double s = random.nextDouble();
            if (s > ratio) {
                return Material.GRANITE;
            }
            return Material.AMETHYST_BLOCK;
        }
        if (silicateLevel < 0.9) {
            double ratio = (silicateLevel - 0.77) / 0.13;
            double ratioAme = (silicateLevel - 0.83) / 0.07000000000000006;
            double s = random.nextDouble();
            if (s > ratio) {
                return Material.GRANITE;
            }
            if (random.nextDouble() > ratioAme) {
                return Material.AMETHYST_BLOCK;
            }
            return Material.QUARTZ_BLOCK;
        }
        return Material.QUARTZ_BLOCK;
    }

    public static boolean isVolcanicRock(Material material) {
        String materialName = TyphonUtils.toLowerCaseDumbEdition(material.name());
        return material == Material.STONE || material == Material.DEEPSLATE || material == Material.COBBLED_DEEPSLATE || material == Material.NETHERRACK || material == Material.DIORITE || material == Material.ANDESITE || materialName.contains("ore") || material == Material.MAGMA_BLOCK || material == Material.OBSIDIAN || materialName.contains("basalt") || material == Material.ANCIENT_DEBRIS || material == Material.TUFF;
    }
}

