/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.lavaflow;

import me.alex4386.plugin.typhon.TyphonBlocks;
import me.alex4386.plugin.typhon.TyphonSounds;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.VolcanoComposition;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.util.Vector;

public class VolcanoLavaCoolData {
    public int ticks;
    public Block block;
    public Block fromBlock;
    public Material material;
    public Block source;
    public int flowLimit = 10;
    public VolcanoVent flowedFromVent = null;
    boolean isBomb = false;
    public boolean isProcessed = false;
    public int runExtensionCount = 0;
    public boolean skipNormalLavaFlowLengthCheck = false;
    public double plumbExtension = 1.0;

    public VolcanoLavaCoolData(Block source, Block fromBlock, Block block, VolcanoVent flowedFromVent, Material material, int ticks) {
        this.source = source == null ? block : source;
        this.ticks = ticks;
        this.fromBlock = fromBlock;
        this.block = block;
        this.material = material;
        this.flowedFromVent = flowedFromVent;
    }

    public VolcanoLavaCoolData(Block source, Block fromBlock, Block block, VolcanoVent flowedFromVent, Material material, int ticks, boolean isBomb) {
        this(source, fromBlock, block, flowedFromVent, material, ticks);
        this.isBomb = isBomb;
        this.runExtensionCount = VolcanoLavaCoolData.calculateExtensionCount(this.flowedFromVent.lavaFlow.settings.silicateLevel, TyphonUtils.getTwoDimensionalDistance(source.getLocation(), fromBlock.getLocation()), Math.max(5.0, (double)this.flowedFromVent.getSummitBlock().getY() - this.flowedFromVent.location.getY()));
        if (this.isBomb) {
            this.runExtensionCount = 0;
        }
    }

    public VolcanoLavaCoolData(Block source, Block fromBlock, Block block, VolcanoVent flowedFromVent, Material material, int ticks, boolean isBomb, int runExtensionCount) {
        this(source, fromBlock, block, flowedFromVent, material, ticks, isBomb);
        this.flowedFromVent = flowedFromVent;
        this.runExtensionCount = runExtensionCount;
    }

    public static int calculateExtensionCount(double silicateLevel, double distance, double height) {
        if (silicateLevel > 0.68) {
            return 0;
        }
        double silicateRatio = (Math.max(0.48, silicateLevel) - 0.48) / 0.20000000000000007;
        double extensionRate = 0.1;
        if (Math.random() < Math.pow(silicateRatio, 1.5)) {
            return 0;
        }
        double extBySilicateLevel = Math.max(0.0, Math.pow(1.0 - silicateRatio, 2.5) * 4.0);
        double extendLimit = Math.max(20.0, extBySilicateLevel * height);
        if (extendLimit > distance || distance < 30.0) {
            double probability = Math.pow(distance / extendLimit, 2.0);
            if (Math.random() > probability) {
                return (int)extBySilicateLevel;
            }
        }
        return 0;
    }

    public boolean shouldCooldown() {
        return this.tickPassed() && !this.isProcessed;
    }

    public boolean shouldTickPass() {
        return !this.shouldCooldown() && !this.isProcessed;
    }

    public void tickPass() {
        if (this.shouldCooldown()) {
            this.coolDown();
        } else if (!this.isProcessed) {
            --this.ticks;
        }
    }

    public boolean tickPassed() {
        return this.isProcessed || this.ticks <= 0;
    }

    public boolean extensionCapable() {
        if (this.flowedFromVent != null) {
            return this.flowedFromVent.lavaFlow.extensionCapable(this.block.getLocation());
        }
        return true;
    }

    public void handleExtension() {
        BlockData bd = this.block.getBlockData();
        Location flowVector = this.block.getLocation().subtract(this.fromBlock.getLocation());
        Location sourceLocation = this.source.getLocation();
        sourceLocation.setY(this.block.getLocation().getY());
        Location ventFlowVector = this.block.getLocation().subtract(sourceLocation);
        int level = -1;
        if (bd instanceof Levelled) {
            Levelled levelBd = (Levelled)bd;
            level = levelBd.getLevel();
        }
        int targetExtensionValue = this.runExtensionCount - 1;
        if (bd instanceof Levelled && this.flowedFromVent != null) {
            if (this.fromBlock != null && flowVector.getBlockY() == 0 && 6 <= level && level < 8) {
                this.flowedFromVent.lavaFlow.queueBlockUpdate(this.block, this.material, TyphonUtils.getBlockFaceUpdater(flowVector.toVector()));
                BlockFace[] flowableFaces = new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH};
                if (Math.random() < 0.3) {
                    for (BlockFace bf : flowableFaces) {
                        Object obj;
                        Block flowDirectionBlock;
                        if (Math.random() < 0.2 || !(flowDirectionBlock = this.block.getRelative(bf)).getType().isAir() || this.flowedFromVent.lavaFlow.isLavaRegistered(flowDirectionBlock) || !((obj = this.flowedFromVent.lavaFlow.registerLavaCoolData(this.source, this.block, flowDirectionBlock, this.isBomb, targetExtensionValue)) instanceof VolcanoLavaCoolData)) continue;
                        VolcanoLavaCoolData data = (VolcanoLavaCoolData)obj;
                        data.plumbExtension = this.plumbExtension * (0.5 + Math.random() * 0.25);
                    }
                } else {
                    Block flowDirectionBlock;
                    Vector flowUnit = new Vector(flowVector.getX(), flowVector.getY(), flowVector.getZ()).normalize();
                    Vector ventFlowUnit = new Vector(ventFlowVector.getX(), ventFlowVector.getY(), ventFlowVector.getZ());
                    double pushingMultiplier = Math.min(0.5, Math.max(0.1, ventFlowVector.length() / 400.0));
                    Vector lavaPushingDirection = flowUnit.add(ventFlowUnit.multiply(pushingMultiplier)).normalize();
                    BlockFace targetFlowFace = null;
                    for (BlockFace bf : flowableFaces) {
                        Block flowDirectionBlock2 = this.block.getRelative(bf);
                        if (!flowDirectionBlock2.getType().isAir()) continue;
                        Vector vector = new Vector(bf.getModX(), bf.getModY(), bf.getModZ());
                        if (!((double)lavaPushingDirection.angle(vector) <= 0.7853981633974483)) continue;
                        targetFlowFace = bf;
                    }
                    if (targetFlowFace != null && !this.flowedFromVent.lavaFlow.isLavaRegistered(flowDirectionBlock = this.block.getRelative(targetFlowFace))) {
                        this.flowedFromVent.lavaFlow.registerLavaCoolData(this.source, this.block, flowDirectionBlock, this.isBomb, targetExtensionValue);
                    }
                }
            } else if (flowVector.getBlockY() == -1) {
                Block flowDirectionBlock = this.block.getLocation().add(flowVector).getBlock();
                Block bottomBlock = flowDirectionBlock.getRelative(BlockFace.DOWN);
                if (!this.flowedFromVent.lavaFlow.isLavaRegistered(flowDirectionBlock)) {
                    this.flowedFromVent.lavaFlow.queueBlockUpdate(flowDirectionBlock, this.material, TyphonUtils.getBlockFaceUpdater(flowVector.toVector()));
                    this.flowedFromVent.lavaFlow.registerLavaCoolData(this.source, this.block, flowDirectionBlock, this.isBomb, -1);
                }
                if (flowDirectionBlock.getType() == Material.WATER) {
                    return;
                }
                if (!bottomBlock.getType().isAir() && VolcanoComposition.isVolcanicRock(bottomBlock.getType())) {
                    double silicateLevel = this.flowedFromVent.lavaFlow.settings.silicateLevel;
                    Material material = !this.isBomb ? VolcanoComposition.getExtrusiveRock(silicateLevel) : VolcanoComposition.getBombRock(silicateLevel, this.flowedFromVent.lavaFlow.getDistanceRatio(flowDirectionBlock.getLocation()));
                    this.flowedFromVent.lavaFlow.queueBlockUpdate(flowDirectionBlock, material);
                }
            }
        }
    }

    public void coolDown() {
        if (Math.random() < 0.001) {
            TyphonSounds.getRandomLavaFragmenting().play(this.block.getLocation(), SoundCategory.BLOCKS, 0.1f, (float)(0.5 + Math.random() * 0.5));
        }
        if (this.flowedFromVent != null) {
            if (this.flowedFromVent.volcano.manager.isInAnyFormingCaldera(this.block.getLocation())) {
                this.flowedFromVent.lavaFlow.queueBlockUpdate(this.block, Material.AIR);
                return;
            }
            if (!this.flowedFromVent.isFlowingLava() && TyphonUtils.toLowerCaseDumbEdition(this.material.name()).contains("ore")) {
                this.material = VolcanoComposition.getExtrusiveRock(this.flowedFromVent.lavaFlow.settings.silicateLevel);
            }
            this.flowedFromVent.flushSummitCacheByLocation(this.block);
        }
        if (this.extensionCapable()) {
            boolean isExtension;
            boolean bl = isExtension = this.runExtensionCount > 0;
            if (!isExtension && !this.isBomb && this.flowedFromVent != null) {
                double stickiness = (this.flowedFromVent.lavaFlow.settings.silicateLevel - 0.45) / 0.08000000000000002;
                if (Math.random() > stickiness && this.flowedFromVent.lavaFlow.consumeLavaInflux(1.0)) {
                    this.runExtensionCount = 1;
                    isExtension = true;
                }
            }
            if (isExtension) {
                this.handleExtension();
            }
        }
        if (this.flowedFromVent != null) {
            this.flowedFromVent.lavaFlow.queueBlockUpdate(this.block, this.material, TyphonUtils.getBlockFaceUpdater(this.block.getLocation().subtract(this.fromBlock.getLocation()).toVector()));
        } else {
            TyphonBlocks.setBlockType(this.block, this.material);
        }
    }

    public void forceCoolDown() {
        Material material = this.material;
        if (this.flowedFromVent != null) {
            if (this.flowedFromVent.volcano.manager.isInAnyFormingCaldera(this.block.getLocation())) {
                TyphonBlocks.setBlockType(this.block, Material.AIR);
                this.ticks = 0;
                return;
            }
            if (!this.flowedFromVent.isFlowingLava() && TyphonUtils.toLowerCaseDumbEdition(material.name()).contains("ore")) {
                material = VolcanoComposition.getExtrusiveRock(this.flowedFromVent.lavaFlow.settings.silicateLevel);
            }
        }
        this.ticks = 0;
        TyphonBlocks.setBlockType(this.block, material);
    }
}

