/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.log;

import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public class VolcanoLogger {
    Volcano volcano = null;
    boolean isDebug = false;
    String typhonHeader = "[Typhon] ";

    public VolcanoLogger() {
    }

    public VolcanoLogger(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public VolcanoLogger(Volcano volcano) {
        this.volcano = volcano;
        this.isDebug = volcano.isDebug;
    }

    public VolcanoLogger(Volcano volcano, boolean isDebug) {
        this.volcano = volcano;
        this.isDebug = isDebug;
    }

    public void setDebug(boolean isDebug) {
        if (this.volcano != null) {
            this.volcano.isDebug = isDebug;
        }
    }

    public boolean getDebug() {
        if (this.volcano == null) {
            return this.isDebug;
        }
        return this.volcano.isDebug;
    }

    public String getHeader() {
        Object string = "";
        string = (String)string + String.valueOf(ChatColor.GOLD);
        string = (String)string + "[";
        string = (String)string + (this.volcano == null ? "SYSTEM" : this.volcano.name);
        string = (String)string + "]";
        string = (String)string + String.valueOf(ChatColor.RESET);
        string = (String)string + " ";
        return string;
    }

    public String getStrippedHeader() {
        Object string = "";
        string = (String)string + "[";
        string = (String)string + (this.volcano == null ? "SYSTEM" : this.volcano.name);
        string = (String)string + "]";
        string = (String)string + " ";
        return string;
    }

    public void debug(VolcanoLogClass logClass, String string) {
        String headers = this.typhonHeader + logClass.getStrippedHeader() + this.getStrippedHeader();
        if (this.getDebug()) {
            Bukkit.getLogger().info(headers + string);
        }
    }

    public void log(VolcanoLogClass logClass, String string) {
        String headers = this.typhonHeader + logClass.getStrippedHeader() + this.getStrippedHeader();
        Bukkit.getLogger().info(headers + string);
    }

    public void warn(VolcanoLogClass logClass, String string) {
        String headers = this.typhonHeader + logClass.getStrippedHeader() + this.getStrippedHeader();
        string.replace(ChatColor.RESET.toString(), ChatColor.YELLOW.toString());
        Bukkit.getLogger().severe(headers + string);
    }

    public void error(VolcanoLogClass logClass, String string) {
        String headers = this.typhonHeader + logClass.getStrippedHeader() + this.getStrippedHeader();
        string.replace(ChatColor.RESET.toString(), ChatColor.RED.toString());
        Bukkit.getLogger().severe(headers + string);
    }
}

