/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.log;

import java.util.ArrayList;
import java.util.List;
import me.alex4386.plugin.typhon.volcano.log.VolcanoVentEjectaTimeData;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class VolcanoVentRecord {
    VolcanoVent vent;
    public long startEjectaTracking = -1L;
    public int currentEjectaVolume = 0;
    public List<VolcanoVentEjectaTimeData> ejectaVolumeList = new ArrayList<VolcanoVentEjectaTimeData>();

    public VolcanoVentRecord(VolcanoVent vent) {
        this.vent = vent;
    }

    public boolean isEjectaTrackingStarted() {
        return this.startEjectaTracking < 0L;
    }

    public void startEjectaTracking() {
        if (this.isEjectaTrackingStarted()) {
            this.startEjectaTracking = System.currentTimeMillis();
        }
    }

    public void addEjectaVolume(int ejectaVolume) {
        this.startEjectaTracking();
        this.currentEjectaVolume += ejectaVolume;
    }

    public void endEjectaTrack() {
        if (this.startEjectaTracking < 0L) {
            return;
        }
        long startTime = this.startEjectaTracking;
        long endTime = System.currentTimeMillis();
        VolcanoVentEjectaTimeData timeData = new VolcanoVentEjectaTimeData(startTime, endTime, this.currentEjectaVolume);
        this.currentEjectaVolume = 0;
        this.ejectaVolumeList.add(timeData);
    }

    public long getTotalEjecta() {
        long total = 0L;
        for (VolcanoVentEjectaTimeData timeData : this.ejectaVolumeList) {
            total += (long)timeData.ejectaVolume;
        }
        return total += (long)this.currentEjectaVolume;
    }

    public void importConfig(JSONObject configData) {
        JSONObject ejectaData = (JSONObject)configData.get("ejecta");
        JSONArray ejectaTimeLog = (JSONArray)ejectaData.get("timeData");
        for (Object timeDataRaw : ejectaTimeLog) {
            JSONObject timeData = (JSONObject)timeDataRaw;
            VolcanoVentEjectaTimeData ventEjectaTimeData = new VolcanoVentEjectaTimeData(timeData);
            this.ejectaVolumeList.add(ventEjectaTimeData);
        }
    }

    public JSONObject exportConfig() {
        JSONObject configData = new JSONObject();
        JSONObject ejectaData = new JSONObject();
        JSONArray ejectaTimeLog = new JSONArray();
        for (VolcanoVentEjectaTimeData timeData : this.ejectaVolumeList) {
            ejectaTimeLog.add(timeData.serialize());
        }
        ejectaData.put("timeData", ejectaTimeLog);
        configData.put("ejecta", ejectaData);
        return configData;
    }
}

