/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.vent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import me.alex4386.plugin.typhon.TyphonBlocks;
import me.alex4386.plugin.typhon.TyphonBlueMapUtils;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.VolcanoComposition;
import me.alex4386.plugin.typhon.volcano.ash.VolcanoAsh;
import me.alex4386.plugin.typhon.volcano.bomb.VolcanoBombs;
import me.alex4386.plugin.typhon.volcano.dome.VolcanoLavaDome;
import me.alex4386.plugin.typhon.volcano.erupt.VolcanoErupt;
import me.alex4386.plugin.typhon.volcano.explosion.VolcanoExplosion;
import me.alex4386.plugin.typhon.volcano.landslide.VolcanoLandslide;
import me.alex4386.plugin.typhon.volcano.lavaflow.VolcanoLavaFlow;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.log.VolcanoVentRecord;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoCircleOffsetXZ;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoMath;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoTremor;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentBuilder;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentCaldera;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentGenesis;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentStatus;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentSurtseyan;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.json.simple.JSONObject;

public class VolcanoVent {
    public static int defaultVentRadius = 20;
    public boolean enabled = true;
    public Volcano volcano;
    public String name = null;
    private VolcanoVentStatus status = VolcanoVentStatus.DORMANT;
    private VolcanoVentType type = VolcanoVentType.CRATER;
    public VolcanoVentGenesis genesis = VolcanoVentGenesis.POLYGENETIC;
    public Location location;
    public int craterRadius = defaultVentRadius;
    public double fissureAngle = Math.random() * Math.PI * 2.0;
    public int fissureLength = 10;
    public int maxFissureLength = 200;
    public double longestFlowLength = 0.0;
    public double longestNormalLavaFlowLength = 0.0;
    public double currentFlowLength = 0.0;
    public double currentNormalLavaFlowLength = 0.0;
    public double longestAshNormalFlowLength = 0.0;
    public double currentAshNormalFlowLength = 0.0;
    public double calderaRadius = 0.0;
    private Block cachedSummitBlock = null;
    private long cachedSummitBlockLastSync = 0L;
    private List<Block> cachedVentBlocks = null;
    private long cachedVentBlocksLastSync = 0L;
    public List<Block> coreBlocks = null;
    private List<Block> leeveBlocks = null;
    public VolcanoBombs bombs = new VolcanoBombs(this);
    public VolcanoExplosion explosion = new VolcanoExplosion(this);
    public VolcanoTremor tremor = new VolcanoTremor(this);
    public VolcanoLavaFlow lavaFlow = new VolcanoLavaFlow(this);
    public VolcanoVentRecord record = new VolcanoVentRecord(this);
    public VolcanoErupt erupt = new VolcanoErupt(this);
    public VolcanoAsh ash = new VolcanoAsh(this);
    public VolcanoLavaDome lavadome = new VolcanoLavaDome(this);
    public VolcanoVentCaldera caldera = new VolcanoVentCaldera(this);
    public VolcanoLandslide landslide = new VolcanoLandslide(this);
    public VolcanoVentSurtseyan surtseyan = new VolcanoVentSurtseyan(this);
    public VolcanoVentBuilder builder = new VolcanoVentBuilder(this);
    public boolean autoStyleUpdate = false;
    public boolean enableSuccession = true;
    public double successionProbability = 0.05;
    public double successionTreeProbability = 0.05;
    public double fullPyroclasticFlowProbability = 1.0E-4;
    public boolean enableKillSwitch = false;
    public long killAt = 0L;
    long lastVentShuffle = 0L;

    public VolcanoVent(Volcano volcano) {
        this.volcano = volcano;
        this.location = volcano.location;
        this.name = "main";
    }

    public VolcanoVent(Volcano volcano, Location location, String name) {
        this.volcano = volcano;
        this.location = location;
        this.name = name;
    }

    public VolcanoVent(Volcano volcano, JSONObject configData) {
        this.volcano = volcano;
        this.importConfig(configData);
    }

    public Volcano getVolcano() {
        return this.volcano;
    }

    public VolcanoVentStatus getStatus() {
        return this.status;
    }

    public Block getLowestCoreBlock() {
        List<Block> coreBlocks = this.getCoreBlocks();
        Block lowestCoreBlock = coreBlocks.get(0);
        for (Block coreBlock : coreBlocks) {
            if (coreBlock.getY() >= lowestCoreBlock.getY()) continue;
            lowestCoreBlock = coreBlock;
        }
        return lowestCoreBlock;
    }

    public double getBasinLength() {
        double longestFlow = Math.max(this.getVolcanicRadius(), (double)(this.getSummitBlock().getY() - this.location.getWorld().getSeaLevel()) * Math.sqrt(3.0));
        return Math.max(longestFlow, (double)this.craterRadius);
    }

    public void resetCurrentMetrics() {
        this.currentFlowLength = 0.0;
        this.currentNormalLavaFlowLength = 0.0;
        this.currentAshNormalFlowLength = 0.0;
    }

    public void setStatus(VolcanoVentStatus status) {
        this.status = status;
        if (TyphonBlueMapUtils.getBlueMapAvailable()) {
            TyphonBlueMapUtils.updateVolcanoVentIcon(this);
        }
    }

    public List<Player> getPlayersInRange() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Location loc;
            if (!player.getWorld().getUID().equals(this.location.getWorld().getUID()) || !this.isBombAffected(loc = player.getLocation()) && !this.isInLavaFlow(loc) && !this.isInVent(loc)) continue;
            players.add(player);
        }
        return players;
    }

    public void reset() {
        this.maxFissureLength = 0;
        this.longestFlowLength = 0.0;
        this.longestNormalLavaFlowLength = 0.0;
        this.bombs.maxDistance = 0.0;
        this.getVolcano().trySave(true);
    }

    public void kill() {
        this.volcano.logger.log(VolcanoLogClass.VENT, "Killing vent " + this.name + " due to kill switch.");
        this.shutdown();
        this.quickCool();
        this.delete();
    }

    public void quickCool() {
        this.bombs.shutdown();
        this.lavaFlow.cooldownAll();
    }

    public void initialize() {
        if (this.isKillSwitchActive()) {
            this.kill();
            return;
        }
        this.volcano.logger.log(VolcanoLogClass.VENT, "Starting up vent " + this.name);
        this.getVentBlocks();
        this.ash.initialize();
        this.explosion.initialize();
        this.lavaFlow.initialize();
        this.tremor.initialize();
        this.lavadome.initialize();
        this.bombs.initialize();
        this.landslide.initialize();
        this.builder.initialize();
        this.volcano.logger.log(VolcanoLogClass.VENT, "Started up vent " + this.name);
    }

    public VolcanoVentType getType() {
        return this.type;
    }

    public void shutdown() {
        this.volcano.logger.log(VolcanoLogClass.VENT, "Shutting down vent " + this.name);
        this.ash.shutdown();
        this.explosion.shutdown();
        this.lavaFlow.shutdown();
        this.tremor.shutdown();
        this.record.endEjectaTrack();
        this.volcano.trySave(true);
        this.bombs.shutdown();
        this.lavadome.shutdown();
        this.landslide.shutdown();
        this.builder.shutdown();
        this.volcano.logger.log(VolcanoLogClass.VENT, "Shutted down vent " + this.name);
    }

    public void delete() {
        this.stop();
        this.shutdown();
        if (this.volcano != null) {
            if (this.isMainVent()) {
                try {
                    this.volcano.delete();
                }
                catch (IOException iOException) {}
            } else {
                this.volcano.subVents.remove(this.name);
                this.volcano.dataLoader.deleteSubVentConfig(this.getName());
                if (this.volcano.mainVent != null) {
                    this.volcano.mainVent.record.ejectaVolumeList.addAll(this.record.ejectaVolumeList);
                }
                TyphonBlueMapUtils.removeVolcanoVentMarker(this);
            }
        }
    }

    public boolean isCaldera() {
        return this.calderaRadius > 0.0;
    }

    public String getName() {
        return this.name == null ? String.valueOf(ChatColor.GOLD) + "main" + String.valueOf(ChatColor.RESET) : this.name;
    }

    public boolean isCacheInitialized() {
        return this.cachedVentBlocks != null;
    }

    public void removeInvalidVentBlocks() {
        double averageY = this.averageVentHeight();
        for (Block block : this.getVentBlocks()) {
            Block highest;
            Block underHighest;
            if (!((double)block.getY() > averageY + 5.0) || !(underHighest = (highest = TyphonUtils.getHighestRocklikes(block)).getRelative(BlockFace.DOWN)).getType().isAir()) continue;
            TyphonBlocks.setBlockType(highest, Material.AIR);
            averageY = this.averageVentHeight();
        }
    }

    public double getVolcanicRadius() {
        return Math.max(this.longestNormalLavaFlowLength, this.longestAshNormalFlowLength);
    }

    public List<Block> getVentBlocksScaffold() {
        List<Object> scaffoldBlocks = new ArrayList();
        if (this.type == VolcanoVentType.CRATER) {
            scaffoldBlocks = VolcanoMath.getHollowCircle(this.location.getBlock(), this.craterRadius);
        } else if (this.type == VolcanoVentType.FISSURE) {
            ArrayList<Block> ventBlocksWithCrater = new ArrayList<Block>();
            Block fromBlock = this.location.getBlock();
            ventBlocksWithCrater.addAll(VolcanoMath.getLine(fromBlock, this.fissureAngle, this.fissureLength));
            scaffoldBlocks = ventBlocksWithCrater;
        } else {
            scaffoldBlocks = VolcanoMath.getHollowCircle(this.location.getBlock(), this.craterRadius);
        }
        return scaffoldBlocks;
    }

    public List<Block> getVentBlocks() {
        boolean isFirstLoad = false;
        if (!this.isCacheInitialized()) {
            isFirstLoad = true;
            this.volcano.logger.log(VolcanoLogClass.VENT, "Calculating vent blocks of " + this.getName() + "...");
            this.cachedVentBlocks = this.getVentBlocksScaffold();
            this.volcano.logger.log(VolcanoLogClass.VENT, "Calculated vent blocks for vent " + this.getName() + ". " + this.cachedVentBlocks.size() + " blocks found.");
            World world = null;
            ArrayList<VolcanoCircleOffsetXZ> chunks = new ArrayList<VolcanoCircleOffsetXZ>();
            for (Block block : this.cachedVentBlocks) {
                world = block.getWorld();
                int chunkX = block.getLocation().getBlockX() >> 4;
                int chunkZ = block.getLocation().getBlockZ() >> 4;
                boolean chunkFound = false;
                for (VolcanoCircleOffsetXZ chunk : chunks) {
                    if (chunk.x != (double)chunkX || chunk.z != (double)chunkZ) continue;
                    chunkFound = true;
                    break;
                }
                if (chunkFound) continue;
                chunks.add(new VolcanoCircleOffsetXZ(chunkX, chunkZ));
            }
            this.volcano.logger.log(VolcanoLogClass.VENT, chunks.size() + " chunks are required to load vent of " + this.getName() + "...");
            if (world != null) {
                int i = 1;
                for (VolcanoCircleOffsetXZ chunkData : chunks) {
                    this.volcano.logger.log(VolcanoLogClass.VENT, "Loading vent chunk of " + this.getName() + "... (" + i + "/" + chunks.size() + ")");
                    Chunk chunk = world.getChunkAt((int)chunkData.x, (int)chunkData.z);
                    if (!chunk.isLoaded()) {
                        chunk.load();
                    }
                    ++i;
                }
            }
        }
        if (this.coreBlocks == null) {
            ArrayList<Block> coreBlocks = new ArrayList<Block>();
            TyphonPlugin.logger.log(VolcanoLogClass.CORE, "Calculating core blocks of " + this.getName() + "...");
            if (this.type == VolcanoVentType.FISSURE) {
                coreBlocks.addAll(VolcanoMath.getLine(this.location.getBlock(), this.fissureAngle, this.fissureLength));
            } else {
                coreBlocks.add(this.location.getBlock());
            }
            this.coreBlocks = coreBlocks;
        }
        if (isFirstLoad) {
            this.volcano.logger.log(VolcanoLogClass.VENT, "Calculating highest points of vent blocks of " + this.getName() + "...");
        }
        if (this.cachedVentBlocksLastSync != 0L) {
            boolean isCacheExpired = false;
            if (this.cachedSummitBlock == null) {
                isCacheExpired = true;
            } else {
                if (this.cachedSummitBlockLastSync > this.cachedVentBlocksLastSync) {
                    isCacheExpired = true;
                }
                if (this.cachedVentBlocksLastSync < System.currentTimeMillis() - 500L) {
                    isCacheExpired = true;
                }
            }
            if (!isCacheExpired) {
                return this.cachedVentBlocks;
            }
        }
        ArrayList<Block> newCachedVentBlocks = new ArrayList<Block>();
        for (Block block : this.cachedVentBlocks) {
            if (block.getType() == Material.LAVA) {
                newCachedVentBlocks.add(block);
                continue;
            }
            newCachedVentBlocks.add(TyphonUtils.getHighestRocklikes(block.getLocation()));
        }
        if (isFirstLoad) {
            this.volcano.logger.log(VolcanoLogClass.VENT, "Vent block calculation of " + this.getName() + " complete.");
        }
        this.cachedVentBlocks = newCachedVentBlocks;
        this.cachedSummitBlockLastSync = System.currentTimeMillis();
        Collections.shuffle(this.cachedVentBlocks);
        return this.cachedVentBlocks;
    }

    public double getHeatValue(Location loc) {
        double converted;
        double multiplier;
        double distance = this.getTwoDimensionalDistance(loc);
        double killZone = this.getRadius();
        double pillowRatio = 0.2;
        double d = multiplier = this.status.getScaleFactor() <= VolcanoVentStatus.DORMANT.getScaleFactor() ? Math.sqrt(this.status.getScaleFactor()) : 1.0;
        if (distance <= killZone) {
            return multiplier;
        }
        double basinLength = this.getBasinLength();
        double deltaFromNormalLava = this.longestFlowLength - basinLength;
        double correctedLavaLength = basinLength + deltaFromNormalLava * pillowRatio;
        double correctedDistance = distance;
        if (correctedDistance > basinLength) {
            double delta = correctedDistance - basinLength;
            correctedDistance = basinLength + pillowRatio * delta;
        }
        if ((converted = (correctedDistance - killZone) / (correctedLavaLength - killZone)) >= 1.0) {
            return 0.0;
        }
        double reversed = Math.max(1.0 - converted, 0.0);
        return Math.pow(reversed, 1.5) * multiplier;
    }

    public int getRadius() {
        return this.craterRadius;
    }

    public void flushCache() {
        this.cachedVentBlocks = null;
        this.coreBlocks = null;
        this.leeveBlocks = null;
        this.flushSummitCache();
    }

    public void setRadius(int ventRadius) {
        this.craterRadius = ventRadius;
        this.flushCache();
    }

    public void setType(VolcanoVentType type) {
        this.type = type;
        this.flushCache();
    }

    public double averageVentHeight() {
        int totalY = 0;
        for (Block block : this.cachedVentBlocks) {
            Location loc = block.getLocation();
            loc.setY((double)block.getWorld().getMaxHeight());
            int highestY = TyphonUtils.getHighestRocklikes(loc.getBlock()).getY();
            totalY += highestY;
        }
        return (double)totalY / (double)this.cachedVentBlocks.size();
    }

    public List<Block> getLeeveBlockScffolds() {
        double rightAngledAngle = 1.5707963267948966 + this.fissureAngle;
        int xRadiusOffset = (int)Math.cos(rightAngledAngle) * this.craterRadius;
        int zRadiusOffset = (int)Math.sin(rightAngledAngle) * this.craterRadius;
        ArrayList<Block> ventBlocksWithCrater = new ArrayList<Block>();
        Block fromBlock = this.location.getBlock().getRelative(xRadiusOffset, 0, zRadiusOffset);
        ventBlocksWithCrater.addAll(VolcanoMath.getLine(fromBlock, this.fissureAngle, this.fissureLength));
        fromBlock = this.location.getBlock().getRelative(-xRadiusOffset, 0, -zRadiusOffset);
        ventBlocksWithCrater.addAll(VolcanoMath.getLine(fromBlock, this.fissureAngle, this.fissureLength));
        return ventBlocksWithCrater;
    }

    public List<Block> getLeeveBlocks() {
        List<Block> target = this.leeveBlocks;
        if (target == null) {
            target = this.getLeeveBlockScffolds();
        }
        for (int i = 0; i < target.size(); ++i) {
            Block block = TyphonUtils.getHighestRocklikes(target.get(i));
            target.set(i, block);
        }
        this.leeveBlocks = target;
        return target;
    }

    public double averageLeeveHeight() {
        if (this.type == VolcanoVentType.FISSURE) {
            double total = 0.0;
            List<Block> leeveBlocks = this.getLeeveBlocks();
            for (Block block : leeveBlocks) {
                total += (double)block.getY();
            }
            return total / (double)leeveBlocks.size();
        }
        return this.averageVentHeight();
    }

    public Block lowestVentBlock() {
        int lowest = Integer.MAX_VALUE;
        Block lowestBlock = this.cachedVentBlocks.get(0);
        for (Block block : this.cachedVentBlocks) {
            int y = block.getY();
            if (y >= lowest) continue;
            lowestBlock = block;
        }
        return lowestBlock;
    }

    public int lowestVentHeight() {
        return this.lowestVentBlock().getY();
    }

    public Block selectFlowVentBlock() {
        return this.selectFlowVentBlock(true);
    }

    public List<Block> selectFlowVentBlocks(int count) {
        return this.selectFlowVentBlocks(true, count);
    }

    public Block selectCoreBlock() {
        Collections.shuffle(this.coreBlocks);
        Block block = this.coreBlocks.get(0);
        return block;
    }

    public Block selectCraterBlock() {
        double direction = Math.PI * Math.random() * 2.0;
        double length = Math.random() * (double)this.craterRadius;
        int xOffset = (int)(Math.sin(direction) * length);
        int zOffset = (int)(Math.cos(direction) * length);
        Block block = this.selectCoreBlock();
        Block target = block.getRelative(xOffset, 0, zOffset);
        return TyphonUtils.getHighestRocklikes(target);
    }

    public List<Block> selectFlowVentBlocks(boolean evenFlow, int count) {
        if (count <= 0) {
            return new ArrayList<Block>();
        }
        Random random = new Random();
        ArrayList<Block> selectedBlocks = new ArrayList<Block>();
        List<Block> ventBlocks = this.getVentBlocks();
        Collections.shuffle(ventBlocks);
        if (evenFlow) {
            Block lowestVent;
            boolean useLowest = false;
            useLowest = Math.random() < (this.lavaFlow.settings.silicateLevel - 0.22) * (1.0 + this.lavaFlow.settings.silicateLevel);
            double averageVentHeight = this.averageVentHeight();
            if (useLowest && (double)Math.round((lowestVent = this.lowestVentBlock()).getY()) < averageVentHeight) {
                ventBlocks.sort(Comparator.comparingInt(Block::getY));
                for (Block block : ventBlocks) {
                    if (!this.lavaFlow.isLavaOKForFlow(block) || selectedBlocks.contains(block)) continue;
                    Block blockTop = TyphonUtils.getHighestRocklikes(block);
                    selectedBlocks.add(blockTop);
                    if (selectedBlocks.size() != count) continue;
                    return selectedBlocks;
                }
            }
            Collections.shuffle(ventBlocks);
            int minimumTolerantHeight = this.type == VolcanoVentType.FISSURE ? (int)averageVentHeight - 3 : (int)averageVentHeight - this.craterRadius / 7;
            for (Block block : ventBlocks) {
                int y = block.getY();
                if (y >= minimumTolerantHeight || this.lavaFlow.isLavaOKForFlow(block) || Math.random() < (double)0.2f || selectedBlocks.contains(block)) continue;
                Block blockTop = TyphonUtils.getHighestRocklikes(block);
                selectedBlocks.add(blockTop);
                if (selectedBlocks.size() != count) continue;
                return selectedBlocks;
            }
        }
        for (int i = 0; i < count; ++i) {
            Block block = ventBlocks.get(random.nextInt(ventBlocks.size()));
            if (selectedBlocks.contains(block) || !this.lavaFlow.isLavaOKForFlow(block)) continue;
            Block blockTop = TyphonUtils.getHighestRocklikes(block);
            selectedBlocks.add(blockTop);
        }
        return selectedBlocks;
    }

    public Block selectFlowVentBlock(boolean evenFlow) {
        List<Block> targetBlocks = this.selectFlowVentBlocks(evenFlow, 1);
        if (targetBlocks.isEmpty()) {
            List<Block> ventBlocks = this.getVentBlocks();
            if (ventBlocks.isEmpty()) {
                return TyphonUtils.getHighestRocklikes(this.location.getBlock());
            }
            int randomIdx = (int)(Math.random() * (double)ventBlocks.size());
            return TyphonUtils.getHighestRocklikes(ventBlocks.get(randomIdx));
        }
        return targetBlocks.get((int)(Math.random() * (double)targetBlocks.size()));
    }

    public Block requestFlow() {
        Block ventBlock = this.selectFlowVentBlock().getRelative(BlockFace.UP);
        return ventBlock;
    }

    public List<Block> requestFlows(int count) {
        List<Block> ventBlocks = this.selectFlowVentBlocks(count);
        ArrayList<Block> lavaFlowBlocks = new ArrayList<Block>();
        for (Block ventBlock : ventBlocks) {
            Block flowTarget = ventBlock.getRelative(BlockFace.UP);
            if (this.lavaFlow.isLavaRegistered(flowTarget)) continue;
            lavaFlowBlocks.add(flowTarget);
        }
        return lavaFlowBlocks;
    }

    public boolean isBlockPotentialSummitUpdate(Block block) {
        Block coreBlock = this.getNearestCoreBlock(block.getLocation());
        return TyphonUtils.getTwoDimensionalDistance(coreBlock.getLocation(), block.getLocation()) < (double)this.craterRadius * 1.3;
    }

    public void flushSummitCache() {
        this.cachedSummitBlock = null;
    }

    public void flushSummitCacheByLocation(Block block) {
        if (this.isBlockPotentialSummitUpdate(block)) {
            this.flushSummitCache();
        }
    }

    public Block getSummitBlock() {
        if (this.cachedSummitBlock != null && this.cachedSummitBlockLastSync > System.currentTimeMillis() - 500L) {
            return this.cachedSummitBlock;
        }
        List<Block> cachedVentBlocks = this.getVentBlocks();
        if (this.type == VolcanoVentType.FISSURE) {
            cachedVentBlocks.addAll(this.getLeeveBlocks());
        }
        int highestY = 0;
        Block highestBlock = null;
        for (Block block : cachedVentBlocks) {
            if (block.getY() <= highestY && highestY != 0) continue;
            highestY = block.getY();
            highestBlock = block;
        }
        if (highestBlock == null) {
            highestBlock = cachedVentBlocks.get(0);
        }
        int seaLevel = highestBlock.getWorld().getSeaLevel();
        if (this.bombs.getBaseY() < seaLevel && highestBlock.getY() > seaLevel + 2) {
            this.bombs.baseY = seaLevel;
            this.volcano.trySave();
        }
        this.cachedSummitBlock = highestBlock;
        this.cachedSummitBlockLastSync = System.currentTimeMillis();
        return highestBlock;
    }

    public void cool() {
        List<Block> cachedVentBlocks = this.getVentBlocks();
        for (Block block : cachedVentBlocks) {
            if (this.erupt.getStyle().lavaMultiplier < 1.0) {
                TyphonBlocks.setBlockType(block, VolcanoComposition.getBombRock(this.lavaFlow.settings.silicateLevel, 0.0));
                continue;
            }
            TyphonBlocks.setBlockType(block, VolcanoComposition.getExtrusiveRock(this.lavaFlow.settings.silicateLevel));
        }
    }

    public boolean isInVent(Location loc) {
        return this.getTwoDimensionalDistance(loc) <= (double)this.craterRadius;
    }

    public boolean isInLavaFlow(Location loc) {
        return this.getTwoDimensionalDistance(loc) <= this.longestFlowLength;
    }

    public boolean isBombAffected(Location loc) {
        return this.getTwoDimensionalDistance(loc) <= this.bombs.maxDistance;
    }

    public List<Block> getCoreBlocks() {
        if (this.coreBlocks == null) {
            this.getVentBlocks();
        }
        return this.coreBlocks;
    }

    public Block getCoreBlock() {
        List<Block> coreBlocks = this.getCoreBlocks();
        int idx = (int)((double)coreBlocks.size() * Math.random());
        return coreBlocks.get(idx);
    }

    public Block getNearestCoreBlock(Location loc) {
        if (this.coreBlocks == null) {
            this.getVentBlocks();
        }
        double lowest = Double.POSITIVE_INFINITY;
        Iterator<Block> iterator = this.coreBlocks.iterator();
        Block nearestBlock = null;
        while (iterator.hasNext()) {
            Block block = iterator.next();
            double currentDistance = TyphonUtils.getTwoDimensionalDistance(block.getLocation(), loc);
            if (!(currentDistance < lowest)) continue;
            lowest = currentDistance;
            nearestBlock = block;
        }
        return nearestBlock;
    }

    public Block getNearestVentBlock(Location loc) {
        if (this.cachedVentBlocks == null) {
            this.getVentBlocks();
        }
        double lowest = Double.POSITIVE_INFINITY;
        Iterator<Block> iterator = this.cachedVentBlocks.iterator();
        Block nearestBlock = null;
        while (iterator.hasNext()) {
            Block block = iterator.next();
            double currentDistance = TyphonUtils.getTwoDimensionalDistance(block.getLocation(), loc);
            if (!(currentDistance < lowest)) continue;
            lowest = currentDistance;
            nearestBlock = block;
        }
        return nearestBlock;
    }

    public double getTwoDimensionalDistance(Location loc) {
        Block block = this.getNearestCoreBlock(loc);
        return TyphonUtils.getTwoDimensionalDistance(loc, block.getLocation());
    }

    public double getThreeDimensionalDistance(Location loc) {
        if (loc.getWorld() != this.location.getWorld()) {
            return Double.MAX_VALUE;
        }
        Block coreBlock = this.getNearestCoreBlock(loc);
        return Math.sqrt(Math.pow((double)coreBlock.getX() - loc.getX(), 2.0) + Math.pow((double)coreBlock.getZ() - loc.getZ(), 2.0) + Math.pow((double)coreBlock.getY() - loc.getY(), 2.0));
    }

    public void explode() {
        this.explosion.explode();
    }

    public void explode(int bombCount) {
        this.explosion.explode(bombCount);
    }

    public void teleport(Entity entity) {
        this.teleport(entity, true);
    }

    public void teleport(Entity entity, boolean unstuck) {
        Location location = this.location;
        if (unstuck) {
            location = TyphonUtils.getHighestLocation(location).add(0.0, 2.0, 0.0);
        }
        entity.teleport(location);
    }

    public boolean isStarted() {
        return this.isFlowingLava() || this.isExploding();
    }

    public boolean isFlowingLava() {
        return this.lavaFlow.settings.flowing;
    }

    public boolean isExploding() {
        return this.explosion.running;
    }

    public void start() {
        this.erupt.start();
        this.getVolcano().trySave(true);
    }

    public void stop() {
        this.erupt.stop();
        this.getVolcano().trySave(true);
    }

    public boolean isMainVent() {
        return this.name == null || this.name.equals("main");
    }

    public String getVentConfigFilename() {
        return this.name + ".json";
    }

    public boolean isKillSwitchActive() {
        return this.enableKillSwitch && this.killAt > 0L && this.killAt < System.currentTimeMillis();
    }

    public void importConfig(JSONObject configData) {
        this.enabled = (Boolean)configData.get("enabled");
        this.type = VolcanoVentType.fromString((String)configData.get("type"));
        this.status = VolcanoVentStatus.getStatus((String)configData.get("status"));
        this.location = TyphonUtils.deserializeLocationForJSON((JSONObject)configData.get("location"));
        this.craterRadius = (int)((Long)configData.get("craterRadius")).longValue();
        this.fissureAngle = (Double)configData.get("fissureAngle");
        this.fissureLength = (int)((Long)configData.get("fissureLength")).longValue();
        this.maxFissureLength = (int)((Long)configData.get("maxFissureLength")).longValue();
        this.bombs.importConfig((JSONObject)configData.get("bombs"));
        this.explosion.importConfig((JSONObject)configData.get("explosion"));
        this.lavaFlow.importConfig((JSONObject)configData.get("lavaFlow"));
        this.record.importConfig((JSONObject)configData.get("record"));
        this.erupt.importConfig((JSONObject)configData.get("erupt"));
        this.lavadome.importConfig((JSONObject)configData.get("lavaDome"));
        this.longestFlowLength = (Double)configData.get("longestFlowLength");
        this.longestNormalLavaFlowLength = (Double)configData.get("longestNormalLavaFlowLength");
        this.longestAshNormalFlowLength = configData.getOrDefault("longestAshNormalFlowLength", 0.0);
        this.genesis = VolcanoVentGenesis.getGenesisType((String)configData.get("genesis"));
        this.calderaRadius = configData.getOrDefault("calderaRadius", -1.0);
        this.autoStyleUpdate = configData.getOrDefault("autoStyleUpdate", true);
        this.enableSuccession = configData.getOrDefault("enableSuccession", true);
        this.successionProbability = configData.getOrDefault("successionProbability", 0.05);
        this.successionTreeProbability = configData.getOrDefault("successionTreeProbability", 0.05);
        this.fullPyroclasticFlowProbability = configData.getOrDefault("fullPyroclasticFlowProbability", 1.0E-4);
        JSONObject killSwitchConfig = configData.getOrDefault("killSwitch", new JSONObject());
        this.enableKillSwitch = killSwitchConfig.getOrDefault("enable", false);
        this.killAt = (Long)((Object)killSwitchConfig.getOrDefault("killAt", 0));
        this.postProcessImport();
    }

    public void postProcessImport() {
        if (this.isFlowingLava() || this.isExploding()) {
            this.erupt.start();
        }
    }

    public JSONObject exportConfig() {
        JSONObject configData = new JSONObject();
        configData.put("enabled", this.enabled);
        configData.put("type", this.type.toString());
        configData.put("location", TyphonUtils.serializeLocationForJSON(this.location));
        configData.put("status", this.status.toString());
        configData.put("longestFlowLength", this.longestFlowLength);
        configData.put("longestNormalLavaFlowLength", this.longestNormalLavaFlowLength);
        configData.put("longestAshNormalFlowLength", this.longestAshNormalFlowLength);
        configData.put("craterRadius", this.craterRadius);
        configData.put("fissureAngle", this.fissureAngle);
        configData.put("fissureLength", this.fissureLength);
        configData.put("maxFissureLength", this.maxFissureLength);
        configData.put("autoStyleUpdate", this.autoStyleUpdate);
        configData.put("enableSuccession", this.enableSuccession);
        configData.put("successionProbability", this.successionProbability);
        configData.put("successionTreeProbability", this.successionTreeProbability);
        configData.put("fullPyroclasticFlowProbability", this.fullPyroclasticFlowProbability);
        configData.put("genesis", this.genesis.getName());
        JSONObject bombConfig = this.bombs.exportConfig();
        configData.put("bombs", bombConfig);
        JSONObject explosionConfig = this.explosion.exportConfig();
        configData.put("explosion", explosionConfig);
        JSONObject eruptConfig = this.erupt.exportConfig();
        configData.put("erupt", eruptConfig);
        JSONObject lavaFlowConfig = this.lavaFlow.exportConfig();
        configData.put("lavaFlow", lavaFlowConfig);
        JSONObject lavadomeConfig = this.lavadome.exportConfig();
        configData.put("lavaDome", lavadomeConfig);
        JSONObject recordConfig = this.record.exportConfig();
        configData.put("record", recordConfig);
        configData.put("calderaRadius", this.calderaRadius);
        JSONObject killSwitchConfig = new JSONObject();
        killSwitchConfig.put("enable", this.enableKillSwitch);
        killSwitchConfig.put("killAt", this.killAt);
        configData.put("killSwitch", killSwitchConfig);
        return configData;
    }
}

