/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.vent;

public enum VolcanoVentStatus {
    EXTINCT("EXTINCT", 0.0, false),
    DORMANT("DORMANT", 0.09, false),
    MINOR_ACTIVITY("MINOR_ACTIVITY", 0.3, true),
    MAJOR_ACTIVITY("MAJOR_ACTIVITY", 0.7, true),
    ERUPTION_IMMINENT("ERUPTION_IMMINENT", 0.9, true),
    ERUPTING("ERUPTING", 1.0, true);

    String string;
    double scaleFactor;
    boolean elevated;

    private VolcanoVentStatus(String string2, double scaleFactor, boolean elevated) {
        this.string = string2;
        this.scaleFactor = scaleFactor;
        this.elevated = elevated;
    }

    public boolean hasElevatedActivity() {
        return this.elevated;
    }

    public String toString() {
        return this.string;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public double getThermalScaleFactor() {
        return Math.pow(this.scaleFactor, 1.5);
    }

    public static boolean isValidStatus(String string) {
        return VolcanoVentStatus.getStatus(string) != null;
    }

    public static VolcanoVentStatus getStatus(String string) {
        for (VolcanoVentStatus status : VolcanoVentStatus.values()) {
            if (!status.toString().equalsIgnoreCase(string)) continue;
            return status;
        }
        return null;
    }

    public boolean isActive() {
        return !this.equals((Object)EXTINCT);
    }

    public VolcanoVentStatus increase() {
        switch (this.ordinal()) {
            case 0: {
                return EXTINCT;
            }
            case 1: {
                return MINOR_ACTIVITY;
            }
            case 2: {
                return MAJOR_ACTIVITY;
            }
        }
        return ERUPTING;
    }

    public VolcanoVentStatus decrease() {
        switch (this.ordinal()) {
            case 0: {
                return EXTINCT;
            }
            case 1: 
            case 2: {
                return DORMANT;
            }
            case 3: {
                return MINOR_ACTIVITY;
            }
        }
        return MAJOR_ACTIVITY;
    }
}

