/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.vts.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import me.ramidzkh.vts.VillagerTradingStation;
import me.ramidzkh.vts.block.TradingStationBlockEntity;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TradeAtStation
extends Behavior<Villager> {
    private static final int CHECK_COOLDOWN = 20;
    private static final double DISTANCE = 1.73;
    private long lastCheck;
    private GlobalPos targetPos;

    public TradeAtStation() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)VillagerTradingStation.STATION_SITE.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Villager villager) {
        if (level.getGameTime() - this.lastCheck < 20L) {
            return false;
        }
        this.lastCheck = level.getGameTime();
        for (GlobalPos pos : villager.getBrain().getMemory((MemoryModuleType)VillagerTradingStation.STATION_SITE.get()).orElse(Collections.emptyList())) {
            TradingStationBlockEntity tradingStation;
            BlockEntity blockEntity;
            if (pos.dimension() != level.dimension() || !pos.pos().closerToCenterThan((Position)villager.position(), 1.73) || !((blockEntity = level.getBlockEntity(pos.pos())) instanceof TradingStationBlockEntity) || !(tradingStation = (TradingStationBlockEntity)blockEntity).canInteract((AbstractVillager)villager)) continue;
            this.targetPos = pos;
            return true;
        }
        return false;
    }

    protected void start(ServerLevel level, Villager villager, long time) {
        Brain brain = villager.getBrain();
        BlockEntity blockEntity = level.getBlockEntity(this.targetPos.pos());
        if (blockEntity instanceof TradingStationBlockEntity) {
            TradingStationBlockEntity tradingStation = (TradingStationBlockEntity)blockEntity;
            brain.setMemory(MemoryModuleType.LAST_WORKED_AT_POI, (Object)time);
            brain.setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(this.targetPos.pos()));
            tradingStation.interact((AbstractVillager)villager);
        }
    }

    protected boolean canStillUse(ServerLevel level, Villager villager, long time) {
        TradingStationBlockEntity tradingStation;
        BlockEntity blockEntity;
        Optional optional = villager.getBrain().getMemory(MemoryModuleType.JOB_SITE);
        if (optional.isEmpty()) {
            return false;
        }
        GlobalPos pos = (GlobalPos)optional.get();
        return pos.dimension() == level.dimension() && pos.pos().closerToCenterThan((Position)villager.position(), 1.73) && (blockEntity = level.getBlockEntity(pos.pos())) instanceof TradingStationBlockEntity && (tradingStation = (TradingStationBlockEntity)blockEntity).canInteract((AbstractVillager)villager);
    }
}

