/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.vts.ai;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Set;
import me.ramidzkh.vts.VillagerTradingStation;
import me.ramidzkh.vts.block.TradingStationBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TradingStationSensor
extends Sensor<Villager> {
    private static final int SCAN_RATE = 40;

    public TradingStationSensor() {
        super(40);
    }

    protected void doTick(ServerLevel serverLevel, Villager villager) {
        ResourceKey dimension = serverLevel.dimension();
        ArrayList<GlobalPos> list = new ArrayList<GlobalPos>();
        for (BlockPos pos : BlockPos.withinManhattan((BlockPos)villager.blockPosition(), (int)4, (int)2, (int)4)) {
            TradingStationBlockEntity tradingStation;
            BlockEntity blockEntity = serverLevel.getBlockEntity(pos);
            if (!(blockEntity instanceof TradingStationBlockEntity) || !(tradingStation = (TradingStationBlockEntity)blockEntity).canInteract((AbstractVillager)villager)) continue;
            list.add(GlobalPos.of((ResourceKey)dimension, (BlockPos)pos.immutable()));
        }
        Brain brain = villager.getBrain();
        if (!list.isEmpty()) {
            brain.setMemory((MemoryModuleType)VillagerTradingStation.STATION_SITE.get(), list);
        } else {
            brain.eraseMemory((MemoryModuleType)VillagerTradingStation.STATION_SITE.get());
        }
    }

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)((MemoryModuleType)VillagerTradingStation.STATION_SITE.get()));
    }
}

