/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.vts.block;

import me.ramidzkh.vts.VillagerTradingStation;
import me.ramidzkh.vts.block.TradeSelectionPayload;
import me.ramidzkh.vts.item.Quote;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MerchantScreenHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onInscribeQuote(TradeSelectionPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            AbstractContainerMenu patt0$temp = context.player().containerMenu;
            if (patt0$temp instanceof MerchantMenu) {
                MerchantMenu menu = (MerchantMenu)patt0$temp;
                if (!MerchantScreenHandler.inscribe(context.player(), payload.shopItem(), menu)) {
                    LOGGER.warn("Player {} sent a packet to inscribe a trade, but it could not be performed", (Object)context.player());
                }
            }
        });
    }

    public static boolean inscribe(Player player, int shopItem, MerchantMenu menu) {
        ItemStack cursor = menu.getCarried();
        if (cursor.is(VillagerTradingStation.QUOTE_CONVERTABLE)) {
            MerchantOffer offer = (MerchantOffer)menu.getOffers().get(shopItem);
            ItemStack quote = VillagerTradingStation.QUOTE_ITEM.toStack();
            quote.set(VillagerTradingStation.QUOTE, (Object)new Quote(offer.getItemCostA(), offer.getItemCostB(), offer.getResult()));
            if (!player.hasInfiniteMaterials()) {
                cursor.shrink(1);
            }
            if (cursor.isEmpty()) {
                menu.setCarried(quote);
            } else {
                player.getInventory().placeItemBackInInventory(quote);
            }
            return true;
        }
        return false;
    }
}

