/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.vts.block;

import com.mojang.math.OctahedralGroup;
import com.mojang.math.Quadrant;
import com.mojang.serialization.MapCodec;
import me.ramidzkh.vts.VillagerTradingStation;
import me.ramidzkh.vts.block.TradingStationBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TradingStationBlock
extends BaseEntityBlock {
    public static final MapCodec<TradingStationBlock> CODEC = TradingStationBlock.simpleCodec(TradingStationBlock::new);
    private static final VoxelShape[] SHAPES = new VoxelShape[3];

    public TradingStationBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_AXIS});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)blockPlaceContext.getHorizontalDirection().getAxis());
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPES[((Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)).ordinal()];
    }

    protected VoxelShape getOcclusionShape(BlockState blockState) {
        return Shapes.empty();
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(blockPos)) instanceof TradingStationBlockEntity) {
            TradingStationBlockEntity tradingStation = (TradingStationBlockEntity)blockEntity;
            player.openMenu((MenuProvider)tradingStation);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)VillagerTradingStation.TRADING_STATION_BLOCK_ENTITY.get()).create(blockPos, blockState);
    }

    static {
        VoxelShape voxelShape = Shapes.or((VoxelShape)Shapes.box((double)0.4375, (double)0.21875, (double)0.4375, (double)0.5625, (double)0.84375, (double)0.5625), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.9375), Shapes.box((double)0.421875, (double)0.9375, (double)0.21875, (double)0.578125, (double)1.0, (double)0.78125), Shapes.box((double)0.1875, (double)0.59375, (double)0.84375, (double)0.8125, (double)0.65625, (double)0.90625), Shapes.box((double)0.15625, (double)0.34375, (double)0.84375, (double)0.21875, (double)0.59375, (double)0.90625), Shapes.box((double)0.78125, (double)0.34375, (double)0.84375, (double)0.84375, (double)0.59375, (double)0.90625), Shapes.box((double)0.15625, (double)0.28125, (double)0.71875, (double)0.84375, (double)0.34375, (double)1.03125), Shapes.box((double)0.25, (double)0.0625, (double)0.25, (double)0.75, (double)0.125, (double)0.75), Shapes.box((double)0.1875, (double)0.59375, (double)0.09375, (double)0.8125, (double)0.65625, (double)0.15625), Shapes.box((double)0.15625, (double)0.34375, (double)0.09375, (double)0.21875, (double)0.59375, (double)0.15625), Shapes.box((double)0.78125, (double)0.34375, (double)0.09375, (double)0.84375, (double)0.59375, (double)0.15625), Shapes.box((double)0.15625, (double)0.28125, (double)-0.03125, (double)0.84375, (double)0.34375, (double)0.28125)});
        TradingStationBlock.SHAPES[Direction.Axis.X.ordinal()] = voxelShape;
        VoxelShape shape = voxelShape;
        TradingStationBlock.SHAPES[Direction.Axis.Z.ordinal()] = Shapes.rotate((VoxelShape)shape, (OctahedralGroup)OctahedralGroup.fromXYAngles((Quadrant)Quadrant.R0, (Quadrant)Quadrant.R90));
    }
}

