/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.vts.block;

import java.util.List;
import me.ramidzkh.vts.VillagerTradingStation;
import me.ramidzkh.vts.block.TradingStationMenu;
import me.ramidzkh.vts.item.Quote;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.CombinedResourceHandler;
import net.neoforged.neoforge.transfer.DelegatingResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public class TradingStationBlockEntity
extends BlockEntity
implements MenuProvider {
    private final SimpleContainer inputs = new SimpleContainer(9);
    private final SimpleContainer outputs = new SimpleContainer(9);
    private final SimpleContainer quotes = new SimpleContainer(3);
    private final ResourceHandler<ItemResource> inputStorage = VanillaContainerWrapper.of((Container)this.inputs);
    private final ResourceHandler<ItemResource> outputStorage = VanillaContainerWrapper.of((Container)this.outputs);
    private final ResourceHandler<ItemResource> exposed = new CombinedResourceHandler(List.of(new Limited<ItemResource>(this.inputStorage, true), new Limited<ItemResource>(this.outputStorage, false)));

    public TradingStationBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public ResourceHandler<ItemResource> getItemStorage(Direction side) {
        return this.exposed;
    }

    public void interact(AbstractVillager villager) {
        for (int i = 0; i < this.quotes.getContainerSize(); ++i) {
            Quote quote = (Quote)this.quotes.getItem(i).get(VillagerTradingStation.QUOTE);
            if (quote == null) continue;
            MerchantOffer myOffer = null;
            for (MerchantOffer offer : villager.getOffers()) {
                if (offer.isOutOfStock() || !quote.satisfiedBy(offer)) continue;
                myOffer = offer;
                break;
            }
            if (myOffer == null) continue;
            try (Transaction transaction = Transaction.openRoot();){
                ItemCost cost;
                if (this.inputStorage.extract((Resource)ItemResource.of((ItemStack)quote.a().itemStack()), quote.a().count(), (TransactionContext)transaction) != quote.a().count() || quote.b().isPresent() && this.inputStorage.extract((Resource)ItemResource.of((ItemStack)(cost = quote.b().get()).itemStack()), cost.count(), (TransactionContext)transaction) != cost.count() || this.outputStorage.insert((Resource)ItemResource.of((ItemStack)quote.result()), quote.result().getCount(), (TransactionContext)transaction) != quote.result().getCount()) continue;
                villager.notifyTrade(myOffer);
                transaction.commit();
                continue;
            }
        }
    }

    public boolean canInteract(AbstractVillager villager) {
        for (int i = 0; i < this.quotes.getContainerSize(); ++i) {
            Quote quote = (Quote)this.quotes.getItem(i).get(VillagerTradingStation.QUOTE);
            if (quote == null) continue;
            for (MerchantOffer offer : villager.getOffers()) {
                if (offer.isOutOfStock() || !quote.satisfiedBy(offer)) continue;
                return true;
            }
        }
        return false;
    }

    public void preRemoveSideEffects(BlockPos blockPos, BlockState blockState) {
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)blockPos, (Container)this.inputs);
            Containers.dropContents((Level)this.level, (BlockPos)blockPos, (Container)this.outputs);
            Containers.dropContents((Level)this.level, (BlockPos)blockPos, (Container)this.quotes);
        }
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        ContainerHelper.loadAllItems((ValueInput)input.childOrEmpty("Inputs"), (NonNullList)this.inputs.getItems());
        ContainerHelper.loadAllItems((ValueInput)input.childOrEmpty("Outputs"), (NonNullList)this.outputs.getItems());
        ContainerHelper.loadAllItems((ValueInput)input.childOrEmpty("Quotes"), (NonNullList)this.quotes.getItems());
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        ContainerHelper.saveAllItems((ValueOutput)output.child("Inputs"), (NonNullList)this.inputs.getItems());
        ContainerHelper.saveAllItems((ValueOutput)output.child("Outputs"), (NonNullList)this.outputs.getItems());
        ContainerHelper.saveAllItems((ValueOutput)output.child("Quotes"), (NonNullList)this.quotes.getItems());
    }

    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new TradingStationMenu(containerId, inventory, this, (Container)this.inputs, (Container)this.outputs, (Container)this.quotes);
    }

    private static class Limited<R extends Resource>
    extends DelegatingResourceHandler<R> {
        private final boolean insertOnly;

        public Limited(ResourceHandler<R> delegate, boolean insertOnly) {
            super(delegate);
            this.insertOnly = insertOnly;
        }

        public int insert(int index, R resource, int amount, TransactionContext transaction) {
            return this.insertOnly ? super.insert(index, resource, amount, transaction) : 0;
        }

        public int insert(R resource, int amount, TransactionContext transaction) {
            return this.insertOnly ? super.insert(resource, amount, transaction) : 0;
        }

        public int extract(int index, R resource, int amount, TransactionContext transaction) {
            return this.insertOnly ? 0 : super.extract(index, resource, amount, transaction);
        }

        public int extract(R resource, int amount, TransactionContext transaction) {
            return this.insertOnly ? 0 : super.extract(resource, amount, transaction);
        }
    }
}

