/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.vts.block;

import me.ramidzkh.vts.VillagerTradingStation;
import me.ramidzkh.vts.block.TradingStationBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TradingStationMenu
extends AbstractContainerMenu {
    private final TradingStationRecord record;

    public TradingStationMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, null, (Container)new SimpleContainer(9), (Container)new SimpleContainer(9), (Container)new SimpleContainer(3));
    }

    public TradingStationMenu(int containerId, Inventory inventory, @Nullable TradingStationBlockEntity tradingStation, Container inputs, Container outputs, Container quotes) {
        super((MenuType)VillagerTradingStation.TRADING_STATION_MENU.get(), containerId);
        int j;
        Level level;
        if (tradingStation != null && (level = tradingStation.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.record = new TradingStationRecord(serverLevel, tradingStation.getBlockPos(), tradingStation);
        } else {
            this.record = null;
        }
        for (j = 0; j < 3; ++j) {
            this.addSlot(new Slot(this, quotes, j, 8, 17 + j * 18){

                public boolean mayPlace(ItemStack itemStack) {
                    return itemStack.has(VillagerTradingStation.QUOTE);
                }
            });
        }
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 3; ++k) {
                this.addSlot(new Slot(inputs, k + j * 3, 44 + k * 18, 17 + j * 18));
            }
        }
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 3; ++k) {
                this.addSlot(new Slot(this, outputs, k + j * 3, 116 + k * 18, 17 + j * 18){

                    public boolean mayPlace(ItemStack itemStack) {
                        return false;
                    }
                });
            }
        }
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)inventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)inventory, j, 8 + j * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot != null && slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < 21 ? !this.moveItemStackTo(originalStack, 21, this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, 21, false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (originalStack.getCount() == newStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, originalStack);
        }
        return newStack;
    }

    public boolean stillValid(Player player) {
        if (this.record == null) {
            return true;
        }
        BlockPos pos = this.record.pos;
        if (this.record.level.getBlockEntity(pos) != this.record.tradingStation) {
            return false;
        }
        return !(player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) > 64.0);
    }

    private record TradingStationRecord(ServerLevel level, BlockPos pos, TradingStationBlockEntity tradingStation) {
    }
}

