/*
 * Decompiled with CFR 0.152.
 */
package redart15.goldenbat.items.tools;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.item.tool.ItemToolSword;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import org.apache.commons.lang3.tuple.Pair;
import redart15.goldenbat.items.tools.MobUtil;
import redart15.goldenbat.items.tools.Smashables;

public class ItemBat
extends ItemToolSword {
    public final double highStrength;
    public final double highLift;
    public final double longStrength;
    public final double longlift;

    public ItemBat(String name, String namespaceId, int id, ToolMaterial material, double maxValue) {
        super(name, namespaceId, id, material);
        maxValue = Math.abs(maxValue);
        this.highStrength = 0.2 * maxValue;
        this.highLift = 0.4 * maxValue;
        this.longStrength = 0.6 * maxValue;
        this.longlift = 0.2 * maxValue;
    }

    public float getStrVsBlock(ItemStack itemstack, Block<?> block) {
        if (block == null) {
            return 1.5f;
        }
        return Smashables.instance.isSmashable(block.id()) ? 30.0f : 1.5f;
    }

    public void onUseByActivator(ItemStack itemStack, TileEntityActivator activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        Block block = world.getBlock(blockX += direction.getOffsetX(), blockY += direction.getOffsetY(), blockZ += direction.getOffsetZ());
        if (block != null && Smashables.instance.isSmashable(block.id())) {
            int metadata = world.getBlockMetadata(blockX, blockY, blockZ);
            world.setBlockWithNotify(blockX, blockY, blockZ, 0);
            world.playBlockSoundEffect(null, (double)blockX, (double)blockY, (double)blockZ, block, EnumBlockSoundEffectType.MINE);
            ItemStack[] dropItems = block.getBreakResult(world, EnumDropCause.PROPER_TOOL, metadata, null);
            if (dropItems == null) {
                return;
            }
            Pair<NamespaceID, Integer> result = Smashables.instance.getEntry(block.id());
            if (result.getLeft() == null) {
                return;
            }
            Item toGive = (Item)Item.itemsMap.get(result.getLeft());
            int stacksize = 0;
            for (ItemStack dropItem : dropItems) {
                stacksize += dropItem.stackSize;
            }
            stacksize = stacksize == 0 ? 1 : stacksize;
            world.dropItem(blockX, blockY, blockZ, new ItemStack(toGive, stacksize, ((Integer)result.getRight()).intValue()));
            itemStack.damageItem(1, null);
        }
    }

    public boolean hitEntity(ItemStack itemstack, Mob target, Mob attacker) {
        if (attacker.isSneaking() && attacker instanceof Player) {
            MobUtil.knockback((Entity)target, (Entity)attacker, this.highStrength, this.highLift);
        } else {
            MobUtil.knockback((Entity)target, (Entity)attacker, this.longStrength, this.longlift);
        }
        return super.hitEntity(itemstack, target, attacker);
    }
}

