/*
 * Decompiled with CFR 0.152.
 */
package redart15.goldenbat.mixin;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import redart15.goldenbat.items.tools.ItemBat;
import redart15.goldenbat.items.tools.ItemGoldenBat;

@Mixin(value={Mob.class}, remap=false)
public abstract class KnockBackMixin
extends Entity {
    public KnockBackMixin(@Nullable World world) {
        super(world);
    }

    @Inject(method={"knockBack(Lnet/minecraft/core/entity/Entity;IDD)V"}, at={@At(value="TAIL")})
    private void additionalKnockback(Entity attacker, int damage, double diff_x, double diff_z, CallbackInfo ci) {
        if (attacker instanceof Player) {
            ItemStack heldStack = ((Player)attacker).getHeldItem();
            if (heldStack == null) {
                return;
            }
            Item bat = heldStack.getItem();
            if (!(bat instanceof ItemBat)) {
                return;
            }
            float knockBackStrength = 0.4f;
            float lift = 0.4f;
            if (bat instanceof ItemGoldenBat) {
                if (attacker.isSneaking()) {
                    lift = 1.9f;
                    knockBackStrength = 0.8f;
                } else {
                    knockBackStrength = 2.6f;
                    lift = 1.0f;
                }
            }
            float horizonalDistance = MathHelper.sqrt((double)(diff_x * diff_x + diff_z * diff_z));
            this.xd /= 2.0;
            this.yd /= 2.0;
            this.zd /= 2.0;
            this.xd -= diff_x / (double)horizonalDistance * (double)knockBackStrength;
            this.yd += (double)lift;
            this.zd -= diff_z / (double)horizonalDistance * (double)knockBackStrength;
        }
    }
}

