/*
 * Decompiled with CFR 0.152.
 */
package net.bloople.allblockvariants;

import java.io.OutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\u0006J\u0017\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0006J'\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lnet/bloople/allblockvariants/UnsafeByteArrayOutputStream;", "Ljava/io/OutputStream;", "Ljava/lang/AutoCloseable;", "", "size", "<init>", "(I)V", "b", "", "write", "minCapacity", "ensureCapacity", "", "off", "len", "([BII)V", "buf", "[B", "index", "I", "getBytes", "()[B", "bytes", "allblockvariants"})
@SourceDebugExtension(value={"SMAP\nUnsafeByteArrayOutputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeByteArrayOutputStream.kt\nnet/bloople/allblockvariants/UnsafeByteArrayOutputStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
public final class UnsafeByteArrayOutputStream
extends OutputStream
implements AutoCloseable {
    @NotNull
    private byte[] buf;
    private int index;

    @JvmOverloads
    public UnsafeByteArrayOutputStream(int size) {
        if (!(size >= 0)) {
            boolean bl = false;
            String string = "Negative initial size: " + size;
            throw new IllegalArgumentException(string.toString());
        }
        this.buf = new byte[size];
    }

    public /* synthetic */ UnsafeByteArrayOutputStream(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 128;
        }
        this(n);
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.index + 1);
        int n = this.index;
        this.index = n + 1;
        this.buf[n] = (byte)b;
    }

    private final void ensureCapacity(int minCapacity) {
        int len = this.buf.length;
        if (minCapacity > len) {
            int size = Math.max(minCapacity, len / 2 + len);
            byte[] byArray = Arrays.copyOf(this.buf, size);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            this.buf = byArray;
        }
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.index + len);
        System.arraycopy(b, off, this.buf, this.index, len);
        this.index += len;
    }

    @NotNull
    public final byte[] getBytes() {
        byte[] byArray = Arrays.copyOf(this.buf, this.index);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }

    @JvmOverloads
    public UnsafeByteArrayOutputStream() {
        this(0, 1, null);
    }
}

