/*
 * Decompiled with CFR 0.152.
 */
package me.easynicetab;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EasyNiceTab
extends JavaPlugin {
    private String header;
    private String footerLeft;
    private String footerRight;
    private int updateInterval;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.startTabUpdater();
        this.getCommand("tabreload").setExecutor((commandSender, command, string, stringArray) -> {
            this.reloadConfig();
            this.loadConfig();
            commandSender.sendMessage(String.valueOf(ChatColor.GREEN) + "EasyNiceTab config reloaded!");
            return true;
        });
    }

    private void loadConfig() {
        this.header = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("header", ""));
        this.footerLeft = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("footer-left", ""));
        this.footerRight = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("footer-right", ""));
        this.updateInterval = this.getConfig().getInt("update-interval", 5);
    }

    private void startTabUpdater() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    String string = EasyNiceTab.this.replacePlaceholders(EasyNiceTab.this.header, player);
                    String string2 = EasyNiceTab.this.replacePlaceholders(EasyNiceTab.this.footerLeft + "     " + EasyNiceTab.this.footerRight, player);
                    player.setPlayerListHeaderFooter(string, string2);
                }
            }
        }.runTaskTimer((Plugin)this, 0L, (long)this.updateInterval * 20L);
    }

    private String replacePlaceholders(String string, Player player) {
        return string.replace("(ping)", String.valueOf(player.getPing())).replace("(ple)", String.valueOf(Bukkit.getOnlinePlayers().size())).replace("(name)", player.getName()).replace("(world)", player.getWorld().getName());
    }
}

