/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theroswildsrecoded.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelPuffin<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"theros_wilds_recoded", (String)"model_puffin"), "main");
    public final ModelPart Body;
    public final ModelPart Neck;
    public final ModelPart Head;
    public final ModelPart left_wing;
    public final ModelPart right_wing;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public ModelPuffin(ModelPart root) {
        this.Body = root.getChild("Body");
        this.Neck = this.Body.getChild("Neck");
        this.Head = this.Neck.getChild("Head");
        this.left_wing = this.Body.getChild("left_wing");
        this.right_wing = this.Body.getChild("right_wing");
        this.left_leg = this.Body.getChild("left_leg");
        this.right_leg = this.Body.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 12).addBox(-3.0f, -3.7143f, -3.4286f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 24).addBox(-2.0f, -1.7143f, 2.5714f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.7143f, (float)0.4286f));
        PartDefinition Neck = Body.addOrReplaceChild("Neck", CubeListBuilder.create().texOffs(24, 4).addBox(-1.0f, -4.0f, -3.0f, 2.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.7143f, (float)-2.4286f));
        PartDefinition Head = Neck.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -6.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)-1.0f));
        PartDefinition left_wing = Body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(24, 0).addBox(0.0f, 0.0f, -1.0f, 7.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-1.7143f, (float)-0.4286f));
        PartDefinition right_wing = Body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(24, 0).mirror().addBox(-7.0f, 0.0f, -1.0f, 7.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)-1.7143f, (float)-0.4286f));
        PartDefinition left_leg = Body.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 24).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(24, 14).addBox(-2.0f, 3.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)2.2857f, (float)-0.4286f));
        PartDefinition right_leg = Body.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(16, 24).mirror().addBox(0.0f, 0.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(24, 14).mirror().addBox(-1.0f, 3.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)2.2857f, (float)-0.4286f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
    }
}

