/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theroswildsrecoded.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.theroswildsrecoded.client.model.ModelGiant_Isopod;
import net.mcreator.theroswildsrecoded.client.model.animations.Giant_IsopodAnimation;
import net.mcreator.theroswildsrecoded.client.model.animations.african_penguinAnimation;
import net.mcreator.theroswildsrecoded.entity.GiantIsopodEntity;
import net.mcreator.theroswildsrecoded.procedures.DustySkinDisplayConditionProcedure;
import net.mcreator.theroswildsrecoded.procedures.FiddlerCrabModelVisualScaleProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class GiantIsopodRenderer
extends MobRenderer<GiantIsopodEntity, ModelGiant_Isopod<GiantIsopodEntity>> {
    public GiantIsopodRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelGiant_Isopod.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<GiantIsopodEntity, ModelGiant_Isopod<GiantIsopodEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"theros_wilds_recoded:textures/entities/dusty_isopod.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, GiantIsopodEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (DustySkinDisplayConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelGiant_Isopod)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(GiantIsopodEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)FiddlerCrabModelVisualScaleProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(GiantIsopodEntity entity) {
        return ResourceLocation.parse((String)"theros_wilds_recoded:textures/entities/default_isopod.png");
    }

    private static final class AnimatedModel
    extends ModelGiant_Isopod<GiantIsopodEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<GiantIsopodEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(GiantIsopodEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, Giant_IsopodAnimation.Idle, ageInTicks, 1.0f);
                this.animateWalk(african_penguinAnimation.Idle, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                this.animate(entity.animationState2, Giant_IsopodAnimation.Swim, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(GiantIsopodEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

