/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theroswildsrecoded.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.theroswildsrecoded.client.model.ModelPuffin;
import net.mcreator.theroswildsrecoded.client.model.animations.PuffinAnimation;
import net.mcreator.theroswildsrecoded.entity.PuffinEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class PuffinRenderer
extends MobRenderer<PuffinEntity, ModelPuffin<PuffinEntity>> {
    public PuffinRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelPuffin.LAYER_LOCATION)), 0.3f);
    }

    protected void scale(PuffinEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(PuffinEntity entity) {
        return ResourceLocation.parse((String)"theros_wilds_recoded:textures/entities/puffin.png");
    }

    private static final class AnimatedModel
    extends ModelPuffin<PuffinEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<PuffinEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(PuffinEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, PuffinAnimation.Idle, ageInTicks, 1.0f);
                this.animate(entity.animationState1, PuffinAnimation.Fly, ageInTicks, 1.0f);
                this.animateWalk(PuffinAnimation.Walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(PuffinEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

