/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theroswildsrecoded.client.renderer;

import net.mcreator.theroswildsrecoded.client.model.ModelRanchu;
import net.mcreator.theroswildsrecoded.client.model.animations.RanchuAnimation;
import net.mcreator.theroswildsrecoded.entity.RanchuEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class RanchuRenderer
extends MobRenderer<RanchuEntity, ModelRanchu<RanchuEntity>> {
    public RanchuRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelRanchu.LAYER_LOCATION)), 0.3f);
    }

    public ResourceLocation getTextureLocation(RanchuEntity entity) {
        return ResourceLocation.parse((String)"theros_wilds_recoded:textures/entities/ranchu.png");
    }

    private static final class AnimatedModel
    extends ModelRanchu<RanchuEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<RanchuEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(RanchuEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, RanchuAnimation.Swim, ageInTicks, 1.0f);
                this.animate(entity.animationState1, RanchuAnimation.Flop, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(RanchuEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

