/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theroswildsrecoded.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.theroswildsrecoded.client.model.Modelsalamander;
import net.mcreator.theroswildsrecoded.client.model.animations.salamanderAnimation;
import net.mcreator.theroswildsrecoded.entity.SalamanderEntity;
import net.mcreator.theroswildsrecoded.procedures.FiddlerCrabModelVisualScaleProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class SalamanderRenderer
extends MobRenderer<SalamanderEntity, Modelsalamander<SalamanderEntity>> {
    public SalamanderRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelsalamander.LAYER_LOCATION)), 0.5f);
    }

    protected void scale(SalamanderEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)FiddlerCrabModelVisualScaleProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(SalamanderEntity entity) {
        return ResourceLocation.parse((String)"theros_wilds_recoded:textures/entities/salamander.png");
    }

    private static final class AnimatedModel
    extends Modelsalamander<SalamanderEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<SalamanderEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(SalamanderEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, salamanderAnimation.idle, ageInTicks, 1.0f);
                this.animateWalk(salamanderAnimation.Walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                this.animate(entity.animationState2, salamanderAnimation.Swim, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(SalamanderEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

