/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theroswildsrecoded.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.theroswildsrecoded.client.model.Modelspoonbill;
import net.mcreator.theroswildsrecoded.client.model.animations.spoonbillAnimation;
import net.mcreator.theroswildsrecoded.entity.SpoonbillEntity;
import net.mcreator.theroswildsrecoded.procedures.FiddlerCrabModelVisualScaleProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class SpoonbillRenderer
extends MobRenderer<SpoonbillEntity, Modelspoonbill<SpoonbillEntity>> {
    public SpoonbillRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelspoonbill.LAYER_LOCATION)), 0.5f);
    }

    protected void scale(SpoonbillEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)FiddlerCrabModelVisualScaleProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(SpoonbillEntity entity) {
        return ResourceLocation.parse((String)"theros_wilds_recoded:textures/entities/spoonbill.png");
    }

    private static final class AnimatedModel
    extends Modelspoonbill<SpoonbillEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<SpoonbillEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(SpoonbillEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, spoonbillAnimation.Idle, ageInTicks, 1.0f);
                this.animateWalk(spoonbillAnimation.Walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                this.animate(entity.animationState2, spoonbillAnimation.Fly, ageInTicks, 1.0f);
                this.animate(entity.animationState3, spoonbillAnimation.Attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(SpoonbillEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

