/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theroswildsrecoded.entity;

import net.mcreator.theroswildsrecoded.init.TherosWildsRecodedModEntities;
import net.mcreator.theroswildsrecoded.procedures.BeachedPlaybackConditionProcedure;
import net.mcreator.theroswildsrecoded.procedures.MobulaRayNaturalEntitySpawningConditionProcedure;
import net.mcreator.theroswildsrecoded.procedures.MobulaRayOnEntityTickUpdateProcedure;
import net.mcreator.theroswildsrecoded.procedures.SwimmingPlaybackConditionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class MobulaRayEntity
extends PathfinderMob {
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();

    public MobulaRayEntity(EntityType<MobulaRayEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (MobulaRayEntity.this.isInWater()) {
                    MobulaRayEntity.this.setDeltaMovement(MobulaRayEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !MobulaRayEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - MobulaRayEntity.this.getX();
                    double dy = this.wantedY - MobulaRayEntity.this.getY();
                    double dz = this.wantedZ - MobulaRayEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * MobulaRayEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    MobulaRayEntity.this.setYRot(this.rotlerp(MobulaRayEntity.this.getYRot(), f, 10.0f));
                    MobulaRayEntity.this.yBodyRot = MobulaRayEntity.this.getYRot();
                    MobulaRayEntity.this.yHeadRot = MobulaRayEntity.this.getYRot();
                    if (MobulaRayEntity.this.isInWater()) {
                        MobulaRayEntity.this.setSpeed((float)MobulaRayEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        MobulaRayEntity.this.setXRot(this.rotlerp(MobulaRayEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(MobulaRayEntity.this.getXRot() * ((float)Math.PI / 180)));
                        MobulaRayEntity.this.setZza(f3 * f1);
                        MobulaRayEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        MobulaRayEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    MobulaRayEntity.this.setSpeed(0.0f);
                    MobulaRayEntity.this.setYya(0.0f);
                    MobulaRayEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.5, 40));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.1));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(SwimmingPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(BeachedPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        MobulaRayOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), (Entity)this);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        MobulaRayEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        MobulaRayEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)TherosWildsRecodedModEntities.MOBULA_RAY.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return MobulaRayNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 1.5);
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 1.5);
        return builder;
    }
}

