/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theroswilds.client.renderer;

import net.mcreator.theroswilds.client.model.Modelsalamander;
import net.mcreator.theroswilds.client.model.animations.salamanderAnimation;
import net.mcreator.theroswilds.entity.SalamanderEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class SalamanderRenderer
extends MobRenderer<SalamanderEntity, Modelsalamander<SalamanderEntity>> {
    public SalamanderRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelsalamander.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(SalamanderEntity entity) {
        return ResourceLocation.parse((String)("theros_wilds:textures/entities/" + entity.getTexture() + ".png"));
    }

    private static final class AnimatedModel
    extends Modelsalamander<SalamanderEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<SalamanderEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(SalamanderEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, salamanderAnimation.idle, ageInTicks, 1.0f);
                this.animateWalk(salamanderAnimation.Walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                this.animate(entity.animationState2, salamanderAnimation.Swim, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(SalamanderEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

