/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theroswilds.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class Modelsalamander<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"theros_wilds", (String)"modelsalamander"), "main");
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart tail;
    public final ModelPart left_arm;
    public final ModelPart right_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public Modelsalamander(ModelPart root) {
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.tail = this.body.getChild("tail");
        this.left_arm = this.body.getChild("left_arm");
        this.right_arm = this.body.getChild("right_arm");
        this.left_leg = this.body.getChild("left_leg");
        this.right_leg = this.body.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -2.0f, -7.5f, 6.0f, 4.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.0f, (float)-0.5f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(28, 19).addBox(-2.0f, -2.0f, -8.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-7.5f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 19).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)7.5f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(28, 31).addBox(0.0f, 0.0f, -1.5f, 6.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)2.0f, (float)-5.0f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(28, 31).mirror().addBox(-6.0f, 0.0f, -1.5f, 6.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)2.0f, (float)-5.0f));
        PartDefinition left_leg = body.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(28, 31).addBox(0.0f, 0.0f, -1.5f, 6.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)2.0f, (float)5.0f));
        PartDefinition right_leg = body.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(28, 31).mirror().addBox(-6.0f, 0.0f, -1.5f, 6.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)2.0f, (float)5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
    }
}

