/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theroswilds.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.theroswilds.client.model.ModelAnglerfish;
import net.mcreator.theroswilds.client.model.animations.AnglerfishAnimation;
import net.mcreator.theroswilds.entity.AnglerfishEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class AnglerfishRenderer
extends MobRenderer<AnglerfishEntity, ModelAnglerfish<AnglerfishEntity>> {
    public AnglerfishRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelAnglerfish.LAYER_LOCATION)), 0.4f);
        this.addLayer((RenderLayer)new RenderLayer<AnglerfishEntity, ModelAnglerfish<AnglerfishEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"theros_wilds:textures/entities/anglerfishglow.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, AnglerfishEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ((ModelAnglerfish)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
            }
        });
    }

    public ResourceLocation getTextureLocation(AnglerfishEntity entity) {
        return ResourceLocation.parse((String)"theros_wilds:textures/entities/anglerfish.png");
    }

    private static final class AnimatedModel
    extends ModelAnglerfish<AnglerfishEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<AnglerfishEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(AnglerfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, AnglerfishAnimation.Swim, ageInTicks, 1.0f);
                this.animate(entity.animationState1, AnglerfishAnimation.Attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(AnglerfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

