/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theroswilds.client.renderer;

import net.mcreator.theroswilds.client.model.ModelMudskipper;
import net.mcreator.theroswilds.client.model.animations.MudskipperAnimation;
import net.mcreator.theroswilds.entity.MudskipperEntity;
import net.mcreator.theroswilds.procedures.MudskipperIsEntityModelShakingProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class MudskipperRenderer
extends MobRenderer<MudskipperEntity, ModelMudskipper<MudskipperEntity>> {
    public MudskipperRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelMudskipper.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(MudskipperEntity entity) {
        return ResourceLocation.parse((String)"theros_wilds:textures/entities/mudskipper.png");
    }

    protected boolean isShaking(MudskipperEntity entity) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        return MudskipperIsEntityModelShakingProcedure.execute((LevelAccessor)world, x, y, z);
    }

    private static final class AnimatedModel
    extends ModelMudskipper<MudskipperEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<MudskipperEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(MudskipperEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, MudskipperAnimation.Idle, ageInTicks, 1.0f);
                this.animateWalk(MudskipperAnimation.Walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                this.animate(entity.animationState2, MudskipperAnimation.swim, ageInTicks, 1.0f);
                this.animate(entity.animationState3, MudskipperAnimation.AgroIdle, ageInTicks, 1.0f);
                this.animate(entity.animationState4, MudskipperAnimation.Attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(MudskipperEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

