/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theroswilds.client.renderer;

import net.mcreator.theroswilds.client.model.ModelOctopus;
import net.mcreator.theroswilds.client.model.animations.OctopusAnimation;
import net.mcreator.theroswilds.entity.OctopusEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class OctopusRenderer
extends MobRenderer<OctopusEntity, ModelOctopus<OctopusEntity>> {
    public OctopusRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelOctopus.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(OctopusEntity entity) {
        return ResourceLocation.parse((String)"theros_wilds:textures/entities/octopus.png");
    }

    private static final class AnimatedModel
    extends ModelOctopus<OctopusEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<OctopusEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(OctopusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, OctopusAnimation.IdleLand, ageInTicks, 1.0f);
                this.animateWalk(OctopusAnimation.idleWalk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                this.animate(entity.animationState2, OctopusAnimation.Swim, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(OctopusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

