/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theroswilds.client.renderer;

import net.mcreator.theroswilds.client.model.ModelSunfish;
import net.mcreator.theroswilds.client.model.animations.SunfishAnimation;
import net.mcreator.theroswilds.entity.SunfishEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class SunfishRenderer
extends MobRenderer<SunfishEntity, ModelSunfish<SunfishEntity>> {
    public SunfishRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelSunfish.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(SunfishEntity entity) {
        return ResourceLocation.parse((String)"theros_wilds:textures/entities/sunfish.png");
    }

    private static final class AnimatedModel
    extends ModelSunfish<SunfishEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<SunfishEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(SunfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, SunfishAnimation.Idle, ageInTicks, 1.0f);
                this.animate(entity.animationState1, SunfishAnimation.Swim, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(SunfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

