/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theroswilds.entity;

import java.util.function.Predicate;
import net.mcreator.theroswilds.init.TherosWildsModEntities;
import net.mcreator.theroswilds.procedures.HermitcrabRightClickedOnEntityProcedure;
import net.mcreator.theroswilds.procedures.IdleAnimConditionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class HermitcrabEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Boolean> DATA_Hiding = SynchedEntityData.defineId(HermitcrabEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_Sitting = SynchedEntityData.defineId(HermitcrabEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();

    public HermitcrabEntity(EntityType<HermitcrabEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_Hiding, (Object)false);
        builder.define(DATA_Sitting, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.COD}), false));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.SALMON}), false));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SEAGRASS.asItem()}), false));
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.KELP.asItem()}), false));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DataHiding", ((Boolean)this.entityData.get(DATA_Hiding)).booleanValue());
        compound.putBoolean("DataSitting", ((Boolean)this.entityData.get(DATA_Sitting)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataHiding")) {
            this.entityData.set(DATA_Hiding, (Object)compound.getBoolean("DataHiding"));
        }
        if (compound.contains("DataSitting")) {
            this.entityData.set(DATA_Sitting, (Object)compound.getBoolean("DataSitting"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        HermitcrabEntity entity = this;
        Level world = this.level();
        HermitcrabRightClickedOnEntityProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(IdleAnimConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(true, this.tickCount);
        }
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        HermitcrabEntity retval = (HermitcrabEntity)((EntityType)TherosWildsModEntities.HERMITCRAB.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.COD), new ItemStack((ItemLike)Items.SALMON), new ItemStack((ItemLike)Blocks.SEAGRASS), new ItemStack((ItemLike)Blocks.KELP)}).test(stack);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        HermitcrabEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)TherosWildsModEntities.HERMITCRAB.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && world.getRawBrightness(pos, 0) > 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 5.0);
        builder = builder.add(Attributes.ARMOR, 1.5);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

