/*
 * Decompiled with CFR 0.152.
 */
package express.filter;

import com.sun.net.httpserver.HttpExchange;
import express.Express;
import express.ExpressException;
import express.filter.FilterLayer;
import express.http.HttpRequestHandler;
import express.http.request.Request;
import express.http.response.Response;
import java.util.function.Consumer;

public class FilterLayerHandler {
    private final FilterLayer[] layers;

    public FilterLayerHandler(int layers) {
        this.layers = new FilterLayer[layers];
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new FilterLayer();
        }
    }

    public void handle(HttpExchange httpExchange, Express express) {
        Request request = new Request(httpExchange, express);
        Response response = new Response(httpExchange);
        for (FilterLayer chain : this.layers) {
            chain.filter(request, response);
            if (!response.isClosed()) continue;
            return;
        }
    }

    public void add(int level, HttpRequestHandler handler) {
        if (level >= this.layers.length) {
            throw new IndexOutOfBoundsException("Out of bounds: " + level + " > " + this.layers.length);
        }
        if (level < 0) {
            throw new IndexOutOfBoundsException("Cannot be under zero: " + level + " < 0");
        }
        this.layers[level].add(handler);
    }

    public void combine(FilterLayerHandler filterLayerHandler) {
        if (filterLayerHandler != null) {
            FilterLayer[] chains = filterLayerHandler.getLayers();
            if (chains.length != this.layers.length) {
                throw new ExpressException("Cannot add an filterLayerHandler with different layers sizes: " + chains.length + " != " + this.layers.length);
            }
            for (int i = 0; i < chains.length; ++i) {
                this.layers[i].addAll(chains[i].getFilter());
            }
        }
    }

    public void forEach(Consumer<FilterLayer> layerConsumer) {
        if (layerConsumer == null) {
            return;
        }
        for (FilterLayer layer : this.layers) {
            layerConsumer.accept(layer);
        }
    }

    private FilterLayer[] getLayers() {
        return this.layers;
    }
}

