/*
 * Decompiled with CFR 0.152.
 */
package express.http.response;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import express.http.Cookie;
import express.utils.MediaType;
import express.utils.Status;
import express.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Response {
    private final HttpExchange httpExchange;
    private final OutputStream body;
    private final Headers headers;
    private final Logger logger;
    private String contentType = MediaType._txt.getMIME();
    private boolean isClose = false;
    private long contentLength = 0L;
    private int status = 200;

    public Response(HttpExchange exchange) {
        this.logger = Logger.getLogger(this.getClass().getSimpleName());
        this.logger.setUseParentHandlers(false);
        this.httpExchange = exchange;
        this.headers = exchange.getResponseHeaders();
        this.body = exchange.getResponseBody();
    }

    public Response setHeader(String key, String value) {
        this.headers.add(key, value);
        return this;
    }

    public List<String> getHeader(String key) {
        return this.headers.get(key);
    }

    public void redirect(String location) {
        this.headers.add("Location", location);
        this.setStatus(Status._302);
        this.send();
    }

    public Response setCookie(Cookie cookie) {
        if (this.isClosed()) {
            return this;
        }
        this.headers.add("Set-Cookie", cookie.toString());
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public Response setStatus(Status status) {
        if (this.isClosed()) {
            return this;
        }
        this.status = status.getCode();
        return this;
    }

    public void sendStatus(Status status) {
        if (this.isClosed()) {
            return;
        }
        this.status = status.getCode();
        this.send();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(MediaType contentType) {
        this.contentType = contentType.getMIME();
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void send() {
        if (this.isClosed()) {
            return;
        }
        this.contentLength = 0L;
        this.sendHeaders();
        this.close();
    }

    public void send(String s) {
        if (s == null) {
            this.send();
            return;
        }
        if (this.isClosed()) {
            return;
        }
        byte[] data = s.getBytes();
        this.contentLength = data.length;
        this.sendHeaders();
        try {
            this.body.write(s.getBytes());
        }
        catch (IOException e) {
            this.logger.log(Level.INFO, "Failed to write charsequence to client.", e);
        }
        this.close();
    }

    public boolean sendAttachment(Path file) {
        if (this.isClosed() || !Files.isRegularFile(file, new LinkOption[0])) {
            return false;
        }
        String dispo = "attachment; filename=\"" + file.getFileName() + "\"";
        this.setHeader("Content-Disposition", dispo);
        return this.send(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Path file) {
        if (this.isClosed() || !Files.isRegularFile(file, new LinkOption[0])) {
            return false;
        }
        try {
            int n;
            this.contentLength = Files.size(file);
            MediaType mediaType = Utils.getContentType(file);
            this.contentType = mediaType == null ? null : mediaType.getMIME();
            this.sendHeaders();
            InputStream fis = Files.newInputStream(file, StandardOpenOption.READ);
            byte[] buffer = new byte[1024];
            while ((n = fis.read(buffer)) != -1) {
                this.body.write(buffer, 0, n);
            }
            fis.close();
        }
        catch (IOException e) {
            this.logger.log(Level.INFO, "Failed to pipe file to outputstream.", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendBytes(byte[] bytes) {
        if (this.isClosed() || bytes == null) {
            return false;
        }
        try {
            this.contentLength = bytes.length;
            this.contentType = MediaType._bin.getMIME();
            this.sendHeaders();
            this.body.write(bytes);
        }
        catch (IOException e) {
            this.logger.log(Level.INFO, "Failed to pipe file to outputstream.", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean streamFrom(long contentLength, InputStream is, MediaType mediaType) {
        if (this.isClosed() || is == null) {
            return false;
        }
        try {
            int n;
            this.contentLength = contentLength;
            this.contentType = mediaType.getMIME();
            this.sendHeaders();
            byte[] buffer = new byte[4096];
            while ((n = is.read(buffer)) != -1) {
                this.body.write(buffer, 0, n);
            }
            is.close();
        }
        catch (IOException e) {
            this.logger.log(Level.INFO, "Failed to pipe file to outputstream.", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.close();
        }
        return true;
    }

    public boolean isClosed() {
        return this.isClose;
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void sendHeaders() {
        try {
            String contentType = this.getContentType() == null ? MediaType._bin.getExtension() : this.getContentType();
            this.headers.set("Content-Type", contentType);
            this.httpExchange.sendResponseHeaders(this.status, this.contentLength);
        }
        catch (IOException e) {
            this.logger.log(Level.INFO, "Failed to send headers.", e);
        }
    }

    private void close() {
        try {
            this.body.close();
            this.isClose = true;
        }
        catch (IOException e) {
            this.logger.log(Level.INFO, "Failed to close outputstream.", e);
        }
    }
}

