/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Objects;
import me.lianecx.bukkit.Metrics;
import me.lianecx.charts.SimplePie;
import me.lianecx.discordlinker.commands.DiscordCommand;
import me.lianecx.discordlinker.commands.LinkerCommand;
import me.lianecx.discordlinker.commands.LinkerTabCompleter;
import me.lianecx.discordlinker.commands.VerifyCommand;
import me.lianecx.discordlinker.events.ChatListeners;
import me.lianecx.discordlinker.events.JoinEvent;
import me.lianecx.discordlinker.events.TeamChangeEvent;
import me.lianecx.discordlinker.network.ChatType;
import me.lianecx.discordlinker.network.Router;
import me.lianecx.discordlinker.network.StatsUpdateEvent;
import me.lianecx.discordlinker.network.adapters.AdapterManager;
import me.lianecx.discordlinker.network.adapters.HttpAdapter;
import me.lianecx.discordlinker.utilities.LuckPermsUtil;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class DiscordLinker
extends JavaPlugin {
    private static final int PLUGIN_ID = 17143;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static JsonObject connJson;
    private static DiscordLinker plugin;
    private static AdapterManager adapterManager;
    private final FileConfiguration config = this.getConfig();

    public static String getPluginVersion() {
        return DiscordLinker.getPlugin().getDescription().getVersion();
    }

    public static JsonObject getConnJson() {
        return connJson;
    }

    public static DiscordLinker getPlugin() {
        return plugin;
    }

    public static AdapterManager getAdapterManager() {
        return adapterManager;
    }

    public static Gson getGson() {
        return gson;
    }

    public int getPort() {
        return this.config.getInt("port") != 0 ? this.config.getInt("port") : 11111;
    }

    public void onEnable() {
        plugin = this;
        this.saveDefaultConfig();
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            String protocol;
            HttpAdapter.checkVersion();
            try (BufferedReader connReader2 = Files.newBufferedReader(Paths.get(this.getDataFolder() + "/connection.conn", new String[0]));){
                Router.init();
                JsonElement parser = new JsonParser().parse((Reader)connReader2);
                connJson = parser.isJsonObject() ? parser.getAsJsonObject() : null;
            }
            catch (IOException connReader2) {
                // empty catch block
            }
            String string = protocol = connJson != null && connJson.get("protocol") != null ? connJson.get("protocol").getAsString() : null;
            if (protocol != null) {
                if (protocol.equals("websocket")) {
                    String token = connJson.get("token").getAsString();
                    adapterManager = new AdapterManager(token, this.getPort());
                    adapterManager.start(connected -> {
                        if (!connected.booleanValue()) {
                            return;
                        }
                        adapterManager.chat("", ChatType.START, null);
                        adapterManager.updateStatsChannel(StatsUpdateEvent.ONLINE);
                    });
                } else {
                    this.getLogger().warning(ChatColor.GOLD + "**Your server is using the deprecated backup connection method and will be disconnected. Please reconnect in Discord using `/connect`.**");
                    adapterManager.disconnectForce();
                }
            } else {
                adapterManager = new AdapterManager(this.getPort());
            }
            Metrics metrics = new Metrics(this, 17143);
            metrics.addCustomChart(new SimplePie("server_connected_with_discord", () -> connJson != null ? "true" : "false"));
            metrics.addCustomChart(new SimplePie("server_uses_http", () -> Objects.equals(protocol, "http") ? "true" : "false"));
            this.getServer().getPluginManager().registerEvents((Listener)new ChatListeners(), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new JoinEvent(), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new TeamChangeEvent(), (Plugin)this);
            this.getCommand("linker").setExecutor((CommandExecutor)new LinkerCommand());
            this.getCommand("linker").setTabCompleter((TabCompleter)new LinkerTabCompleter());
            this.getCommand("verify").setExecutor((CommandExecutor)new VerifyCommand());
            this.getCommand("discord").setExecutor((CommandExecutor)new DiscordCommand());
            if (this.hasTeamSyncedRole()) {
                TeamChangeEvent.startTeamCheck();
            }
            if (this.getServer().getPluginManager().isPluginEnabled("LuckPerms")) {
                LuckPermsUtil.init();
            }
            this.getLogger().info(ChatColor.GREEN + "Plugin enabled.");
        });
    }

    public void onDisable() {
        adapterManager.chat("", ChatType.CLOSE, null);
        adapterManager.updateStatsChannel(StatsUpdateEvent.OFFLINE);
        adapterManager.updateStatsChannel(StatsUpdateEvent.MEMBERS);
        adapterManager.stop();
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.getLogger().info(ChatColor.RED + "Plugin disabled.");
    }

    public boolean deleteConn() {
        connJson = null;
        File connection = new File(this.getDataFolder() + "/connection.conn");
        return connection.delete();
    }

    public void updateConn() throws IOException {
        FileWriter writer = new FileWriter(this.getDataFolder() + "/connection.conn");
        writer.write(connJson.toString());
        writer.close();
    }

    public void updateConn(JsonObject connJson) throws IOException {
        DiscordLinker.connJson = connJson;
        this.updateConn();
    }

    public boolean shouldChat() {
        if (connJson == null || connJson.get("channels") == null) {
            return false;
        }
        return connJson.getAsJsonArray("channels").size() > 0;
    }

    public JsonArray filterChannels(ChatType type) {
        if (!this.shouldChat()) {
            return null;
        }
        JsonArray allChannels = connJson.getAsJsonArray("channels");
        JsonArray filteredChannels = new JsonArray();
        for (JsonElement channel : allChannels) {
            try {
                JsonArray types = channel.getAsJsonObject().getAsJsonArray("types");
                if (!types.contains((JsonElement)new JsonPrimitive(type.getKey()))) continue;
                filteredChannels.add(channel);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        return filteredChannels;
    }

    public boolean shouldSendStats() {
        if (connJson == null || connJson.get("stats-channels") == null) {
            return false;
        }
        return connJson.getAsJsonArray("stats-channels").size() > 0;
    }

    public JsonArray filterChannels(StatsUpdateEvent type) {
        if (!this.shouldSendStats()) {
            return null;
        }
        JsonArray allChannels = connJson.getAsJsonArray("stats-channels");
        JsonArray filteredChannels = new JsonArray();
        for (JsonElement channel : allChannels) {
            if (!channel.getAsJsonObject().get("type").getAsString().equals(type.getJsonKey())) continue;
            filteredChannels.add(channel);
        }
        return filteredChannels;
    }

    public boolean hasTeamSyncedRole() {
        if (connJson == null || !connJson.has("synced-roles")) {
            return false;
        }
        for (JsonElement syncedRole : connJson.getAsJsonArray("synced-roles")) {
            if (syncedRole.getAsJsonObject().get("isGroup").getAsBoolean()) continue;
            return true;
        }
        return false;
    }
}

