/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.lianecx.discordlinker.DiscordLinker;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class VerifyCommand
implements CommandExecutor {
    private static final Map<UUID, String> playersAwaitingVerification = new HashMap<UUID, String>();

    public static void addPlayerToVerificationQueue(UUID uuid, String code) {
        playersAwaitingVerification.put(uuid, code);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DiscordLinker.getPlugin(), () -> {
            if (playersAwaitingVerification.containsKey(uuid)) {
                playersAwaitingVerification.remove(uuid);
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player != null) {
                    player.sendMessage(ChatColor.YELLOW + "You have been removed from the verification queue because you took too long to verify.");
                }
            }
        }, 3600L);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("You must be a player to use this command.");
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        UUID uuid = ((Player)sender).getUniqueId();
        String code = args[0];
        if (!playersAwaitingVerification.containsKey(uuid)) {
            sender.sendMessage(ChatColor.YELLOW + "You are not awaiting verification. Please execute \"/account connect\" in discord first");
            return true;
        }
        if (!playersAwaitingVerification.get(uuid).equals(code)) {
            sender.sendMessage(ChatColor.RED + "The code you specified is incorrect. Please try again.");
            return true;
        }
        playersAwaitingVerification.remove(uuid);
        DiscordLinker.getAdapterManager().sendVerificationResponse(code, uuid);
        sender.sendMessage(ChatColor.GREEN + "You have been verified successfully. You can now go back to discord.");
        return true;
    }
}

