/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker.events;

import me.lianecx.discordlinker.DiscordLinker;
import me.lianecx.discordlinker.network.ChatType;
import me.lianecx.discordlinker.network.StatsUpdateEvent;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;

public class ChatListeners
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onChatMessage(AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        String replacedMessage = ChatColor.stripColor((String)event.getMessage().replaceAll("(?i)&[0-9A-FK-OR]", ""));
        this.sendChatAsync(replacedMessage, ChatType.CHAT, event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.sendChatAsync(event.getJoinMessage(), ChatType.JOIN, event.getPlayer().getName());
        this.sendStatsAsync(StatsUpdateEvent.MEMBERS);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.sendChatAsync(event.getQuitMessage(), ChatType.QUIT, event.getPlayer().getName());
        this.sendStatsAsync(StatsUpdateEvent.MEMBERS);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onAdvancement(PlayerAdvancementDoneEvent event) {
        if (event.getAdvancement().getKey().toString().startsWith("minecraft:recipes/")) {
            return;
        }
        this.sendChatAsync(event.getAdvancement().getKey().toString(), ChatType.ADVANCEMENT, event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        this.sendChatAsync(event.getDeathMessage(), ChatType.DEATH, event.getEntity().getName());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.sendChatAsync(event.getMessage(), ChatType.PLAYER_COMMAND, event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onConsoleCommand(ServerCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ChatType commandType = event.getSender() instanceof ConsoleCommandSender ? ChatType.CONSOLE_COMMAND : ChatType.BLOCK_COMMAND;
        this.sendChatAsync(event.getCommand(), commandType, event.getSender().getName());
    }

    public void sendChatAsync(String message, ChatType type, String sender) {
        DiscordLinker.getPlugin().getServer().getScheduler().runTaskAsynchronously((Plugin)DiscordLinker.getPlugin(), () -> DiscordLinker.getAdapterManager().chat(message, type, sender));
    }

    public void sendStatsAsync(StatsUpdateEvent type) {
        DiscordLinker.getPlugin().getServer().getScheduler().runTaskAsynchronously((Plugin)DiscordLinker.getPlugin(), () -> DiscordLinker.getAdapterManager().updateStatsChannel(type));
    }
}

