/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker.events;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.UUID;
import me.lianecx.discordlinker.DiscordLinker;
import me.lianecx.discordlinker.utilities.CommandUtil;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.Team;

public class TeamChangeEvent
implements Listener {
    private static BukkitTask timer = null;

    public static void startTeamCheck() {
        timer = Bukkit.getScheduler().runTaskTimer((Plugin)DiscordLinker.getPlugin(), () -> {
            if (DiscordLinker.getConnJson() == null || !DiscordLinker.getConnJson().has("synced-roles")) {
                return;
            }
            for (JsonElement syncedRole : DiscordLinker.getConnJson().get("synced-roles").getAsJsonArray()) {
                JsonObject syncedRoleObj = syncedRole.getAsJsonObject();
                Team team = Bukkit.getServer().getScoreboardManager().getMainScoreboard().getTeam(syncedRoleObj.get("name").getAsString());
                if (team == null) continue;
                for (String entry : team.getEntries()) {
                    OfflinePlayer player = Bukkit.getOfflinePlayer((String)entry);
                    if (syncedRoleObj.get("players").getAsJsonArray().contains((JsonElement)new JsonPrimitive(player.getUniqueId().toString()))) continue;
                    DiscordLinker.getAdapterManager().addSyncedRoleMember(team.getName(), false, player.getUniqueId());
                }
                for (JsonElement uuid : syncedRoleObj.get("players").getAsJsonArray()) {
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid.getAsString()));
                    if (team.getEntries().contains(offlinePlayer.getName())) continue;
                    DiscordLinker.getAdapterManager().removeSyncedRoleMember(team.getName(), false, offlinePlayer.getUniqueId());
                }
            }
        }, 1200L, 1200L);
    }

    public static void stopTeamCheck() {
        if (timer != null) {
            timer.cancel();
        }
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        this.handleCommand((CommandSender)event.getPlayer(), event.getMessage());
    }

    @EventHandler
    public void onServerCommand(ServerCommandEvent event) {
        this.handleCommand(event.getSender(), event.getCommand());
    }

    @EventHandler
    public void onRemoteCommand(RemoteServerCommandEvent event) {
        this.handleCommand(event.getSender(), event.getCommand());
    }

    private void handleCommand(CommandSender sender, String command) {
        if (!command.startsWith("/team") && !command.startsWith("team")) {
            return;
        }
        if (!DiscordLinker.getPlugin().hasTeamSyncedRole()) {
            return;
        }
        String[] args = command.split(" ");
        switch (args[1]) {
            case "join": {
                if (args.length < 4) {
                    return;
                }
                Entity[] joinTargets = CommandUtil.getTargets(sender, args[3]);
                if (joinTargets == null) {
                    return;
                }
                for (Entity entity : joinTargets) {
                    OfflinePlayer player;
                    if (entity == null) {
                        player = Bukkit.getOfflinePlayer((String)args[3]);
                    } else {
                        if (!(entity instanceof Player)) continue;
                        player = (Player)entity;
                    }
                    Bukkit.getScheduler().runTaskLater((Plugin)DiscordLinker.getPlugin(), () -> {
                        Team team = Bukkit.getServer().getScoreboardManager().getMainScoreboard().getEntryTeam(player.getName());
                        if (team != null) {
                            DiscordLinker.getAdapterManager().addSyncedRoleMember(team.getName(), false, player.getUniqueId());
                        }
                    }, 1L);
                }
                break;
            }
            case "empty": {
                if (args.length < 3) {
                    return;
                }
                Team emptiedTeam = Bukkit.getServer().getScoreboardManager().getMainScoreboard().getTeam(args[2]);
                if (emptiedTeam == null) {
                    return;
                }
                for (String entry : emptiedTeam.getEntries()) {
                    OfflinePlayer player = Bukkit.getOfflinePlayer((String)entry);
                    DiscordLinker.getAdapterManager().removeSyncedRoleMember(emptiedTeam.getName(), false, player.getUniqueId());
                }
                break;
            }
            case "leave": {
                if (args.length < 4) {
                    return;
                }
                Entity[] leaveTargets = CommandUtil.getTargets(sender, args[2]);
                if (leaveTargets == null) {
                    return;
                }
                for (Entity entity : leaveTargets) {
                    if (!(entity instanceof Player)) continue;
                    Team previousTeam = Bukkit.getServer().getScoreboardManager().getMainScoreboard().getEntryTeam(entity.getName());
                    Bukkit.getScheduler().runTaskLater((Plugin)DiscordLinker.getPlugin(), () -> {
                        Team team = Bukkit.getServer().getScoreboardManager().getMainScoreboard().getEntryTeam(entity.getName());
                        if (team == null) {
                            DiscordLinker.getAdapterManager().removeSyncedRoleMember(previousTeam.getName(), false, entity.getUniqueId());
                        }
                    }, 1L);
                }
                break;
            }
            case "remove": {
                if (args.length < 3) {
                    return;
                }
                Team removedTeam = Bukkit.getServer().getScoreboardManager().getMainScoreboard().getTeam(args[2]);
                if (removedTeam == null) break;
                DiscordLinker.getAdapterManager().removeSyncedRole(removedTeam.getName(), false);
            }
        }
    }
}

