/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker.network;

import com.google.gson.JsonObject;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.lianecx.discordlinker.network.Router;

public enum Route {
    GET_FILE("/file/get", "get-file", Router::getFile),
    PUT_FILE("/file/put", "put-file", null),
    LIST_FILE("/file/list", "list-file", Router::listFile),
    VERIFY_USER("/verify/user", "verify-user", Router::verifyUser),
    COMMAND("/command", "command", Router::command),
    GET_PLAYER_NBT("/player/nbt", "get-player-nbt", Router::getPlayerNBT),
    CHAT("/chat", "chat", Router::chat),
    DISCONNECT("/disconnect", "disconnect", Router::disconnect),
    CONNECT("/connect", null, Router::connect, false),
    CHAT_CHANNEL_REMOVE("/channel/remove", "remove-channel", Router::removeChatChannel),
    CHAT_CHANNEL_ADD("/channel/add", "add-channel", Router::addChatChannel),
    STATS_CHANNEL_REMOVE("/stats-channel/remove", "remove-stats-channel", Router::removeStatsChannel),
    STATS_CHANNEL_ADD("/stats-channel/add", "add-stats-channel", Router::addStatsChannel),
    SYNCED_ROLE_ADD("/synced-role/add", "add-synced-role", Router::addSyncedRole),
    SYNCED_ROLE_REMOVE("/synced-role/remove", "remove-synced-role", Router::removeSyncedRole),
    SYNCED_ROLE_ADD_MEMBER("/synced-role/add-member", "add-synced-role-member", Router::addSyncedRoleMember),
    SYNCED_ROLE_REMOVE_MEMBER("/synced-role/remove-member", "remove-synced-role-member", Router::removeSyncedRoleMember),
    LIST_PLAYERS("/players", "list-players", Router::listPlayers),
    LIST_TEAMS_AND_GROUPS("/teams-and-groups", "list-teams-and-groups", Router::listGroupsAndTeams),
    ROOT("/", null, null, false, false);

    private final String eventName;
    private final String path;
    private final BiConsumer<JsonObject, Consumer<Router.RouterResponse>> function;
    private final boolean requiresToken;
    private final boolean botOnly;

    private Route(String routeString, String eventName, BiConsumer<JsonObject, Consumer<Router.RouterResponse>> function) {
        this.path = routeString;
        this.eventName = eventName;
        this.function = function;
        this.requiresToken = true;
        this.botOnly = true;
    }

    private Route(String routeString, String eventName, BiConsumer<JsonObject, Consumer<Router.RouterResponse>> function, boolean requiresToken) {
        this.path = routeString;
        this.eventName = eventName;
        this.function = function;
        this.requiresToken = requiresToken;
        this.botOnly = true;
    }

    private Route(String routeString, String eventName, BiConsumer<JsonObject, Consumer<Router.RouterResponse>> function, boolean requiresToken, boolean botOnly) {
        this.path = routeString;
        this.eventName = eventName;
        this.function = function;
        this.requiresToken = requiresToken;
        this.botOnly = botOnly;
    }

    public static Route getRouteByPath(String path) {
        for (Route route : Route.values()) {
            if (route.getPath() == null || !route.getPath().equals(path)) continue;
            return route;
        }
        return null;
    }

    public static Route getRouteByEventName(String eventName) {
        for (Route route : Route.values()) {
            if (route.getEventName() == null || !route.getEventName().equals(eventName)) continue;
            return route;
        }
        return null;
    }

    public void execute(JsonObject data, Consumer<Router.RouterResponse> callback) {
        this.function.accept(data, callback);
    }

    public String getPath() {
        return this.path;
    }

    public String getEventName() {
        return this.eventName;
    }

    public boolean doesRequireToken() {
        return this.requiresToken;
    }

    public boolean isBotOnly() {
        return this.botOnly;
    }
}

