/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import express.utils.Status;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lianecx.discordlinker.DiscordLinker;
import me.lianecx.discordlinker.commands.VerifyCommand;
import me.lianecx.discordlinker.events.TeamChangeEvent;
import me.lianecx.discordlinker.utilities.ConsoleLogger;
import me.lianecx.discordlinker.utilities.LuckPermsUtil;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Team;

public class Router {
    public static final JsonObject INVALID_AUTH = new JsonObject();
    public static final JsonObject INVALID_PATH = new JsonObject();
    public static final JsonObject INVALID_PARAM = new JsonObject();
    public static final JsonObject INVALID_JSON = new JsonObject();
    public static final JsonObject INVALID_CODE = new JsonObject();
    public static final JsonObject INVALID_PLAYER = new JsonObject();
    public static final JsonObject INVALID_TEAM = new JsonObject();
    public static final JsonObject INVALID_GROUP = new JsonObject();
    public static final JsonObject ALREADY_CONNECTED = new JsonObject();
    public static final JsonObject LUCKPERMS_NOT_LOADED = new JsonObject();
    public static final JsonObject NBT_PARSE_ERROR = new JsonObject();
    public static final JsonObject SUCCESS = new JsonObject();
    private static final ConsoleLogger cmdLogger = new ConsoleLogger();
    private static final String URL_REGEX = "https?://[-\\w_.]{2,}\\.[a-z]{2,4}/\\S*?";
    private static final String MD_URL_REGEX = "(?i)\\[([^]]+)]\\((https?://[-\\w_.]{2,}\\.[a-z]{2,4}/\\S*?)\\)";
    private static String verifyCode = null;

    public static void init() throws IOException {
        INVALID_AUTH.addProperty("message", "Invalid Authorization");
        INVALID_PATH.addProperty("message", "Invalid Path");
        INVALID_PARAM.addProperty("message", "Invalid method parameter");
        INVALID_JSON.addProperty("message", "Invalid JSON");
        INVALID_PLAYER.addProperty("message", "Target player does not exist or is not online");
        INVALID_TEAM.addProperty("message", "Target team does not exist");
        INVALID_GROUP.addProperty("message", "Target group does not exist");
        ALREADY_CONNECTED.addProperty("message", "This plugin is already connected with a different guild.");
        INVALID_CODE.addProperty("message", "Invalid verification code");
        LUCKPERMS_NOT_LOADED.addProperty("message", "LuckPerms is not loaded");
        NBT_PARSE_ERROR.addProperty("message", "Could not parse NBT data");
        Logger log = (Logger)LogManager.getRootLogger();
        log.addAppender(cmdLogger);
    }

    public static void getFile(JsonObject data, Consumer<RouterResponse> callback) {
        try {
            File file = new File(URLDecoder.decode(data.get("path").getAsString(), "utf-8"));
            if (!file.isFile()) {
                callback.accept(new RouterResponse(Status._404, INVALID_PATH.toString()));
                return;
            }
            callback.accept(new RouterResponse(Status._200, file.toString(), true));
        }
        catch (UnsupportedEncodingException err) {
            JsonObject error = new JsonObject();
            error.addProperty("message", err.toString());
            callback.accept(new RouterResponse(Status._500, error.toString()));
        }
    }

    public static void putFile(JsonObject data, InputStream fileStream, Consumer<RouterResponse> callback) {
        try (FileOutputStream outputStream = new FileOutputStream(URLDecoder.decode(data.get("path").getAsString(), "utf-8"));){
            int length;
            byte[] buf = new byte[8192];
            while ((length = fileStream.read(buf)) > 0) {
                outputStream.write(buf, 0, length);
            }
            callback.accept(new RouterResponse(Status._200, SUCCESS.toString()));
        }
        catch (IOException err) {
            JsonObject error = new JsonObject();
            error.addProperty("message", err.toString());
            callback.accept(new RouterResponse(Status._500, error.toString()));
        }
    }

    public static void listFile(JsonObject data, Consumer<RouterResponse> callback) {
        try {
            Path folder = Paths.get(URLDecoder.decode(data.get("folder").getAsString(), "utf-8"), new String[0]);
            JsonArray content = new JsonArray();
            Stream<Path> stream = Files.list(folder);
            stream.map(path -> {
                JsonObject object = new JsonObject();
                object.addProperty("name", path.toFile().getName());
                object.addProperty("isDirectory", Boolean.valueOf(path.toFile().isDirectory()));
                return object;
            }).forEach(arg_0 -> ((JsonArray)content).add(arg_0));
            stream.close();
            callback.accept(new RouterResponse(Status._200, content.toString()));
        }
        catch (InvalidPathException err) {
            callback.accept(new RouterResponse(Status._404, INVALID_PATH.toString()));
        }
        catch (IOException err) {
            callback.accept(new RouterResponse(Status._200, new JsonArray().toString()));
        }
    }

    public static void verifyUser(JsonObject data, Consumer<RouterResponse> callback) {
        VerifyCommand.addPlayerToVerificationQueue(UUID.fromString(data.get("uuid").getAsString()), data.get("code").getAsString());
        callback.accept(new RouterResponse(Status._200, SUCCESS.toString()));
    }

    public static void command(JsonObject data, Consumer<RouterResponse> callback) {
        Bukkit.getScheduler().runTask((Plugin)DiscordLinker.getPlugin(), () -> {
            JsonObject responseJson = new JsonObject();
            try {
                String cmd = URLDecoder.decode(data.get("cmd").getAsString(), "utf-8");
                DiscordLinker.getPlugin().getLogger().info(ChatColor.AQUA + "Command from Discord: /" + cmd);
                cmdLogger.startLogging();
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmd.trim());
            }
            catch (UnsupportedEncodingException | IllegalArgumentException | CommandException err) {
                responseJson.addProperty("message", err.toString());
                callback.accept(new RouterResponse(Status._500, responseJson.toString()));
                cmdLogger.clearData();
                return;
            }
            finally {
                cmdLogger.stopLogging();
            }
            String commandResponse = String.join((CharSequence)"\n", cmdLogger.getData());
            cmdLogger.clearData();
            responseJson.addProperty("message", commandResponse.replaceAll("\\x7F", "&"));
            callback.accept(new RouterResponse(Status._200, responseJson.toString()));
        });
    }

    public static void getPlayerNBT(JsonObject data, Consumer<RouterResponse> callback) {
        Player player = Bukkit.getServer().getPlayer(UUID.fromString(data.get("uuid").getAsString()));
        if (player == null) {
            callback.accept(new RouterResponse(Status._422, INVALID_PLAYER.toString()));
            return;
        }
        JsonObject responseJson = new JsonObject();
        responseJson.addProperty("data", NBTEditor.getNBTCompound(player, new Object[0]).toJson());
        if (responseJson.get("data").getAsString().equals("{}")) {
            callback.accept(new RouterResponse(Status._500, NBT_PARSE_ERROR.toString()));
            return;
        }
        callback.accept(new RouterResponse(Status._200, responseJson.toString()));
    }

    public static void chat(JsonObject data, Consumer<RouterResponse> callback) {
        boolean privateMsg;
        String username;
        String replyMsg;
        String msg;
        String replyUsername = "";
        String targetUsername = "";
        try {
            msg = data.get("msg").getAsString();
            replyMsg = data.has("reply_msg") && !data.get("reply_msg").isJsonNull() ? data.get("reply_msg").getAsString() : null;
            username = data.get("username").getAsString();
            privateMsg = data.get("private").getAsBoolean();
            if (replyMsg != null) {
                replyUsername = data.get("reply_username").getAsString();
            }
            if (privateMsg) {
                targetUsername = data.get("target").getAsString();
            }
        }
        catch (ClassCastException err) {
            callback.accept(new RouterResponse(Status._400, INVALID_JSON.toString()));
            return;
        }
        String configPath = privateMsg ? "private_message" : (replyMsg != null ? "reply_message" : "message");
        String chatMessage = DiscordLinker.getPlugin().getConfig().getString(configPath);
        chatMessage = chatMessage.replaceAll("%message%", Router.markdownToColorCodes(msg));
        if (replyMsg != null) {
            String reducedReplyMsg;
            chatMessage = chatMessage.replaceAll("%reply_message%", Router.markdownToColorCodes(replyMsg));
            chatMessage = chatMessage.replaceAll("%reply_username%", replyUsername);
            String string = reducedReplyMsg = replyMsg.length() > 30 ? replyMsg.substring(0, 30) + "..." : replyMsg;
            if (replyMsg.matches(URL_REGEX) || replyMsg.matches(MD_URL_REGEX)) {
                reducedReplyMsg = replyMsg;
            }
            chatMessage = chatMessage.replaceAll("%reply_message_reduced%", Router.markdownToColorCodes(reducedReplyMsg));
        }
        chatMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)chatMessage);
        chatMessage = chatMessage.replaceAll("%username%", username);
        Pattern mdUrlPattern = Pattern.compile(MD_URL_REGEX);
        ComponentBuilder chatBuilder = new ComponentBuilder("");
        StringBuilder tempMessage = new StringBuilder();
        for (String word : chatMessage.split(" ")) {
            if (word.matches(URL_REGEX)) {
                if (tempMessage.length() != 0) {
                    chatBuilder.append(tempMessage.toString(), ComponentBuilder.FormatRetention.NONE);
                }
                tempMessage.setLength(0);
                chatBuilder.append(word);
                chatBuilder.event(new ClickEvent(ClickEvent.Action.OPEN_URL, word));
                chatBuilder.underlined(true);
                tempMessage.append(" ");
                continue;
            }
            if (word.matches(MD_URL_REGEX)) {
                if (tempMessage.length() != 0) {
                    chatBuilder.append(tempMessage.toString(), ComponentBuilder.FormatRetention.NONE);
                }
                tempMessage.setLength(0);
                Matcher matcher = mdUrlPattern.matcher(word);
                matcher.find();
                chatBuilder.append(matcher.group(1));
                chatBuilder.event(new ClickEvent(ClickEvent.Action.OPEN_URL, matcher.group(2)));
                chatBuilder.underlined(true);
                tempMessage.append(" ");
                continue;
            }
            tempMessage.append(word).append(" ");
        }
        if (tempMessage.length() != 0) {
            chatBuilder.append(tempMessage.toString(), ComponentBuilder.FormatRetention.NONE);
        }
        if (privateMsg) {
            Player player = Bukkit.getServer().getPlayer(targetUsername);
            if (player == null) {
                callback.accept(new RouterResponse(Status._422, INVALID_PLAYER.toString()));
                return;
            }
            player.spigot().sendMessage(chatBuilder.create());
        } else {
            Bukkit.getServer().spigot().broadcast(chatBuilder.create());
        }
        callback.accept(new RouterResponse(Status._200, SUCCESS.toString()));
    }

    public static void disconnect(JsonObject data, Consumer<RouterResponse> callback) {
        boolean deleted = DiscordLinker.getPlugin().deleteConn();
        if (deleted) {
            DiscordLinker.getPlugin().getLogger().info("Disconnected from discord...");
            callback.accept(new RouterResponse(Status._200, SUCCESS.toString()));
        } else {
            JsonObject error = new JsonObject();
            error.addProperty("message", "Could not delete connection file");
            callback.accept(new RouterResponse(Status._500, error.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void connect(JsonObject data, Consumer<RouterResponse> callback) {
        try {
            DiscordLinker.getPlugin().getLogger().info("Connection request...");
            if (!data.get("code").getAsString().equals(verifyCode)) {
                DiscordLinker.getPlugin().getLogger().info("Connection unsuccessful");
                callback.accept(new RouterResponse(Status._401, INVALID_CODE.toString()));
                return;
            }
            String token = new BigInteger(130, new SecureRandom()).toString(16);
            JsonObject connJson = new JsonObject();
            connJson.add("channels", (JsonElement)new JsonArray());
            connJson.add("stats-channels", (JsonElement)new JsonArray());
            connJson.add("id", data.get("id"));
            connJson.add("ip", data.get("ip"));
            if (data.has("requiredRoleToJoin") && !data.get("requiredRoleToJoin").isJsonNull()) {
                connJson.add("requiredRoleToJoin", data.get("requiredRoleToJoin"));
            }
            connJson.addProperty("protocol", "http");
            connJson.addProperty("hash", Router.createHash(token));
            DiscordLinker.getPlugin().updateConn(connJson);
            DiscordLinker.getPlugin().getLogger().info("Successfully connected to Discord!");
            JsonObject connectResponse = Router.getConnectResponse();
            connectResponse.addProperty("token", token);
            callback.accept(new RouterResponse(Status._200, connectResponse.toString()));
        }
        catch (IOException | NoSuchAlgorithmException err) {
            DiscordLinker.getPlugin().getLogger().info("Connection unsuccessful");
            callback.accept(new RouterResponse(Status._500, err.toString()));
        }
        finally {
            verifyCode = null;
        }
    }

    public static void addChatChannel(JsonObject data, Consumer<RouterResponse> callback) {
        callback.accept(Router.handleChangeArray(data, "channels", "add"));
    }

    public static void removeChatChannel(JsonObject data, Consumer<RouterResponse> callback) {
        callback.accept(Router.handleChangeArray(data, "channels", "remove"));
    }

    public static void addStatsChannel(JsonObject data, Consumer<RouterResponse> callback) {
        callback.accept(Router.handleChangeArray(data, "stats-channels", "add"));
    }

    public static void removeStatsChannel(JsonObject data, Consumer<RouterResponse> callback) {
        callback.accept(Router.handleChangeArray(data, "stats-channels", "remove"));
    }

    public static void addSyncedRole(JsonObject data, Consumer<RouterResponse> callback) {
        boolean hadTeamSyncedRole = DiscordLinker.getPlugin().hasTeamSyncedRole();
        if (data.get("isGroup").getAsBoolean()) {
            if (!Bukkit.getPluginManager().isPluginEnabled("LuckPerms")) {
                callback.accept(new RouterResponse(Status._501, LUCKPERMS_NOT_LOADED.toString()));
                return;
            }
            LuckPermsUtil.updateGroupMembers(data.get("name").getAsString(), (List)DiscordLinker.getGson().fromJson(data.get("players"), new TypeToken<List<String>>(){}.getType()), true, response -> Router.getPlayers(data.get("name").getAsString(), true, players -> {
                if (players == null) {
                    callback.accept(new RouterResponse(Status._404, INVALID_GROUP.toString()));
                    return;
                }
                data.add("players", DiscordLinker.getGson().toJsonTree(players));
                callback.accept(Router.handleChangeArray(data, "synced-roles", "add"));
            }));
        } else {
            Team team = Bukkit.getServer().getScoreboardManager().getMainScoreboard().getTeam(data.get("name").getAsString());
            if (team == null) {
                callback.accept(new RouterResponse(Status._404, INVALID_TEAM.toString()));
                return;
            }
            for (JsonElement uuid : data.get("players").getAsJsonArray()) {
                OfflinePlayer player = Bukkit.getServer().getOfflinePlayer(UUID.fromString(uuid.getAsString()));
                if (team.getEntries().contains(player.getName())) continue;
                team.addEntry(player.getName());
            }
            Router.getPlayers(data.get("name").getAsString(), false, players -> {
                if (players == null) {
                    callback.accept(new RouterResponse(Status._404, INVALID_TEAM.toString()));
                    return;
                }
                data.add("players", DiscordLinker.getGson().toJsonTree(players));
                callback.accept(Router.handleChangeArray(data, "synced-roles", "add"));
            });
        }
        boolean hasTeamSyncedRole = DiscordLinker.getPlugin().hasTeamSyncedRole();
        if (!hadTeamSyncedRole && hasTeamSyncedRole) {
            TeamChangeEvent.startTeamCheck();
        }
    }

    public static void removeSyncedRole(JsonObject data, Consumer<RouterResponse> callback) {
        boolean hadTeamSyncedRole = DiscordLinker.getPlugin().hasTeamSyncedRole();
        callback.accept(Router.handleChangeArray(data, "synced-roles", "remove"));
        boolean hasTeamSyncedRole = DiscordLinker.getPlugin().hasTeamSyncedRole();
        if (hadTeamSyncedRole && !hasTeamSyncedRole) {
            TeamChangeEvent.stopTeamCheck();
        }
    }

    public static void listPlayers(JsonObject data, Consumer<RouterResponse> callback) {
        List onlinePlayers = Bukkit.getServer().getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList());
        callback.accept(new RouterResponse(Status._200, DiscordLinker.getGson().toJson(onlinePlayers)));
    }

    public static void addSyncedRoleMember(JsonObject data, Consumer<RouterResponse> callback) {
        Router.updateSyncedRoleMember(data.get("name").getAsString(), UUID.fromString(data.get("uuid").getAsString()), data.get("isGroup").getAsBoolean(), "add", callback);
    }

    public static void removeSyncedRoleMember(JsonObject data, Consumer<RouterResponse> callback) {
        Router.updateSyncedRoleMember(data.get("name").getAsString(), UUID.fromString(data.get("uuid").getAsString()), data.get("isGroup").getAsBoolean(), "remove", callback);
    }

    public static void listGroupsAndTeams(JsonObject data, Consumer<RouterResponse> callback) {
        List<Object> groups = new ArrayList();
        ArrayList teams = new ArrayList();
        if (Bukkit.getPluginManager().isPluginEnabled("LuckPerms")) {
            groups = LuckPermsUtil.getGroupNames();
        }
        Bukkit.getServer().getScoreboardManager().getMainScoreboard().getTeams().forEach(team -> teams.add(team.getName()));
        JsonObject response = new JsonObject();
        response.add("groups", DiscordLinker.getGson().toJsonTree(groups));
        response.add("teams", DiscordLinker.getGson().toJsonTree(teams));
        callback.accept(new RouterResponse(Status._200, response.toString()));
    }

    private static String markdownToColorCodes(String markdown) {
        markdown = markdown.replaceAll("\\*\\*(.+?)\\*\\*", "&l$1&r");
        markdown = markdown.replaceAll("__(.+?)__", "&n$1&r");
        markdown = markdown.replaceAll("_(.+?)_|\\*(.+?)\\*", "&o$1$2&r");
        markdown = markdown.replaceAll("~~(.+?)~~", "&m$1&r");
        markdown = markdown.replaceAll("\\?\\?(.+?)\\?\\?", "&k$1&r");
        markdown = markdown.replaceAll("(?s)```[^\\n]*\\n(.+)```|```(.+)```", "&7&n$1$2&r");
        markdown = markdown.replaceAll("`(.+?)`", "&7&n$1&r");
        markdown = markdown.replaceAll("\\|\\|(.+?)\\|\\|", "&8$1&r");
        markdown = markdown.replaceAll(">+ (.+)", "&7| $1&r");
        return markdown;
    }

    public static RouterResponse handleChangeArray(JsonObject entry, String jsonFieldName, String addOrRemove) {
        try {
            JsonObject connJson = DiscordLinker.getConnJson();
            JsonArray array = !connJson.has(jsonFieldName) ? new JsonArray() : connJson.get(jsonFieldName).getAsJsonArray();
            for (JsonElement jsonEntry : array) {
                if (!jsonEntry.getAsJsonObject().get("id").getAsString().equals(entry.get("id").getAsString())) continue;
                array.remove(jsonEntry);
                break;
            }
            if (addOrRemove.equals("add")) {
                array.add((JsonElement)entry);
            }
            connJson.add(jsonFieldName, (JsonElement)array);
            DiscordLinker.getPlugin().updateConn(connJson);
            return new RouterResponse(Status._200, array.toString());
        }
        catch (IOException err) {
            JsonObject error = new JsonObject();
            error.addProperty("message", err.toString());
            return new RouterResponse(Status._500, error.toString());
        }
    }

    private static void updateSyncedRoleMember(String name, UUID uuid, boolean isGroup, String addOrRemove, Consumer<RouterResponse> callback) {
        if (isGroup) {
            if (!Bukkit.getPluginManager().isPluginEnabled("LuckPerms")) {
                callback.accept(new RouterResponse(Status._501, LUCKPERMS_NOT_LOADED.toString()));
                return;
            }
            LuckPermsUtil.updateUserGroup(name, uuid, addOrRemove, response -> {
                if (response.getStatus() != Status._200) {
                    callback.accept((RouterResponse)response);
                    return;
                }
                DiscordLinker.getAdapterManager().getSyncedRole(name, true, syncedRole -> {
                    if (syncedRole == null) {
                        callback.accept(new RouterResponse(Status._404, INVALID_GROUP.toString()));
                        return;
                    }
                    callback.accept(new RouterResponse(Status._200, DiscordLinker.getGson().toJson((JsonElement)syncedRole.getAsJsonArray("players"))));
                });
            });
        } else {
            Team team = Bukkit.getServer().getScoreboardManager().getMainScoreboard().getTeam(name);
            if (team == null) {
                callback.accept(new RouterResponse(Status._404, INVALID_TEAM.toString()));
                return;
            }
            OfflinePlayer player = Bukkit.getServer().getOfflinePlayer(uuid);
            if (addOrRemove.equals("add") && !team.getEntries().contains(player.getName())) {
                team.addEntry(player.getName());
            } else if (addOrRemove.equals("remove") && team.getEntries().contains(player.getName())) {
                team.removeEntry(player.getName());
            }
            DiscordLinker.getAdapterManager().getSyncedRole(name, false, syncedRole -> {
                if (syncedRole == null) {
                    callback.accept(new RouterResponse(Status._404, INVALID_TEAM.toString()));
                    return;
                }
                callback.accept(new RouterResponse(Status._200, DiscordLinker.getGson().toJson((JsonElement)syncedRole.getAsJsonArray("players"))));
            });
        }
    }

    public static void getPlayers(String name, boolean isGroup, Consumer<List<String>> callback) {
        if (isGroup) {
            if (!Bukkit.getPluginManager().isPluginEnabled("LuckPerms")) {
                callback.accept(new ArrayList());
                return;
            }
            LuckPermsUtil.getGroupMembers(name, callback);
        } else {
            Team team = Bukkit.getServer().getScoreboardManager().getMainScoreboard().getTeam(name);
            if (team == null) {
                callback.accept(null);
                return;
            }
            ArrayList players = new ArrayList();
            team.getEntries().forEach(entry -> {
                OfflinePlayer player = Bukkit.getServer().getOfflinePlayer(entry);
                if (player != null) {
                    players.add(player.getUniqueId().toString());
                }
            });
            callback.accept(players);
        }
    }

    public static String createHash(String originalString) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hashBytes = digest.digest(originalString.getBytes(StandardCharsets.UTF_8));
        StringBuilder hexString = new StringBuilder(2 * hashBytes.length);
        for (byte hashByte : hashBytes) {
            String hex = Integer.toHexString(0xFF & hashByte);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static JsonObject getConnectResponse() {
        try {
            boolean isMinehut = Bukkit.getPluginManager().isPluginEnabled("MinehutPlugin");
            boolean usesOfflineUUIDs = Bukkit.getServer().getOfflinePlayers()[0] != null && Bukkit.getServer().getOfflinePlayers()[0].getUniqueId().version() == 3;
            JsonObject response = new JsonObject();
            response.addProperty("version", Bukkit.getServer().getBukkitVersion().split("-")[0]);
            response.addProperty("online", Boolean.valueOf(isMinehut || !usesOfflineUUIDs || Bukkit.getServer().getOnlineMode()));
            response.addProperty("worldPath", URLEncoder.encode(Router.getWorldPath(), "utf-8"));
            response.addProperty("path", URLEncoder.encode(Bukkit.getServer().getWorldContainer().getCanonicalPath(), "utf-8"));
            response.addProperty("floodgatePrefix", Router.getFloodgatePrefix());
            return response;
        }
        catch (IOException err) {
            return null;
        }
    }

    private static String getWorldPath() throws IOException {
        Properties serverProperties = new Properties();
        serverProperties.load(Files.newInputStream(Paths.get("server.properties", new String[0]), new OpenOption[0]));
        String worldName = serverProperties.getProperty("level-name");
        return Paths.get(Bukkit.getServer().getWorldContainer().getCanonicalPath(), worldName).toString();
    }

    private static String getFloodgatePrefix() {
        File floodgateConfig = new File("plugins/floodgate/config.yml");
        if (!floodgateConfig.exists()) {
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)floodgateConfig);
        return config.getString("username-prefix");
    }

    public static class RouterResponse {
        private final String message;
        private final Status status;
        private final boolean isAttachment;

        public RouterResponse(Status status, String message) {
            this.status = status;
            this.message = message;
            this.isAttachment = false;
        }

        public RouterResponse(Status status, String message, boolean isAttachment) {
            this.status = status;
            this.message = message;
            this.isAttachment = isAttachment;
        }

        public String getMessage() {
            return this.message;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isAttachment() {
            return this.isAttachment;
        }

        public JsonElement getJson() {
            return new JsonParser().parse(this.message);
        }
    }
}

